/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.lib.util.VersionChecker;
import de.teamlapen.vampirism_integrations.VampirismIntegrationsMod;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.server.command.CommandTreeBase;

public class Command
extends CommandTreeBase {
    public Command() {
        this.addSubcommand((ICommand)new CommandBase(){

            public String func_71517_b() {
                return "loaded";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b();
            }

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                sender.func_145747_a((ITextComponent)new TextComponentString("Loaded and active mods:"));
                Map activeMods = Loader.instance().getIndexedModList();
                sender.func_145747_a((ITextComponent)new TextComponentString("Vampirism Version: " + ((ModContainer)activeMods.get("vampirism")).getVersion()));
            }
        });
        this.addSubcommand((ICommand)new CommandBase(){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
                if (!VampirismIntegrationsMod.instance.getVersionInfo().isNewVersionAvailable()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("There is no new version available"));
                    return;
                }
                VersionChecker.Version newVersion = VampirismIntegrationsMod.instance.getVersionInfo().getNewVersion();
                List changes = newVersion.getChanges();
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Vampirism " + newVersion.name + "(" + "1.12.2" + ")"));
                for (String c : changes) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("-" + c));
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                String template = UtilLib.translate((String)"text.vampirism.update_message");
                String homepage = VampirismIntegrationsMod.instance.getVersionInfo().getHomePage();
                template = template.replaceAll("@download@", newVersion.getUrl() == null ? homepage : newVersion.getUrl()).replaceAll("@forum@", homepage);
                ITextComponent component = ITextComponent.Serializer.func_150699_a((String)template);
                sender.func_145747_a(component);
            }

            public String func_71517_b() {
                return "changelog";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b();
            }
        });
    }

    public String func_71517_b() {
        return "vampirism-integrations";
    }

    public String func_71518_a(ICommandSender sender) {
        return this.func_71517_b() + " <subcommand>";
    }
}

