/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IParts;
import appeng.api.storage.ITerminalHost;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.MathExpressionParser;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketCraftRequest;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.parts.reporting.PartCraftingTerminal;
import appeng.parts.reporting.PartExpandedProcessingPatternTerminal;
import appeng.parts.reporting.PartPatternTerminal;
import appeng.parts.reporting.PartTerminal;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

public class GuiCraftAmount
extends AEBaseGui {
    private GuiTextField amountToCraft;
    private GuiTabButton originalGuiBtn;
    private GuiButton next;
    private GuiButton plus1;
    private GuiButton plus10;
    private GuiButton plus100;
    private GuiButton plus1000;
    private GuiButton minus1;
    private GuiButton minus10;
    private GuiButton minus100;
    private GuiButton minus1000;
    private GuiBridge originalGui;

    public GuiCraftAmount(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        super(new ContainerCraftAmount(inventoryPlayer, te));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int a = AEConfig.instance().craftItemsByStackAmounts(0);
        int b = AEConfig.instance().craftItemsByStackAmounts(1);
        int c = AEConfig.instance().craftItemsByStackAmounts(2);
        int d = AEConfig.instance().craftItemsByStackAmounts(3);
        this.plus1 = new GuiButton(0, this.field_147003_i + 20, this.field_147009_r + 26, 22, 20, "+" + a);
        this.field_146292_n.add(this.plus1);
        this.plus10 = new GuiButton(0, this.field_147003_i + 48, this.field_147009_r + 26, 28, 20, "+" + b);
        this.field_146292_n.add(this.plus10);
        this.plus100 = new GuiButton(0, this.field_147003_i + 82, this.field_147009_r + 26, 32, 20, "+" + c);
        this.field_146292_n.add(this.plus100);
        this.plus1000 = new GuiButton(0, this.field_147003_i + 120, this.field_147009_r + 26, 38, 20, "+" + d);
        this.field_146292_n.add(this.plus1000);
        this.minus1 = new GuiButton(0, this.field_147003_i + 20, this.field_147009_r + 75, 22, 20, "-" + a);
        this.field_146292_n.add(this.minus1);
        this.minus10 = new GuiButton(0, this.field_147003_i + 48, this.field_147009_r + 75, 28, 20, "-" + b);
        this.field_146292_n.add(this.minus10);
        this.minus100 = new GuiButton(0, this.field_147003_i + 82, this.field_147009_r + 75, 32, 20, "-" + c);
        this.field_146292_n.add(this.minus100);
        this.minus1000 = new GuiButton(0, this.field_147003_i + 120, this.field_147009_r + 75, 38, 20, "-" + d);
        this.field_146292_n.add(this.minus1000);
        this.next = new GuiButton(0, this.field_147003_i + 128, this.field_147009_r + 51, 38, 20, GuiText.Next.getLocal());
        this.field_146292_n.add(this.next);
        ItemStack myIcon = null;
        Object target = ((AEBaseContainer)this.field_147002_h).getTarget();
        IDefinitions definitions = AEApi.instance().definitions();
        IParts parts = definitions.parts();
        if (target instanceof WirelessTerminalGuiObject) {
            myIcon = ((WirelessTerminalGuiObject)target).getItemStack();
            this.originalGui = (GuiBridge)AEApi.instance().registries().wireless().getWirelessTerminalHandler(myIcon).getGuiHandler(myIcon);
        }
        if (target instanceof PartTerminal) {
            myIcon = parts.terminal().maybeStack(1).orElse(ItemStack.field_190927_a);
            this.originalGui = GuiBridge.GUI_ME;
        }
        if (target instanceof PartCraftingTerminal) {
            myIcon = parts.craftingTerminal().maybeStack(1).orElse(ItemStack.field_190927_a);
            this.originalGui = GuiBridge.GUI_CRAFTING_TERMINAL;
        }
        if (target instanceof PartPatternTerminal) {
            myIcon = parts.patternTerminal().maybeStack(1).orElse(ItemStack.field_190927_a);
            this.originalGui = GuiBridge.GUI_PATTERN_TERMINAL;
        }
        if (target instanceof PartExpandedProcessingPatternTerminal) {
            myIcon = parts.expandedProcessingPatternTerminal().maybeStack(1).orElse(ItemStack.field_190927_a);
            this.originalGui = GuiBridge.GUI_EXPANDED_PROCESSING_PATTERN_TERMINAL;
        }
        if (this.originalGui != null && !myIcon.func_190926_b()) {
            this.originalGuiBtn = new GuiTabButton(this.field_147003_i + 154, this.field_147009_r, myIcon, myIcon.func_82833_r(), this.field_146296_j);
            this.field_146292_n.add(this.originalGuiBtn);
        }
        this.amountToCraft = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 62, this.field_147009_r + 57, 59, this.field_146289_q.field_78288_b);
        this.amountToCraft.func_146185_a(false);
        this.amountToCraft.func_146203_f(16);
        this.amountToCraft.func_146193_g(0xFFFFFF);
        this.amountToCraft.func_146189_e(true);
        this.amountToCraft.func_146195_b(true);
        this.amountToCraft.func_146180_a("1");
        this.amountToCraft.func_146199_i(0);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(GuiText.SelectAmount.getLocal(), 8, 6, 0x404040);
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.next.field_146126_j = GuiCraftAmount.func_146272_n() ? GuiText.Start.getLocal() : GuiText.Next.getLocal();
        this.bindTexture("guis/craft_amt.png");
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
        try {
            String out = this.amountToCraft.func_146179_b();
            double resultD = MathExpressionParser.parse(out);
            long amt = resultD <= 0.0 || Double.isNaN(resultD) ? 0L : (long)MathExpressionParser.round(resultD, 0);
            this.next.field_146124_l = amt > 0L;
        }
        catch (NumberFormatException e) {
            this.next.field_146124_l = false;
        }
        this.amountToCraft.func_146194_f();
    }

    protected void func_73869_a(char character, int key) throws IOException {
        if (!this.func_146983_a(key)) {
            if (key == 28 || key == 156) {
                this.func_146284_a(this.next);
            }
            if (!this.amountToCraft.func_146201_a(character, key)) {
                super.func_73869_a(character, key);
            }
        }
    }

    protected void func_146284_a(GuiButton btn) throws IOException {
        boolean isMinus;
        super.func_146284_a(btn);
        try {
            if (btn == this.originalGuiBtn) {
                NetworkHandler.instance().sendToServer(new PacketSwitchGuis(this.originalGui));
            }
            if (btn == this.next) {
                double resultD = MathExpressionParser.parse(this.amountToCraft.func_146179_b());
                int result = resultD <= 0.0 || Double.isNaN(resultD) ? 1 : (int)MathExpressionParser.round(resultD, 0);
                NetworkHandler.instance().sendToServer(new PacketCraftRequest(result, GuiCraftAmount.func_146272_n()));
            }
        }
        catch (NumberFormatException e) {
            this.amountToCraft.func_146180_a("1");
        }
        boolean isPlus = btn == this.plus1 || btn == this.plus10 || btn == this.plus100 || btn == this.plus1000;
        boolean bl = isMinus = btn == this.minus1 || btn == this.minus10 || btn == this.minus100 || btn == this.minus1000;
        if (isPlus || isMinus) {
            this.addQty(this.getQty(btn));
        }
    }

    private void addQty(int i) {
        try {
            String out = this.amountToCraft.func_146179_b();
            double resultD = MathExpressionParser.parse(out);
            int result = resultD <= 0.0 || Double.isNaN(resultD) ? 0 : (int)MathExpressionParser.round(resultD, 0);
            if (result == 1 && i > 1) {
                result = 0;
            }
            if ((result += i) < 1) {
                result = 1;
            }
            out = Integer.toString(result);
            this.amountToCraft.func_146180_a(out);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected String getBackground() {
        return "guis/craftAmt.png";
    }
}

