/*
 * Decompiled with CFR 0.152.
 */
package appeng.decorative.solid;

import appeng.block.AEBaseBlock;
import appeng.decorative.solid.GlassState;
import appeng.decorative.solid.UnlistedGlassStateProperty;
import appeng.helpers.AEGlassMaterial;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockQuartzGlass
extends AEBaseBlock {
    public static final UnlistedGlassStateProperty GLASS_STATE = new UnlistedGlassStateProperty();

    public BlockQuartzGlass() {
        super(Material.field_151592_s);
        this.func_149713_g(0);
        this.setOpaque(false);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{GLASS_STATE};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumSet<EnumFacing> flushWith = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing facing : EnumFacing.values()) {
            if (!BlockQuartzGlass.isGlassBlock(world, pos, facing)) continue;
            flushWith.add(facing);
        }
        GlassState glassState = new GlassState(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), flushWith);
        IExtendedBlockState extState = (IExtendedBlockState)state;
        return extState.withProperty((IUnlistedProperty)GLASS_STATE, (Object)glassState);
    }

    private static boolean isGlassBlock(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() instanceof BlockQuartzGlass;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess w, BlockPos pos, EnumFacing side) {
        BlockPos adjacentPos = pos.func_177972_a(side);
        Material mat = w.func_180495_p(adjacentPos).func_185904_a();
        if ((mat == Material.field_151592_s || mat == AEGlassMaterial.INSTANCE) && w.func_180495_p(adjacentPos).func_185901_i() == this.func_149645_b(state)) {
            return false;
        }
        return super.func_176225_a(state, w, pos, side);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

