/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.container.implementations.ContainerCraftingTerm;
import appeng.container.implementations.ContainerPatternEncoder;
import appeng.container.implementations.ContainerWirelessCraftingTerminal;
import appeng.container.slot.SlotCraftingMatrix;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketJEIRecipe;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.ItemStackHelper;
import appeng.integration.modules.jei.JEIMissingItem;
import appeng.util.Platform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.transfer.RecipeTransferErrorInternal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

class RecipeTransferHandler<T extends Container>
implements IRecipeTransferHandler<T> {
    private final Class<T> containerClass;

    RecipeTransferHandler(Class<T> containerClass) {
        this.containerClass = containerClass;
    }

    public Class<T> getContainerClass() {
        return this.containerClass;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@Nonnull T container, IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        String recipeType = recipeLayout.getRecipeCategory().getUid();
        if (recipeType.equals("jei.information") || recipeType.equals("minecraft.fuel")) {
            return RecipeTransferErrorInternal.INSTANCE;
        }
        if (!doTransfer) {
            JEIMissingItem error;
            if (recipeType.equals("minecraft.crafting") && (container instanceof ContainerCraftingTerm || container instanceof ContainerWirelessCraftingTerminal) && (error = new JEIMissingItem((Container)container, recipeLayout)).errored()) {
                return error;
            }
            return null;
        }
        if (container instanceof ContainerPatternEncoder) {
            try {
                if (!((ContainerPatternEncoder)container).isCraftingMode()) {
                    if (recipeType.equals("minecraft.crafting")) {
                        NetworkHandler.instance().sendToServer(new PacketValueConfig("PatternTerminal.CraftMode", "1"));
                    }
                } else if (!recipeType.equals("minecraft.crafting")) {
                    NetworkHandler.instance().sendToServer(new PacketValueConfig("PatternTerminal.CraftMode", "0"));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Map ingredients = recipeLayout.getItemStacks().getGuiIngredients();
        NBTTagCompound recipe = new NBTTagCompound();
        NBTTagList outputs = new NBTTagList();
        int slotIndex = 0;
        for (Map.Entry ingredientEntry : ingredients.entrySet()) {
            IGuiIngredient ingredient = (IGuiIngredient)ingredientEntry.getValue();
            if (!ingredient.isInput()) {
                ItemStack output = (ItemStack)ingredient.getDisplayedIngredient();
                if (output == null) continue;
                NBTTagCompound tag = ItemStackHelper.stackToNBT(output);
                outputs.func_74742_a((NBTBase)tag);
                continue;
            }
            for (Slot slot : ((Container)container).field_75151_b) {
                if (!(slot instanceof SlotCraftingMatrix) && !(slot instanceof SlotFakeCraftingMatrix) || slot.getSlotIndex() != slotIndex) continue;
                NBTTagList tags = new NBTTagList();
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                ItemStack displayed = (ItemStack)ingredient.getDisplayedIngredient();
                if (displayed != null && !displayed.func_190926_b()) {
                    list.add(displayed);
                }
                for (ItemStack stack : ingredient.getAllIngredients()) {
                    if (stack == null) continue;
                    if (Platform.isRecipePrioritized(stack)) {
                        list.add(0, stack);
                        continue;
                    }
                    list.add(stack);
                }
                for (ItemStack is : list) {
                    NBTTagCompound tag = ItemStackHelper.stackToNBT(is);
                    tags.func_74742_a((NBTBase)tag);
                }
                recipe.func_74782_a("#" + slot.getSlotIndex(), (NBTBase)tags);
                break;
            }
            ++slotIndex;
        }
        recipe.func_74782_a("outputs", (NBTBase)outputs);
        try {
            NetworkHandler.instance().sendToServer(new PacketJEIRecipe(recipe));
        }
        catch (IOException e) {
            AELog.debug(e);
        }
        return null;
    }
}

