/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.inventory;

import appeng.helpers.ItemStackHelper;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.inv.filter.IAEItemFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class AppEngInternalInventory
extends ItemStackHandler
implements Iterable<ItemStack> {
    protected boolean enableClientEvents = false;
    protected IAEAppEngInventory te;
    protected final int[] maxStack;
    protected ItemStack previousStack = ItemStack.field_190927_a;
    protected IAEItemFilter filter;
    protected boolean dirtyFlag = false;

    public AppEngInternalInventory(IAEAppEngInventory inventory, int size, int maxStack, IAEItemFilter filter) {
        super(size);
        this.setTileEntity(inventory);
        this.setFilter(filter);
        this.maxStack = new int[size];
        Arrays.fill(this.maxStack, maxStack);
    }

    public AppEngInternalInventory(IAEAppEngInventory inventory, int size, int maxStack) {
        this(inventory, size, maxStack, null);
    }

    public AppEngInternalInventory(IAEAppEngInventory inventory, int size) {
        this(inventory, size, 64);
    }

    public void setFilter(IAEItemFilter filter) {
        this.filter = filter;
    }

    public int getSlotLimit(int slot) {
        return this.maxStack[slot];
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (stack != this.getStackInSlot(slot)) {
            this.previousStack = this.getStackInSlot(slot).func_77946_l();
        }
        super.setStackInSlot(slot, stack);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.filter != null && !this.filter.allowInsert((IItemHandler)this, slot, stack)) {
            return stack;
        }
        if (!simulate) {
            this.previousStack = this.getStackInSlot(slot).func_77946_l();
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.filter != null && !this.filter.allowExtract((IItemHandler)this, slot, amount)) {
            return ItemStack.field_190927_a;
        }
        if (!simulate) {
            this.previousStack = this.getStackInSlot(slot).func_77946_l();
        }
        return super.extractItem(slot, amount, simulate);
    }

    protected void onContentsChanged(int slot) {
        if (this.getTileEntity() != null && this.eventsEnabled() && !this.dirtyFlag) {
            this.dirtyFlag = true;
            ItemStack newStack = this.getStackInSlot(slot);
            ItemStack oldStack = this.previousStack;
            InvOperation op = InvOperation.SET;
            if (newStack.func_190926_b() || oldStack.func_190926_b() || oldStack.func_190916_E() != newStack.func_190916_E() && ItemStack.func_179545_c((ItemStack)newStack, (ItemStack)oldStack)) {
                if (newStack.func_190916_E() > oldStack.func_190916_E()) {
                    newStack = newStack.func_77946_l();
                    newStack.func_190918_g(oldStack.func_190916_E());
                    oldStack = ItemStack.field_190927_a;
                    op = InvOperation.INSERT;
                } else {
                    oldStack.func_190918_g(newStack.func_190916_E());
                    newStack = ItemStack.field_190927_a;
                    op = InvOperation.EXTRACT;
                }
            }
            this.getTileEntity().onChangeInventory((IItemHandler)this, slot, op, oldStack, newStack);
            this.getTileEntity().saveChanges();
            this.previousStack = ItemStack.field_190927_a;
            this.dirtyFlag = false;
        }
        super.onContentsChanged(slot);
    }

    protected boolean eventsEnabled() {
        return Platform.isServer() || this.isEnableClientEvents();
    }

    public void setMaxStackSize(int slot, int size) {
        this.maxStack[slot] = size;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (this.maxStack[slot] == 0) {
            return false;
        }
        if (this.filter != null) {
            return this.filter.allowInsert((IItemHandler)this, slot, stack);
        }
        return true;
    }

    public void writeToNBT(NBTTagCompound data, String name) {
        data.func_74782_a(name, (NBTBase)this.serializeNBT());
    }

    public NBTTagCompound serializeNBT() {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack is = (ItemStack)this.stacks.get(i);
            if (is.func_190926_b()) continue;
            NBTTagCompound itemTag = ItemStackHelper.stackToNBT(is);
            itemTag.func_74768_a("Slot", i);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Items", (NBTBase)nbtTagList);
        nbt.func_74768_a("Size", this.stacks.size());
        return nbt;
    }

    public void readFromNBT(NBTTagCompound data, String name) {
        NBTTagCompound c = data.func_74775_l(name);
        if (c != null) {
            this.readFromNBT(c);
        }
    }

    public void readFromNBT(NBTTagCompound data) {
        this.deserializeNBT(data);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.setSize(nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.stacks.size());
        NBTTagList tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)ItemStackHelper.stackFromNBT(itemTags));
        }
        this.onLoad();
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return Collections.unmodifiableList(this.stacks).iterator();
    }

    private boolean isEnableClientEvents() {
        return this.enableClientEvents;
    }

    public void setEnableClientEvents(boolean enableClientEvents) {
        this.enableClientEvents = enableClientEvents;
    }

    public IAEAppEngInventory getTileEntity() {
        return this.te;
    }

    public void setTileEntity(IAEAppEngInventory te) {
        this.te = te;
    }
}

