/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.gui.component;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.gui.component.ComponentRenderer;
import com.infinityraider.agricraft.gui.component.GuiComponent;
import com.infinityraider.agricraft.gui.component.GuiComponentBuilder;
import java.awt.Point;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BasicComponents {
    public static GuiComponent<String> getTextComponent(String string, int x, int y, double scale) {
        return new GuiComponentBuilder<String>(string, x, y, 0, 0).setScale(scale).setRenderAction(ComponentRenderer::renderComponentText).build();
    }

    public static GuiComponent<String> getTextComponent(String string, int x, int y, double scale, boolean centered) {
        return new GuiComponentBuilder<String>(string, x, y, 0, 0).setScale(scale).setCenteredHorizontally(centered).setRenderAction(ComponentRenderer::renderComponentText).build();
    }

    public static GuiComponent<String> getButtonComponent(String string, int x, int y, int width, int height, BiFunction<GuiComponent<String>, Point, Boolean> onClick) {
        return new GuiComponentBuilder<String>(AgriCore.getTranslator().translate(string), x, y, width, height).setRenderAction(ComponentRenderer::renderComponentButton).setMouseClickAction(onClick).setCenteredHorizontally(true).setCenteredVertically(true).build();
    }

    public static GuiComponent<Supplier<Integer>> getProgressBarComponent(Supplier<Integer> progress, int x, int y, int width, int height) {
        return new GuiComponentBuilder<Supplier<Integer>>(progress, x, y, width, height).setRenderAction(ComponentRenderer::renderComponentProgressBar).build();
    }

    public static GuiComponent<ItemStack> getStackComponent(ItemStack stack, int x, int y) {
        return new GuiComponentBuilder<ItemStack>(stack, x, y, 16, 16).setRenderAction(ComponentRenderer::renderComponentStack).setTootipAdder(BasicComponents::addStackTooltip).build();
    }

    public static GuiComponent<ItemStack> getStackComponentFramed(ItemStack stack, int x, int y) {
        return new GuiComponentBuilder<ItemStack>(stack, x, y, 16, 16).setRenderAction(ComponentRenderer::renderComponentStackFramed).setTootipAdder(BasicComponents::addStackTooltip).build();
    }

    public static GuiComponent<ResourceLocation> getIconComponent(ResourceLocation icon, int x, int y, int u, int v) {
        return new GuiComponentBuilder<ResourceLocation>(icon, x, y, u, v).setRenderAction(ComponentRenderer::renderIconComponent).build();
    }

    public static GuiComponent<ResourceLocation> getIconComponent(ResourceLocation icon, int x, int y, int u, int v, String tooltip) {
        return new GuiComponentBuilder<ResourceLocation>(icon, x, y, u, v).setRenderAction(ComponentRenderer::renderIconComponent).setTootipAdder((c, l) -> l.add(tooltip)).build();
    }

    public static void addStackTooltip(GuiComponent<ItemStack> component, List<String> tooltip) {
        if (component.getComponent() != null) {
            tooltip.addAll(component.getComponent().func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL));
        }
    }
}

