/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.tiles.irrigation;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.api.v1.misc.IAgriFluidComponent;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityChannel;
import com.infinityraider.infinitylib.utility.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityTank
extends TileEntityChannel
implements IFluidHandler {
    public static final int TANK_FLUID_CAPACITY = 16000;
    public static final int TANK_FLUID_HEIGHT_MIN = 0;
    public static final int TANK_FLUID_HEIGHT_MAX = 1000;
    public static final int TANK_FLUID_SYNC_THRESHOLD = 250;
    public static final long TANK_FLUID_SYNC_TIMEOUT = 1000L;

    public TileEntityTank() {
        this(16000, 0, 1000, 250, 1000L);
    }

    public TileEntityTank(int fluidCapacity, int fluidHeightMin, int fluidHeightMax, int fluidSyncThreshold, long fluidSyncTimeout) {
        super(fluidCapacity, fluidHeightMin, fluidHeightMax, fluidSyncThreshold, fluidSyncTimeout);
    }

    @Override
    public void func_73660_a() {
        if (AgriCraftConfig.fillFromFlowingWater) {
            Block block = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c();
            if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                this.acceptFluid(1000000, 1, true, false);
            }
        } else if (AgriCraftConfig.fillFromRainfall && this.field_145850_b.func_175727_C(this.field_174879_c.func_177984_a())) {
            this.acceptFluid(1000000, 1, true, false);
        }
        super.func_73660_a();
    }

    @Override
    protected byte classifyConnection(EnumFacing side) {
        IAgriFluidComponent component = WorldHelper.getTile((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(side), IAgriFluidComponent.class).orElse(null);
        if (component == null) {
            return 0;
        }
        if (component instanceof TileEntityTank) {
            return 2;
        }
        if (side.func_176740_k().func_176722_c()) {
            return 1;
        }
        return 0;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[0];
    }

    public int fill(FluidStack fs, boolean doFill) {
        if (fs.getFluid() == FluidRegistry.WATER) {
            return fs.amount - this.acceptFluid(1000, fs.amount, true, !doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack fs, boolean doDrain) {
        if (fs.getFluid() == FluidRegistry.WATER) {
            return this.drain(fs.amount, doDrain);
        }
        return new FluidStack(fs.getFluid(), 0);
    }

    public FluidStack drain(int amount, boolean doDrain) {
        if (amount < 0) {
            AgriCore.getLogger("agricraft").error("Cannot drain a negative amount ({0} mB) from a fluid component!", amount);
            return new FluidStack(FluidRegistry.WATER, 0);
        }
        int drainedAmount = this.getFluidAmount() > amount ? amount : this.getFluidAmount();
        if (doDrain && drainedAmount > 0) {
            this.setFluidAmount(this.getFluidAmount() - drainedAmount);
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
        }
        return new FluidStack(FluidRegistry.WATER, drainedAmount);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }
}

