/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.world;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.init.AgriBlocks;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import com.infinityraider.agricraft.tiles.TileEntityCrop;
import com.infinityraider.agricraft.tiles.analyzer.TileEntitySeedAnalyzer;
import com.infinityraider.agricraft.utility.WorldGenerationHelper;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public class StructureGreenHouse
extends StructureVillagePieces.House1 {
    private static final int xSize = 17;
    private static final int ySize = 10;
    private static final int zSize = 11;
    private int averageGroundLevel = -1;

    public StructureGreenHouse(StructureVillagePieces.Start start, int type, Random rand, StructureBoundingBox p_i45571_4_, EnumFacing facing) {
        this.func_186164_a(facing);
        this.field_74887_e = p_i45571_4_;
    }

    public static StructureGreenHouse buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int p1, int p2, int p3, EnumFacing facing, int p5) {
        StructureBoundingBox boundingBox = StructureBoundingBox.func_175897_a((int)p1, (int)p2, (int)p3, (int)0, (int)0, (int)0, (int)17, (int)10, (int)11, (EnumFacing)facing);
        return StructureGreenHouse.func_74895_a((StructureBoundingBox)boundingBox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)boundingBox) == null ? new StructureGreenHouse(villagePiece, p5, random, boundingBox, facing) : null;
    }

    public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
        int z;
        int x;
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.func_74889_b(worldIn, structureBoundingBoxIn);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + 7, 0);
        }
        this.func_175804_a(worldIn, this.field_74887_e, 0, 0, 0, 16, 0, 10, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 0, 1, 0, 16, 1, 0, Blocks.field_150351_n.func_176223_P(), Blocks.field_150351_n.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 0, 1, 0, 0, 1, 10, Blocks.field_150351_n.func_176223_P(), Blocks.field_150351_n.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 0, 1, 10, 16, 1, 10, Blocks.field_150351_n.func_176223_P(), Blocks.field_150351_n.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 16, 1, 0, 16, 1, 10, Blocks.field_150351_n.func_176223_P(), Blocks.field_150351_n.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 1, 1, 1, 1, 1, 4, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 1, 1, 6, 1, 1, 9, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 15, 1, 1, 15, 1, 4, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 15, 1, 6, 15, 1, 9, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 2, 1, 1, this.field_74887_e);
        this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 8, 1, 1, this.field_74887_e);
        this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 14, 1, 5, this.field_74887_e);
        this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 2, 1, 9, this.field_74887_e);
        this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 8, 1, 9, this.field_74887_e);
        this.func_175811_a(worldIn, Blocks.field_150347_e.func_176223_P(), 14, 1, 9, this.field_74887_e);
        this.func_175811_a(worldIn, Blocks.field_150334_T.func_176223_P(), 1, 1, 5, this.field_74887_e);
        this.func_175811_a(worldIn, Blocks.field_150334_T.func_176223_P(), 15, 1, 5, this.field_74887_e);
        this.func_175804_a(worldIn, this.field_74887_e, 2, 1, 2, 2, 1, 8, Blocks.field_150334_T.func_176223_P(), Blocks.field_150334_T.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 8, 1, 2, 8, 1, 8, Blocks.field_150334_T.func_176223_P(), Blocks.field_150334_T.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 14, 1, 2, 14, 1, 8, Blocks.field_150334_T.func_176223_P(), Blocks.field_150334_T.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 2, 1, 2, 14, 1, 2, Blocks.field_150334_T.func_176223_P(), Blocks.field_150334_T.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 2, 1, 8, 14, 1, 8, Blocks.field_150334_T.func_176223_P(), Blocks.field_150334_T.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 3, 1, 1, 7, 1, 1, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 9, 1, 1, 10, 1, 1, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 3, 1, 9, 7, 1, 9, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 9, 1, 9, 13, 1, 9, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
        this.func_175811_a(worldIn, Blocks.field_150355_j.func_176223_P(), 13, 1, 6, this.field_74887_e);
        this.func_175804_a(worldIn, this.field_74887_e, 3, 1, 3, 7, 1, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 9, 1, 3, 13, 1, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 1, 2, 1, 1, 6, 1, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 8, 2, 1, 8, 6, 1, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 15, 2, 1, 15, 6, 1, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 1, 2, 4, 1, 5, 4, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 15, 2, 4, 15, 5, 4, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 1, 2, 6, 1, 5, 6, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 15, 2, 6, 15, 5, 6, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 1, 2, 9, 1, 6, 9, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 8, 2, 9, 8, 6, 9, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 15, 2, 9, 15, 6, 9, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 2, 6, 1, 7, 6, 1, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X), false);
        this.func_175804_a(worldIn, this.field_74887_e, 9, 6, 1, 14, 6, 1, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X), false);
        this.func_175804_a(worldIn, this.field_74887_e, 2, 6, 9, 7, 6, 9, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X), false);
        this.func_175804_a(worldIn, this.field_74887_e, 9, 6, 9, 14, 6, 9, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X), false);
        this.func_175804_a(worldIn, this.field_74887_e, 1, 6, 2, 1, 6, 8, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z), false);
        this.func_175804_a(worldIn, this.field_74887_e, 8, 6, 2, 8, 6, 8, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z), false);
        this.func_175804_a(worldIn, this.field_74887_e, 15, 6, 2, 15, 6, 8, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z), false);
        this.func_175811_a(worldIn, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z), 1, 4, 5, this.field_74887_e);
        this.func_175811_a(worldIn, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z), 15, 4, 5, this.field_74887_e);
        this.func_175804_a(worldIn, this.field_74887_e, 2, 2, 1, 7, 2, 1, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 9, 2, 1, 14, 2, 1, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 1, 2, 2, 1, 2, 3, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 1, 2, 7, 1, 2, 8, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 15, 2, 2, 15, 2, 3, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 15, 2, 7, 15, 2, 8, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 2, 2, 9, 7, 2, 9, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 9, 2, 9, 14, 2, 9, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 1, 3, 2, 1, 5, 3, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 1, 3, 7, 1, 5, 8, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 15, 3, 2, 15, 5, 3, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 15, 3, 7, 15, 5, 8, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 2, 3, 1, 7, 5, 1, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 9, 3, 1, 14, 5, 1, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 2, 3, 9, 7, 5, 9, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 9, 3, 9, 14, 5, 9, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 2, 6, 2, 7, 6, 8, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 9, 6, 2, 14, 6, 8, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_175811_a(worldIn, Blocks.field_150359_w.func_176223_P(), 1, 5, 5, this.field_74887_e);
        this.func_175811_a(worldIn, Blocks.field_150359_w.func_176223_P(), 15, 5, 5, this.field_74887_e);
        this.func_175811_a(worldIn, Blocks.field_180413_ao.func_176203_a(0), 1, 2, 5, this.field_74887_e);
        this.func_175811_a(worldIn, Blocks.field_180413_ao.func_176203_a(8), 1, 3, 5, this.field_74887_e);
        this.func_175811_a(worldIn, Blocks.field_180413_ao.func_176203_a(2), 15, 2, 5, this.field_74887_e);
        this.func_175811_a(worldIn, Blocks.field_180413_ao.func_176203_a(8), 15, 3, 5, this.field_74887_e);
        this.func_175804_a(worldIn, this.field_74887_e, 0, 2, 0, 0, 9, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 16, 2, 0, 16, 9, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 0, 2, 0, 16, 9, 0, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 0, 2, 10, 16, 9, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 2, 2, 2, 14, 5, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
        this.func_175804_a(worldIn, this.field_74887_e, 1, 7, 1, 14, 9, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
        this.func_189926_a(worldIn, EnumFacing.WEST, 0, 4, 1, this.field_74887_e);
        this.func_189926_a(worldIn, EnumFacing.WEST, 0, 4, 4, this.field_74887_e);
        this.func_189926_a(worldIn, EnumFacing.WEST, 0, 4, 6, this.field_74887_e);
        this.func_189926_a(worldIn, EnumFacing.WEST, 0, 4, 9, this.field_74887_e);
        this.func_189926_a(worldIn, EnumFacing.WEST, 14, 4, 4, this.field_74887_e);
        this.func_189926_a(worldIn, EnumFacing.WEST, 14, 4, 6, this.field_74887_e);
        this.func_189926_a(worldIn, EnumFacing.SOUTH, 1, 4, 0, this.field_74887_e);
        this.func_189926_a(worldIn, EnumFacing.SOUTH, 8, 4, 0, this.field_74887_e);
        this.func_189926_a(worldIn, EnumFacing.SOUTH, 15, 4, 0, this.field_74887_e);
        this.func_189926_a(worldIn, EnumFacing.SOUTH, 8, 4, 8, this.field_74887_e);
        this.func_189926_a(worldIn, EnumFacing.EAST, 16, 4, 1, this.field_74887_e);
        this.func_189926_a(worldIn, EnumFacing.EAST, 16, 4, 4, this.field_74887_e);
        this.func_189926_a(worldIn, EnumFacing.EAST, 16, 4, 6, this.field_74887_e);
        this.func_189926_a(worldIn, EnumFacing.EAST, 16, 4, 9, this.field_74887_e);
        this.func_189926_a(worldIn, EnumFacing.EAST, 2, 4, 4, this.field_74887_e);
        this.func_189926_a(worldIn, EnumFacing.EAST, 2, 4, 6, this.field_74887_e);
        this.func_189926_a(worldIn, EnumFacing.NORTH, 1, 4, 10, this.field_74887_e);
        this.func_189926_a(worldIn, EnumFacing.NORTH, 8, 4, 10, this.field_74887_e);
        this.func_189926_a(worldIn, EnumFacing.NORTH, 15, 4, 10, this.field_74887_e);
        this.func_189926_a(worldIn, EnumFacing.NORTH, 8, 4, 2, this.field_74887_e);
        Random rnd = new Random();
        List<IAgriPlant> plants = this.getPlantPool();
        for (x = 3; x <= 7; ++x) {
            for (z = 3; z <= 7; ++z) {
                this.generateStructureCrop(worldIn, this.field_74887_e, x, 2, z, z % 2 == 0 && x % 2 == 0 || x == 5 && z == 5, rnd, plants);
            }
        }
        for (x = 9; x <= 13; ++x) {
            for (z = 3; z <= 7; ++z) {
                this.generateStructureCrop(worldIn, this.field_74887_e, x, 2, z, z % 2 == 0 && x % 2 == 0 || x == 11 && z == 5, rnd, plants);
            }
        }
        return true;
    }

    protected boolean generateStructureCrop(World world, StructureBoundingBox boundingBox, int x, int y, int z, boolean crosscrop, Random rnd, List<IAgriPlant> plants) {
        int zCoord;
        int yCoord;
        int xCoord = this.func_74865_a(x, z);
        if (boundingBox.func_175898_b(new Vec3i(xCoord, yCoord = this.func_74862_a(y), zCoord = this.func_74873_b(x, z)))) {
            world.func_180501_a(new BlockPos(xCoord, yCoord, zCoord), AgriBlocks.getInstance().CROP.func_176223_P(), 2);
            TileEntityCrop crop = (TileEntityCrop)world.func_175625_s(new BlockPos(xCoord, yCoord, zCoord));
            if (crop != null) {
                if (crosscrop) {
                    crop.setCrossCrop(true);
                } else if (plants.size() > 0) {
                    IAgriStat randomStat = WorldGenerationHelper.getRandomStat(rnd);
                    AgriSeed seed = WorldGenerationHelper.getRandomSeed(rnd, false, plants).withStat(randomStat);
                    crop.setSeed(seed);
                }
            }
            return true;
        }
        return false;
    }

    protected boolean generateStructureSeedAnalyzer(World world, StructureBoundingBox boundingBox, int x, int y, int z, EnumFacing facing) {
        int zCoord;
        int yCoord;
        int xCoord = this.func_74865_a(x, z);
        if (boundingBox.func_175898_b((Vec3i)new BlockPos(xCoord, yCoord = this.func_74862_a(y), zCoord = this.func_74873_b(x, z)))) {
            world.func_175656_a(new BlockPos(xCoord, yCoord, zCoord), AgriBlocks.getInstance().SEED_ANALYZER.func_176223_P());
            TileEntitySeedAnalyzer analyzer = (TileEntitySeedAnalyzer)world.func_175625_s(new BlockPos(xCoord, yCoord, zCoord));
            if (analyzer != null && facing != null) {
                analyzer.setOrientation(facing);
            }
            return true;
        }
        return false;
    }

    protected List<IAgriPlant> getPlantPool() {
        return AgriApi.getPlantRegistry().stream().filter(plant -> plant.getTier() <= AgriCraftConfig.greenhousePlantTierLimit).collect(Collectors.toList());
    }
}

