/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.client.models.sided;

import com.google.common.collect.Maps;
import com.teamacronymcoders.base.blocks.properties.SideType;
import com.teamacronymcoders.base.client.models.sided.ITextureNamer;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.EnumFacing;

public class SidedTypeRegistry {
    private static final Map<String, ITextureNamer> TEXTURE_NAMERS = Maps.newHashMap();

    public static void addTextureNamer(String name, ITextureNamer textureNamer) {
        TEXTURE_NAMERS.put(name, textureNamer);
    }

    public static ITextureNamer getTextureNamer(String name) {
        return TEXTURE_NAMERS.get(name);
    }

    public static Set<Map.Entry<String, ITextureNamer>> getEntries() {
        return TEXTURE_NAMERS.entrySet();
    }

    static {
        SidedTypeRegistry.addTextureNamer("all6", new ITextureNamer(){});
        SidedTypeRegistry.addTextureNamer("s", new ITextureNamer(){

            @Override
            public String nameFromSide(EnumFacing side, SideType cfg) {
                return "side";
            }
        });
        SidedTypeRegistry.addTextureNamer("hud", new ITextureNamer(){

            @Override
            public String nameFromSide(EnumFacing side, SideType cfg) {
                return side.ordinal() < 2 ? side.func_176610_l() : "side";
            }
        });
        SidedTypeRegistry.addTextureNamer("hv", new ITextureNamer(){

            @Override
            public String nameFromSide(EnumFacing side, SideType cfg) {
                return side.ordinal() < 2 ? "up" : "side";
            }
        });
        SidedTypeRegistry.addTextureNamer("ud", new ITextureNamer(){

            @Override
            public String nameFromSide(EnumFacing side, SideType cfg) {
                return side.ordinal() < 2 ? side.func_176610_l() : "side";
            }

            @Override
            public String nameFromCfg(EnumFacing side, SideType cfg) {
                return side.ordinal() < 2 ? cfg.func_176610_l() : null;
            }
        });
        SidedTypeRegistry.addTextureNamer("v", new ITextureNamer(){

            @Override
            public String nameFromSide(EnumFacing side, SideType cfg) {
                return side.ordinal() < 2 ? "up" : "side";
            }

            @Override
            public String nameFromCfg(EnumFacing side, SideType cfg) {
                return side.ordinal() < 2 ? cfg.func_176610_l() : null;
            }
        });
    }
}

