/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.materialsystem.items.minecart;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.teamacronymcoders.base.client.models.generator.IHasGeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.GeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.IGeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.ModelType;
import com.teamacronymcoders.base.entities.EntityMinecartBase;
import com.teamacronymcoders.base.items.IHasItemColor;
import com.teamacronymcoders.base.items.minecart.ItemMinecartBase;
import com.teamacronymcoders.base.materialsystem.MaterialUser;
import com.teamacronymcoders.base.materialsystem.entity.minecart.EntityMaterialMinecart;
import com.teamacronymcoders.base.materialsystem.materialparts.MaterialPart;
import com.teamacronymcoders.base.util.files.templates.TemplateFile;
import com.teamacronymcoders.base.util.files.templates.TemplateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ItemMaterialMinecart
extends ItemMinecartBase
implements IHasItemColor,
IHasGeneratedModel {
    private final MaterialUser materialUser;
    private final Map<Integer, MaterialPart> itemMaterialParts;

    public ItemMaterialMinecart(MaterialUser materialUser) {
        super("material");
        this.func_77627_a(true);
        this.materialUser = materialUser;
        this.itemMaterialParts = new HashMap<Integer, MaterialPart>();
    }

    public Map<Integer, MaterialPart> getMaterialParts() {
        return this.itemMaterialParts;
    }

    @Override
    public List<ItemStack> getAllSubItems(List<ItemStack> itemStacks) {
        itemStacks.addAll(this.getMaterialParts().values().stream().map(materialPart -> new ItemStack((Item)this, 1, materialPart.getId())).collect(Collectors.toList()));
        return itemStacks;
    }

    @Override
    @Nonnull
    @ParametersAreNonnullByDefault
    public EntityMinecartBase getEntityFromItem(World world, ItemStack itemStack) {
        return new EntityMaterialMinecart(world, this.getMaterialPartFromItemStack(itemStack));
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack itemStack) {
        return this.getMaterialPartFromItemStack(itemStack).getLocalizedName();
    }

    @Nonnull
    private MaterialPart getMaterialPartFromItemStack(ItemStack itemStack) {
        return this.materialUser.getMaterialPart(itemStack.func_77952_i());
    }

    public void addMaterialPart(MaterialPart materialPart) {
        this.getMaterialParts().put(materialPart.getId(), materialPart);
    }

    @Override
    public List<ResourceLocation> getResourceLocations(List<ResourceLocation> resourceLocations) {
        this.getMaterialParts().forEach((id, materialPart) -> resourceLocations.add(new ResourceLocation(this.materialUser.getMod().getID(), materialPart.getUnlocalizedName())));
        return resourceLocations;
    }

    @Override
    public int getColorFromItemstack(@Nonnull ItemStack itemStack, int tintIndex) {
        return tintIndex == 0 ? this.getMaterialPartFromItemStack(itemStack).getColor() : -1;
    }

    @Override
    public List<IGeneratedModel> getGeneratedModels() {
        ArrayList models = Lists.newArrayList();
        for (MaterialPart materialPart : this.getMaterialParts().values()) {
            TemplateFile templateFile = TemplateManager.getTemplateFile("item_model");
            HashMap replacements = Maps.newHashMap();
            replacements.put("texture", materialPart.getPart().getOwnerId() + ":items/" + materialPart.getPart().getShortUnlocalizedName());
            templateFile.replaceContents(replacements);
            models.add(new GeneratedModel(materialPart.getUnlocalizedName(), ModelType.ITEM_MODEL, templateFile.getFileContents()));
        }
        return models;
    }
}

