/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.block;

import com.bewitchment.common.block.util.ModBlockLog;
import com.bewitchment.common.item.tool.ItemBoline;
import com.bewitchment.registry.ModObjects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockDragonsBloodLog
extends ModBlockLog {
    public static final PropertyBool NATURAL = PropertyBool.func_177716_a((String)"natural");
    public static final PropertyBool SLASHED = PropertyBool.func_177716_a((String)"slashed");

    public BlockDragonsBloodLog() {
        super("dragons_blood_wood", Blocks.field_150364_r, "logWood");
        this.func_149675_a(true);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Y).func_177226_a((IProperty)NATURAL, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)SLASHED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        BlockPos dropPos = pos.func_177967_a(EnumFacing.field_176754_o[rand.nextInt(4)], 1);
        if (worldIn.func_175697_a(pos, 1) && ((Boolean)state.func_177229_b((IProperty)SLASHED)).equals(true) && rand.nextInt(100) <= 7) {
            worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)dropPos.func_177958_n(), (double)dropPos.func_177956_o(), (double)dropPos.func_177952_p(), new ItemStack(ModObjects.dragons_blood_resin)));
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_184586_b(hand).func_77973_b() instanceof ItemBoline && ((Boolean)state.func_177229_b((IProperty)NATURAL)).equals(true) && ((Boolean)state.func_177229_b((IProperty)SLASHED)).equals(false)) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)SLASHED, (Comparable)Boolean.valueOf(true)));
            playerIn.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)playerIn);
            if (worldIn.field_72995_K) {
                worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187889_gU, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        switch (meta & 0xC) {
            case 0: {
                iblockstate = iblockstate.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
                break;
            }
            case 4: {
                iblockstate = iblockstate.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.X);
                break;
            }
            case 8: {
                iblockstate = iblockstate.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Z);
                break;
            }
            default: {
                iblockstate = iblockstate.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
            }
        }
        iblockstate = (meta & 1) == 0 ? iblockstate.func_177226_a((IProperty)NATURAL, (Comparable)Boolean.valueOf(false)) : iblockstate.func_177226_a((IProperty)NATURAL, (Comparable)Boolean.valueOf(true));
        iblockstate = (meta & 2) == 0 ? iblockstate.func_177226_a((IProperty)SLASHED, (Comparable)Boolean.valueOf(false)) : iblockstate.func_177226_a((IProperty)SLASHED, (Comparable)Boolean.valueOf(true));
        return iblockstate;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = 0;
        switch ((BlockLog.EnumAxis)state.func_177229_b((IProperty)field_176299_a)) {
            case X: {
                i |= 4;
                break;
            }
            case Z: {
                i |= 8;
                break;
            }
            case NONE: {
                i |= 0xC;
            }
        }
        if (((Boolean)state.func_177229_b((IProperty)NATURAL)).booleanValue()) {
            i |= 1;
        }
        if (((Boolean)state.func_177229_b((IProperty)SLASHED)).booleanValue()) {
            i |= 2;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NATURAL, SLASHED, field_176299_a});
    }
}

