/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

enum AccessDirection {
    BOTH,
    IN,
    OUT,
    NEITHER;


    boolean canInsert() {
        return this == BOTH || this == IN;
    }

    boolean canExtract() {
        return this == BOTH || this == OUT;
    }

    boolean canAccess() {
        return this != NEITHER;
    }

    AccessDirection changeInsert(boolean b) {
        if (b) {
            if (this == OUT) {
                return BOTH;
            }
            if (this == NEITHER) {
                return IN;
            }
        } else {
            if (this == BOTH) {
                return OUT;
            }
            if (this == IN) {
                return NEITHER;
            }
        }
        return this;
    }

    AccessDirection changeExtract(boolean b) {
        if (b) {
            if (this == IN) {
                return BOTH;
            }
            if (this == NEITHER) {
                return OUT;
            }
        } else {
            if (this == BOTH) {
                return IN;
            }
            if (this == OUT) {
                return NEITHER;
            }
        }
        return this;
    }

    public String getTextColour() {
        switch (this) {
            case BOTH: {
                return "\u00c2\u00a7a";
            }
            case IN: {
                return "\u00c2\u00a7e";
            }
            case NEITHER: {
                return "\u00c2\u00a7c";
            }
        }
        return "\u00c2\u00a7b";
    }

    public int getShadeColour() {
        switch (this) {
            case BOTH: {
                return 0x5555FF55;
            }
            case IN: {
                return 0x55FFFF55;
            }
            case NEITHER: {
                return 0x55FF5555;
            }
        }
        return 0x5555FFFF;
    }
}

