/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.lumbermill.recipes;

import binnie.core.util.OreDictionaryUtil;
import binnie.extratrees.api.recipes.ILumbermillManager;
import binnie.extratrees.api.recipes.ILumbermillRecipe;
import binnie.extratrees.machines.lumbermill.recipes.LumbermillRecipe;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class LumbermillRecipeManager
implements ILumbermillManager {
    private static final Multimap<Item, ILumbermillRecipe> recipes = ArrayListMultimap.create();
    private static final InventoryCrafting FAKE_CRAFT_INV = new FakeInventoryCrafting();

    public static ItemStack getPlankProduct(ItemStack logStack, World world) {
        Item logItem = logStack.func_77973_b();
        for (ILumbermillRecipe recipe : recipes.get((Object)logItem)) {
            if (!recipe.getInput().func_77969_a(logStack)) continue;
            return recipe.getOutput().func_77946_l();
        }
        if (OreDictionaryUtil.hasOreName(logStack, "logWood")) {
            return LumbermillRecipeManager.getRecipeWithPlanksOutput(logStack.func_77946_l(), world);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getRecipeWithPlanksOutput(ItemStack logStack, @Nullable World world) {
        FAKE_CRAFT_INV.func_174888_l();
        FAKE_CRAFT_INV.func_70299_a(0, logStack);
        for (IRecipe recipe : ForgeRegistries.RECIPES.getValuesCollection()) {
            try {
                ItemStack recipeOutput;
                if (!recipe.func_77569_a(FAKE_CRAFT_INV, world) || (recipeOutput = recipe.func_77572_b(FAKE_CRAFT_INV)).func_190926_b() || !OreDictionaryUtil.hasOreName(recipeOutput, "plankWood")) continue;
                return recipeOutput;
            }
            catch (LinkageError | RuntimeException throwable) {
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void addRecipe(ItemStack input, ItemStack output) {
        Item logItem = input.func_77973_b();
        recipes.put((Object)logItem, (Object)new LumbermillRecipe(input, output));
    }

    @Override
    public boolean addRecipe(ILumbermillRecipe recipe) {
        Item item = recipe.getInput().func_77973_b();
        return recipes.put((Object)item, (Object)recipe);
    }

    @Override
    public boolean removeRecipe(ILumbermillRecipe recipe) {
        Item item = recipe.getInput().func_77973_b();
        return recipes.get((Object)item).remove(recipe);
    }

    @Override
    public Collection<ILumbermillRecipe> recipes() {
        return recipes.values();
    }

    private static class FakeInventoryCrafting
    extends InventoryCrafting {
        public FakeInventoryCrafting() {
            super((Container)new FakeCraftingHandler(), 3, 3);
        }
    }

    private static class FakeCraftingHandler
    extends Container {
        private FakeCraftingHandler() {
        }

        public void func_75130_a(IInventory inventoryIn) {
        }

        public boolean func_75145_c(EntityPlayer playerIn) {
            return false;
        }
    }
}

