/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.refill;

import com.cleanroommc.bogosorter.common.config.PlayerConfig;
import com.cleanroommc.bogosorter.common.refill.RefillHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ISpecialArmor;

public class DamageHelper {
    public static boolean damageItemHook(EntityPlayer player, ItemStack itemStack) {
        PlayerConfig playerConfig = PlayerConfig.get(player);
        if (!playerConfig.enableAutoRefill || playerConfig.autoRefillDamageThreshold <= 0) {
            return false;
        }
        if (RefillHandler.shouldHandleRefill(player, itemStack) && DamageHelper.isNotArmor(itemStack)) {
            ItemStack handItem = player.func_184614_ca();
            if (handItem != itemStack && (handItem = player.func_184592_cb()) != itemStack) {
                return false;
            }
            int durabilityLeft = itemStack.func_77958_k() - itemStack.func_77952_i();
            if (durabilityLeft >= 0 && durabilityLeft < playerConfig.autoRefillDamageThreshold) {
                return RefillHandler.handle(player.field_71071_by.field_70461_c, itemStack, player, true);
            }
        }
        return false;
    }

    private static boolean isNotArmor(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemArmor || itemStack.func_77973_b() instanceof ISpecialArmor) {
            return false;
        }
        EntityEquipmentSlot slot = itemStack.func_77973_b().getEquipmentSlot(itemStack);
        return slot == null || slot == EntityEquipmentSlot.MAINHAND || slot == EntityEquipmentSlot.OFFHAND;
    }

    public static int getDurability(ItemStack item) {
        if (item.func_190926_b()) {
            return 0;
        }
        if (item.func_77958_k() <= 0) {
            return 0;
        }
        if (DamageHelper.isUnbreakable(item)) {
            return item.func_77958_k() + 1;
        }
        return item.func_77958_k() - item.func_77952_i() + 1;
    }

    public static boolean isUnbreakable(ItemStack item) {
        return !item.func_190926_b() && item.func_77942_o() && item.func_77978_p().func_74767_n("Unbreakable");
    }
}

