/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.refill;

import com.cleanroommc.bogosorter.common.OreDictHelper;
import com.cleanroommc.bogosorter.common.config.PlayerConfig;
import com.cleanroommc.bogosorter.common.network.NetworkHandler;
import com.cleanroommc.bogosorter.common.network.NetworkUtils;
import com.cleanroommc.bogosorter.common.network.SRefillSound;
import com.cleanroommc.bogosorter.common.refill.DamageHelper;
import gregtech.api.items.toolitem.IGTTool;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Set;
import java.util.function.BiPredicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RefillHandler {
    private static final Class<?> gtToolClass;
    private static final int[][] INVENTORY_PROXIMITY_MAP;
    private BiPredicate<ItemStack, ItemStack> similarItemMatcher = (stack, stack2) -> stack.func_77973_b() == stack2.func_77973_b() && stack.func_77960_j() == stack2.func_77960_j();
    private BiPredicate<ItemStack, ItemStack> exactItemMatcher = RefillHandler::matchTags;
    private final int hotbarIndex;
    private final IntList slots;
    private final ItemStack brokenItem;
    private final EntityPlayer player;
    private final InventoryPlayer inventory;
    private final PlayerConfig playerConfig;
    private final boolean swapItems;
    private boolean isDamageable = false;

    @SubscribeEvent
    public static void onDestroyItem(PlayerDestroyItemEvent event) {
        if (event.getEntityPlayer() == null || event.getEntityPlayer().field_70170_p == null || event.getEntityPlayer().field_70170_p.field_72995_K || !PlayerConfig.get((EntityPlayer)event.getEntityPlayer()).enableAutoRefill) {
            return;
        }
        if (event.getOriginal().func_77973_b() instanceof ItemBlock && RefillHandler.shouldHandleRefill(event.getEntityPlayer(), event.getOriginal())) {
            int index = event.getHand() == EnumHand.MAIN_HAND ? event.getEntityPlayer().field_71071_by.field_70461_c : 40;
            RefillHandler.handle(index, event.getOriginal(), event.getEntityPlayer(), false);
        }
    }

    public static void onDestroyItem(EntityPlayer player, ItemStack brokenItem, EnumHand hand) {
        if (!PlayerConfig.get((EntityPlayer)player).enableAutoRefill) {
            return;
        }
        if (RefillHandler.shouldHandleRefill(player, brokenItem)) {
            int index = hand == EnumHand.MAIN_HAND ? player.field_71071_by.field_70461_c : 40;
            RefillHandler.handle(index, brokenItem, player, false);
        }
    }

    public static boolean handle(int hotbarIndex, ItemStack brokenItem, EntityPlayer player, boolean swap) {
        return new RefillHandler(hotbarIndex, brokenItem, player, swap).handleRefill();
    }

    public static boolean shouldHandleRefill(EntityPlayer player, ItemStack brokenItem) {
        return RefillHandler.shouldHandleRefill(player, brokenItem, false);
    }

    public static boolean shouldHandleRefill(EntityPlayer player, ItemStack brokenItem, boolean allowClient) {
        Container container = player.field_71070_bA;
        return !(!allowClient && NetworkUtils.isClient(player) || container != null && container != player.field_71069_bz || brokenItem.func_190926_b());
    }

    public RefillHandler(int hotbarIndex, ItemStack brokenItem, EntityPlayer player, boolean swapItems) {
        this.hotbarIndex = hotbarIndex;
        this.slots = new IntArrayList(INVENTORY_PROXIMITY_MAP[hotbarIndex == 40 ? player.field_71071_by.field_70461_c : hotbarIndex]);
        this.brokenItem = brokenItem;
        this.player = player;
        this.inventory = player.field_71071_by;
        this.playerConfig = PlayerConfig.get(player);
        this.swapItems = swapItems;
    }

    public RefillHandler(int hotbarIndex, ItemStack brokenItem, EntityPlayer player) {
        this(hotbarIndex, brokenItem, player, false);
    }

    public boolean handleRefill() {
        if (this.brokenItem.func_77973_b() instanceof ItemBlock) {
            return this.findItem(false);
        }
        if (this.brokenItem.func_77984_f()) {
            if (gtToolClass != null && RefillHandler.isGTCEuTool(this.brokenItem)) {
                this.exactItemMatcher = (stack, stack2) -> {
                    if (stack.func_77942_o() != stack2.func_77942_o()) {
                        return false;
                    }
                    if (!stack.func_77942_o()) {
                        return true;
                    }
                    return OreDictHelper.getGtToolMaterial(stack).equals(OreDictHelper.getGtToolMaterial(stack2));
                };
            } else {
                this.similarItemMatcher = (stack, stack2) -> stack.func_77973_b() == stack2.func_77973_b();
            }
            this.isDamageable = true;
            return this.findNormalDamageable();
        }
        return this.findItem(true);
    }

    private static boolean isGTCEuTool(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof IGTTool;
    }

    private boolean findItem(boolean exactOnly) {
        ItemStack firstItemMatch = null;
        int firstItemMatchSlot = -1;
        IntListIterator slotsIterator = this.slots.iterator();
        while (slotsIterator.hasNext()) {
            int slot = (Integer)slotsIterator.next();
            ItemStack found = (ItemStack)this.inventory.field_70462_a.get(slot);
            if (found.func_190926_b() || this.swapItems && this.isDamageable && DamageHelper.getDurability(found) <= this.playerConfig.autoRefillDamageThreshold) {
                slotsIterator.remove();
                continue;
            }
            if (!this.similarItemMatcher.test(this.brokenItem, found)) continue;
            if (this.exactItemMatcher.test(this.brokenItem, found)) {
                this.refillItem(found, slot);
                return true;
            }
            if (firstItemMatch != null) continue;
            firstItemMatch = found;
            firstItemMatchSlot = slot;
        }
        if (firstItemMatch != null && !exactOnly) {
            this.refillItem(firstItemMatch, firstItemMatchSlot);
            return true;
        }
        return false;
    }

    private boolean findNormalDamageable() {
        if (this.findItem(false)) {
            return true;
        }
        if (this.slots.isEmpty()) {
            return false;
        }
        Set brokenToolClasses = this.brokenItem.func_77973_b().getToolClasses(this.brokenItem);
        if (brokenToolClasses.isEmpty()) {
            return false;
        }
        IntListIterator intListIterator = this.slots.iterator();
        while (intListIterator.hasNext()) {
            int slot = (Integer)intListIterator.next();
            ItemStack found = (ItemStack)this.inventory.field_70462_a.get(slot);
            Set toolTypes = found.func_77973_b().getToolClasses(found);
            if (!brokenToolClasses.equals(toolTypes)) continue;
            this.refillItem(found, slot);
            return true;
        }
        int brokenTools = brokenToolClasses.size();
        IntListIterator intListIterator2 = this.slots.iterator();
        while (intListIterator2.hasNext()) {
            Set toolTypes;
            int tools;
            int slot = (Integer)intListIterator2.next();
            ItemStack found = (ItemStack)this.inventory.field_70462_a.get(slot);
            if (found.func_190926_b() || (tools = (toolTypes = found.func_77973_b().getToolClasses(found)).size()) == 0 || tools == brokenTools) continue;
            if (tools > brokenTools) {
                if (!toolTypes.containsAll(brokenToolClasses)) continue;
                this.refillItem(found, slot);
                return true;
            }
            if (!brokenToolClasses.containsAll(toolTypes)) continue;
            this.refillItem(found, slot);
            return true;
        }
        return false;
    }

    private void refillItem(ItemStack refill, int refillIndex) {
        ItemStack current = ItemStack.field_190927_a;
        if (!this.swapItems) {
            current = this.getItem(this.hotbarIndex);
        }
        this.setAndSyncSlot(this.hotbarIndex, refill.func_77946_l());
        this.setAndSyncSlot(refillIndex, this.swapItems ? this.brokenItem.func_77946_l() : ItemStack.field_190927_a);
        if (!current.func_190926_b()) {
            this.inventory.func_70441_a(current);
        }
        if (!NetworkUtils.isClient(this.player)) {
            NetworkHandler.sendToPlayer(new SRefillSound(), (EntityPlayerMP)this.player);
        }
    }

    private void setAndSyncSlot(int index, ItemStack item) {
        if (index < 0 || index > 40) {
            return;
        }
        int slot = index;
        if (index < 36) {
            this.inventory.field_70462_a.set(index, (Object)item);
            slot = index < 9 ? (slot += 36) : (slot += 9);
        } else if (index < 40) {
            this.inventory.field_70460_b.set(index - 36, (Object)item);
            slot += 5;
        } else {
            this.inventory.field_184439_c.set(0, (Object)item);
            slot = 45;
        }
        if (!item.func_190926_b()) {
            this.player.field_71069_bz.field_75153_a.set(slot, (Object)ItemStack.field_190927_a);
        }
    }

    private ItemStack getItem(int index) {
        if (index < 36) {
            return (ItemStack)this.inventory.field_70462_a.get(index);
        }
        if (index < 40) {
            return (ItemStack)this.inventory.field_70462_a.get(index - 36);
        }
        return (ItemStack)this.inventory.field_184439_c.get(0);
    }

    private static boolean matchTags(ItemStack stackA, ItemStack stackB) {
        if (stackA.func_77978_p() == null && stackB.func_77978_p() != null) {
            return false;
        }
        return (stackA.func_77978_p() == null || stackA.func_77978_p().equals((Object)stackB.func_77978_p())) && stackA.areCapsCompatible(stackB);
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("gregtech.api.items.toolitem.IGTTool", false, RefillHandler.class.getClassLoader());
        }
        catch (Exception ignored) {
            clazz = null;
        }
        gtToolClass = clazz;
        INVENTORY_PROXIMITY_MAP = new int[][]{{1, 2, 3, 4, 5, 6, 7, 8, 27, 18, 9, 28, 19, 10, 29, 20, 11, 30, 21, 12, 31, 22, 13, 32, 23, 14, 33, 24, 15, 34, 25, 16, 35, 26, 17}, {0, 2, 3, 4, 5, 6, 7, 8, 28, 19, 10, 27, 18, 9, 29, 20, 11, 30, 21, 12, 31, 22, 13, 32, 23, 14, 33, 24, 15, 34, 25, 16, 35, 26, 17}, {1, 3, 0, 4, 5, 6, 7, 8, 29, 20, 11, 28, 19, 10, 30, 21, 12, 27, 18, 9, 31, 22, 13, 32, 23, 14, 33, 24, 15, 34, 25, 16, 35, 26, 17}, {2, 4, 1, 5, 0, 6, 7, 8, 30, 21, 12, 29, 20, 11, 31, 22, 13, 28, 19, 10, 32, 23, 14, 27, 18, 9, 33, 24, 15, 34, 25, 16, 35, 26, 17}, {3, 5, 2, 6, 1, 7, 0, 8, 31, 22, 13, 30, 21, 12, 32, 23, 14, 29, 20, 11, 33, 24, 15, 28, 19, 10, 34, 25, 16, 27, 18, 9, 35, 26, 17}, {4, 6, 3, 7, 2, 8, 1, 0, 32, 23, 14, 31, 22, 13, 33, 24, 15, 30, 21, 12, 34, 25, 16, 29, 20, 11, 35, 26, 17, 28, 19, 10, 27, 18, 9}, {5, 7, 4, 8, 3, 2, 1, 0, 33, 24, 15, 32, 23, 14, 34, 25, 16, 31, 22, 13, 35, 26, 17, 30, 21, 12, 29, 20, 11, 28, 19, 10, 27, 18, 9}, {6, 8, 5, 4, 3, 2, 1, 0, 34, 25, 16, 33, 24, 15, 35, 26, 17, 32, 23, 14, 31, 22, 13, 30, 21, 12, 29, 20, 11, 28, 19, 10, 27, 18, 9}, {7, 6, 5, 4, 3, 2, 1, 0, 35, 26, 17, 34, 25, 16, 33, 24, 15, 32, 23, 14, 31, 22, 13, 30, 21, 12, 29, 20, 11, 28, 19, 10, 27, 18, 9}};
    }
}

