/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.sort;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.BogoSorter;
import com.cleanroommc.bogosorter.ClientEventHandler;
import com.cleanroommc.bogosorter.api.ISlot;
import com.cleanroommc.bogosorter.api.SortRule;
import com.cleanroommc.bogosorter.common.McUtils;
import com.cleanroommc.bogosorter.common.config.BogoSorterConfig;
import com.cleanroommc.bogosorter.common.network.CSlotSync;
import com.cleanroommc.bogosorter.common.network.NetworkHandler;
import com.cleanroommc.bogosorter.common.sort.ClientItemSortRule;
import com.cleanroommc.bogosorter.common.sort.ClientSortData;
import com.cleanroommc.bogosorter.common.sort.GuiSortingContext;
import com.cleanroommc.bogosorter.common.sort.ItemCompareHelper;
import com.cleanroommc.bogosorter.common.sort.ItemSortContainer;
import com.cleanroommc.bogosorter.common.sort.NbtSortRule;
import com.cleanroommc.bogosorter.common.sort.SlotGroup;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class SortHandler {
    public static final Map<EntityPlayer, List<SortRule<ItemStack>>> cacheItemSortRules = new Object2ObjectOpenHashMap();
    public static final Map<EntityPlayer, List<NbtSortRule>> cacheNbtSortRules = new Object2ObjectOpenHashMap();
    public static final AtomicReference<List<NbtSortRule>> currentNbtSortRules = new AtomicReference(Collections.emptyList());
    public static SoundEvent sortSound = SoundEvents.field_187909_gi;
    private final EntityPlayer player;
    private final Container container;
    private final GuiSortingContext context;
    private final Comparator<ItemSortContainer> containerComparator;
    private final Int2ObjectMap<ClientSortData> clientSortData;
    private final List<SortRule<ItemStack>> itemSortRules;

    @SideOnly(value=Side.CLIENT)
    public static void playSortSound() {
        SoundEvent sound = BogoSorter.isAprilFools() ? (SoundEvent)SoundEvent.field_187505_a.func_148754_a(BogoSorter.RND.nextInt(SoundEvent.field_187505_a.func_148742_b().size())) : sortSound;
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)sound, (float)1.0f));
    }

    public SortHandler(EntityPlayer entityPlayer, Container container, Int2ObjectMap<ClientSortData> clientSortData) {
        this(entityPlayer, container, GuiSortingContext.getOrCreate(container), clientSortData);
    }

    public SortHandler(EntityPlayer player, Container container, GuiSortingContext sortingContext, Int2ObjectMap<ClientSortData> clientSortData) {
        this.player = player;
        this.container = container;
        this.context = sortingContext;
        this.itemSortRules = cacheItemSortRules.getOrDefault(player, Collections.emptyList());
        this.containerComparator = (container1, container2) -> {
            int result;
            for (SortRule<ItemStack> sortRule : this.itemSortRules) {
                result = sortRule instanceof ClientItemSortRule ? ((ClientItemSortRule)sortRule).compareServer((ItemSortContainer)container1, (ItemSortContainer)container2) : sortRule.compare(container1.getItemStack(), container2.getItemStack());
                if (result == 0) continue;
                return result;
            }
            result = ItemCompareHelper.compareRegistryOrder(container1.getItemStack(), container2.getItemStack());
            if (result != 0) {
                return result;
            }
            result = ItemCompareHelper.compareMeta(container1.getItemStack(), container2.getItemStack());
            return result;
        };
        this.clientSortData = clientSortData;
    }

    public void sort(int slotId) {
        this.sort(slotId, true);
    }

    public void sort(int slotId, boolean sync) {
        SlotGroup slotGroup = this.context.getSlotGroup(slotId);
        this.sort(slotGroup, sync);
    }

    public void sort(SlotGroup slotGroup, boolean sync) {
        if (slotGroup != null) {
            if (BogoSorter.isAprilFools() && BogoSorter.RND.nextFloat() < 0.01f) {
                SortHandler.sortBogo(slotGroup);
                this.player.func_145747_a((ITextComponent)new TextComponentString("Get Bogo'd!"));
            } else {
                this.sortHorizontal(slotGroup);
            }
            if (sync) {
                this.container.func_75142_b();
            }
        }
    }

    public void sortHorizontal(SlotGroup slotGroup) {
        LinkedList<ItemSortContainer> itemList = this.gatherItems(slotGroup);
        if (itemList.isEmpty()) {
            return;
        }
        currentNbtSortRules.set(cacheNbtSortRules.getOrDefault(this.player, Collections.emptyList()));
        itemList.sort(this.containerComparator);
        currentNbtSortRules.set(Collections.emptyList());
        ItemSortContainer itemSortContainer = itemList.pollFirst();
        if (itemSortContainer == null) {
            return;
        }
        for (ISlot slot : slotGroup.getSlots()) {
            if (itemSortContainer == null) {
                slot.bogo$putStack(ItemStack.field_190927_a);
                continue;
            }
            int max = Math.min(slot.bogo$getItemStackLimit(itemSortContainer.getItemStack()), slot.bogo$getMaxStackSize(itemSortContainer.getItemStack()));
            if (max <= 0) continue;
            slot.bogo$putStack(itemSortContainer.makeStack(max));
            if (itemSortContainer.canMakeStack()) continue;
            itemSortContainer = itemList.pollFirst();
        }
        if (!itemList.isEmpty()) {
            McUtils.giveItemsToPlayer(this.player, SortHandler.prepareDropList(itemList));
        }
    }

    public static void sortBogo(SlotGroup slotGroup) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ISlot slot : slotGroup.getSlots()) {
            ItemStack stack = slot.bogo$getStack();
            items.add(stack);
        }
        Collections.shuffle(items);
        List<ISlot> slots = slotGroup.getSlots();
        for (int i = 0; i < slots.size(); ++i) {
            ISlot slot = slots.get(i);
            slot.bogo$putStack((ItemStack)items.get(i));
        }
    }

    public LinkedList<ItemSortContainer> gatherItems(SlotGroup slotGroup) {
        LinkedList<ItemSortContainer> list = new LinkedList<ItemSortContainer>();
        Object2ObjectOpenCustomHashMap items = new Object2ObjectOpenCustomHashMap(BogoSortAPI.ITEM_META_NBT_HASH_STRATEGY);
        for (ISlot slot : slotGroup.getSlots()) {
            ItemStack stack = slot.bogo$getStack();
            if (stack.func_190926_b()) continue;
            ItemSortContainer container1 = (ItemSortContainer)items.get((Object)stack);
            if (container1 == null) {
                container1 = new ItemSortContainer(stack, (ClientSortData)this.clientSortData.get(slot.bogo$getSlotNumber()));
                items.put((Object)stack, (Object)container1);
                list.add(container1);
                continue;
            }
            container1.grow(stack.func_190916_E());
        }
        return list;
    }

    private static List<ItemStack> prepareDropList(List<ItemSortContainer> sortedList) {
        ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
        for (ItemSortContainer itemSortContainer : sortedList) {
            while (itemSortContainer.canMakeStack()) {
                dropList.add(itemSortContainer.makeStack(itemSortContainer.getItemStack().func_77976_d()));
            }
        }
        return dropList;
    }

    @SideOnly(value=Side.CLIENT)
    public static Comparator<ItemStack> getClientItemComparator() {
        return (stack1, stack2) -> {
            int result = 0;
            for (SortRule<ItemStack> sortRule : BogoSorterConfig.sortRules) {
                result = sortRule.compare((ItemStack)stack1, (ItemStack)stack2);
                if (result == 0) continue;
                return result;
            }
            result = ItemCompareHelper.compareRegistryOrder(stack1, stack2);
            if (result != 0) {
                return result;
            }
            result = ItemCompareHelper.compareMeta(stack1, stack2);
            return result;
        };
    }

    public void clearAllItems(ISlot slot1) {
        SlotGroup slotGroup = this.context.getSlotGroup(slot1.bogo$getSlotNumber());
        if (slotGroup != null) {
            ArrayList<Pair<ItemStack, Integer>> slots = new ArrayList<Pair<ItemStack, Integer>>();
            for (ISlot slot : slotGroup.getSlots()) {
                if (slot.bogo$getStack().func_190926_b()) continue;
                slot.bogo$putStack(ItemStack.field_190927_a);
                slots.add((Pair<ItemStack, Integer>)Pair.of((Object)ItemStack.field_190927_a, (Object)slot.bogo$getSlotNumber()));
            }
            NetworkHandler.sendToServer(new CSlotSync(slots));
        }
    }

    public void randomizeItems(ISlot slot1) {
        SlotGroup slotGroup = this.context.getSlotGroup(slot1.bogo$getSlotNumber());
        if (slotGroup != null) {
            ArrayList<Pair<ItemStack, Integer>> slots = new ArrayList<Pair<ItemStack, Integer>>();
            Random random = new Random();
            for (ISlot slot : slotGroup.getSlots()) {
                if (!(random.nextFloat() < 0.3f)) continue;
                ItemStack randomItem = ClientEventHandler.allItems.get(random.nextInt(ClientEventHandler.allItems.size())).func_77946_l();
                slot.bogo$putStack(randomItem.func_77946_l());
                slots.add((Pair<ItemStack, Integer>)Pair.of((Object)randomItem, (Object)slot.bogo$getSlotNumber()));
            }
            NetworkHandler.sendToServer(new CSlotSync(slots));
        }
    }
}

