/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.clochepp.cloche;

import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import xyz.phanta.clochepp.cloche.SoilType;
import xyz.phanta.clochepp.util.ComparableItemMap;
import xyz.phanta.clochepp.util.FloatUtils;

public class SimplePlantHandler
implements BelljarHandler.IPlantHandler {
    public static final ItemStack[] NO_STACKS = new ItemStack[0];
    public static final IBlockState[] NO_STATES = new IBlockState[0];
    private final ComparableItemMap<Entry> entries;

    public SimplePlantHandler(boolean compareOreDict, boolean compareNbt) {
        this.entries = new ComparableItemMap(compareOreDict, compareNbt);
    }

    public void addEntry(Entry entry) {
        this.entries.put(entry.seedStack, entry);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public boolean isCorrectSoil(ItemStack seedStack, ItemStack soilStack) {
        return this.entries.lookup(seedStack).map(e -> ((Entry)e).soilType.test(soilStack)).orElse(false);
    }

    public float getGrowthStep(ItemStack seedStack, ItemStack soilStack, float growth, TileEntity tile, float fertilizer, boolean render) {
        return this.entries.lookup(seedStack).map(e -> Float.valueOf(fertilizer / (float)((Entry)e).growthTicks)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public ItemStack[] getOutput(ItemStack seedStack, ItemStack soilStack, TileEntity tile) {
        return this.entries.lookup(seedStack).map(e -> ((Entry)e).outputStacks).orElse(NO_STACKS);
    }

    public boolean isValid(ItemStack seedStack) {
        return this.entries.containsKey(seedStack);
    }

    public IBlockState[] getRenderedPlant(ItemStack seedStack, ItemStack soilStack, float growth, TileEntity tile) {
        return this.entries.lookup(seedStack).map(e -> (IBlockState[])FloatUtils.discretize(growth, ((Entry)e).growthStages)).orElse(NO_STATES);
    }

    @Nullable
    public ResourceLocation getSoilTexture(ItemStack seedStack, ItemStack soilStack, TileEntity tile) {
        return this.entries.lookup(seedStack).map(e -> ((Entry)e).soilType.getDisplay()).orElse(null);
    }

    public static class Entry {
        private final ItemStack seedStack;
        private final ItemStack[] outputStacks;
        private SoilType soilType = SoilType.DIRT;
        private int growthTicks = 320;
        private IBlockState[][] growthStages = new IBlockState[0][];

        public Entry(ItemStack seedStack, ItemStack ... outputStacks) {
            this.seedStack = seedStack;
            this.outputStacks = outputStacks;
        }

        public Entry withSoilType(SoilType type) {
            this.soilType = type;
            return this;
        }

        public Entry withGrowthTicks(int ticks) {
            this.growthTicks = ticks;
            return this;
        }

        public Entry withGrowthStages(IBlockState ... stages) {
            this.growthStages = new IBlockState[stages.length][];
            for (int i = 0; i < this.growthStages.length; ++i) {
                this.growthStages[i] = new IBlockState[]{stages[i]};
            }
            return this;
        }

        public Entry withGrowthStageVar(Block block, IProperty<Integer> prop) {
            int maxAge = prop.func_177700_c().stream().mapToInt(i -> i).max().orElseThrow(() -> new IllegalStateException("Bad property: " + prop));
            IBlockState defaultState = block.func_176223_P();
            IBlockState[] states = new IBlockState[maxAge + 1];
            for (int i2 = 0; i2 < states.length; ++i2) {
                states[i2] = defaultState.func_177226_a(prop, (Comparable)Integer.valueOf(i2));
            }
            return this.withGrowthStages(states);
        }
    }
}

