/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.clochepp.component;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;
import xyz.phanta.clochepp.ClochePP;
import xyz.phanta.clochepp.CppConfig;
import xyz.phanta.clochepp.moduleapi.ClocheComponent;

public class ComponentManager {
    private static final Set<String> disabledComponents = Sets.newHashSet((Object[])CppConfig.disabledComponents);
    private final Table<String, String, ComponentState> components = HashBasedTable.create();

    public ClocheComponent getOrPut(String moduleId, String name, String ... deps) {
        ComponentState component = (ComponentState)this.components.get((Object)moduleId, (Object)name);
        if (component == null) {
            boolean enabled;
            ClochePP.LOGGER.debug("Module {} registered new component {}.", (Object)moduleId, (Object)name);
            if (disabledComponents.contains(moduleId + ":" + name)) {
                ClochePP.LOGGER.debug("Component {}:{} disabled via config.", (Object)moduleId, (Object)name);
                enabled = false;
            } else {
                enabled = true;
                for (String dep : deps) {
                    if (Loader.isModLoaded((String)dep)) continue;
                    ClochePP.LOGGER.debug("Component {}:{} is missing dependency {}.", (Object)moduleId, (Object)name, (Object)dep);
                    enabled = false;
                }
            }
            component = new ComponentState(enabled);
            this.components.put((Object)moduleId, (Object)name, (Object)component);
        }
        return component;
    }

    private static class ComponentState
    implements ClocheComponent {
        private final boolean enabled;
        private final Set<String> deps = new HashSet<String>();

        ComponentState(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

