/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.clochepp.module.agricraft;

import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.requirement.IGrowthRequirement;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.api.v1.util.FuzzyStack;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import com.infinityraider.agricraft.renderers.PlantRenderer;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import com.infinityraider.infinitylib.render.tessellation.TessellatorVertexBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xyz.phanta.clochepp.CppConfig;
import xyz.phanta.clochepp.cloche.SimplePlantHandler;
import xyz.phanta.clochepp.cloche.SoilType;
import xyz.phanta.clochepp.module.agricraft.SimulatedAgriCrop;
import xyz.phanta.clochepp.util.FloatUtils;
import xyz.phanta.clochepp.util.RepeatCollection;

public class AgriPlantHandler
implements BelljarHandler.IPlantHandler {
    private static final Random rand = new Random();
    private final Map<IAgriPlant, AgriPlantData> cachedPlantInfo = new HashMap<IAgriPlant, AgriPlantData>();

    public boolean isCorrectSoil(ItemStack seedStack, ItemStack soilStack) {
        return AgriPlantHandler.lookupSeed(seedStack).map(s -> this.getPlantData((AgriSeed)s).getSoilType().test(AgriPlantHandler.getEffSoil(soilStack))).orElse(false);
    }

    public float getGrowthStep(ItemStack seedStack, ItemStack soilStack, float growth, TileEntity tile, float fertilizer, boolean render) {
        return AgriPlantHandler.lookupSeed(seedStack).map(s -> Float.valueOf(this.getPlantData((AgriSeed)s).computeGrowth(s.getStat(), fertilizer))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public ItemStack[] getOutput(ItemStack seedStack, ItemStack soilStack, TileEntity tile) {
        return AgriPlantHandler.lookupSeed(seedStack).map(s -> this.getPlantData((AgriSeed)s).getDrops((AgriSeed)s, AgriPlantHandler.getEffSoil(soilStack), tile)).orElse(SimplePlantHandler.NO_STACKS);
    }

    public boolean isValid(ItemStack seedStack) {
        return AgriApi.getSeedRegistry().hasAdapter((Object)seedStack);
    }

    public IBlockState[] getRenderedPlant(ItemStack seedStack, ItemStack soilStack, float growth, TileEntity tile) {
        return SimplePlantHandler.NO_STATES;
    }

    public boolean overrideRender(ItemStack seedStack, ItemStack soilStack, float growth, TileEntity tile, BlockRendererDispatcher renderer) {
        AgriPlantHandler.lookupSeed(seedStack).ifPresent(s -> this.getPlantData((AgriSeed)s).render(growth, this.getRenderSize(seedStack, soilStack, growth, tile)));
        return true;
    }

    private static Optional<AgriSeed> lookupSeed(ItemStack seedStack) {
        return AgriApi.getSeedRegistry().getAdapter((Object)seedStack).flatMap(a -> a.valueOf((Object)seedStack));
    }

    private AgriPlantData getPlantData(AgriSeed seed) {
        return this.cachedPlantInfo.computeIfAbsent(seed.getPlant(), x$0 -> new AgriPlantData((IAgriPlant)x$0));
    }

    private static ItemStack getEffSoil(ItemStack soilStack) {
        return SoilType.DIRT.test(soilStack) ? new ItemStack(Blocks.field_150458_ak) : soilStack;
    }

    private class AgriPlantData {
        private final IAgriPlant plant;
        private final double growthChanceBase;
        private final double growthChanceAdditional;
        private final int growthStages;
        private final double spreadChance;
        private final SoilType soilType;

        public AgriPlantData(IAgriPlant plant) {
            this.plant = plant;
            this.growthChanceBase = plant.getGrowthChanceBase();
            this.growthChanceAdditional = plant.getGrowthChanceBonus();
            this.growthStages = plant.getGrowthStages();
            this.spreadChance = plant.getSpreadChance();
            IGrowthRequirement reqs = plant.getGrowthRequirement();
            FuzzyStack cond = reqs.getConditionStack().orElse(null);
            if (cond != null) {
                this.soilType = new SoilType(s -> FuzzyStack.from((ItemStack)s).map(arg_0 -> ((FuzzyStack)cond).equals(arg_0)).orElse(false), null);
            } else {
                Collection soils = reqs.getSoils();
                this.soilType = new SoilType(s -> soils.stream().anyMatch(t -> t.isVarient(s)), null);
            }
        }

        public SoilType getSoilType() {
            return this.soilType;
        }

        public float computeGrowth(IAgriStat seedStats, float fertilizer) {
            return (float)((this.growthChanceBase + this.growthChanceAdditional * (double)seedStats.getGrowth()) * (double)AgriCraftConfig.growthMultiplier / (double)this.growthStages) * fertilizer / 40.0f * (float)CppConfig.agriCraftGrowthRateModifier;
        }

        public ItemStack[] getDrops(AgriSeed seed, ItemStack soilStack, TileEntity tile) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            SimulatedAgriCrop crop = new SimulatedAgriCrop(tile, seed, soilStack);
            IAgriStat stats = seed.getStat();
            for (int i = (stats.getGain() + 3) / 3; i > 0; --i) {
                this.plant.getHarvestProducts(drops::add, (IAgriCrop)crop, stats, rand);
            }
            int neighborCnt = CppConfig.agriCraftSeedSpreadNeighborCount;
            if (neighborCnt > 0 && rand.nextDouble() < this.spreadChance) {
                if (neighborCnt == 1) {
                    drops.add(seed.toStack());
                } else {
                    AgriApi.getStatCalculatorRegistry().valueOf((Object)this.plant).map(c -> new AgriSeed(this.plant, c.calculateSpreadStats(this.plant, new RepeatCollection<SimulatedAgriCrop>(crop, neighborCnt)))).ifPresent(s -> drops.add(s.toStack()));
                }
            }
            return drops.toArray(SimplePlantHandler.NO_STACKS);
        }

        @SideOnly(value=Side.CLIENT)
        public void render(float growth, float scale) {
            float scaleInv = 0.0625f / scale;
            GlStateManager.func_179118_c();
            GlStateManager.func_179141_d();
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179109_b((float)scaleInv, (float)0.0f, (float)scaleInv);
            TessellatorVertexBuffer tess = TessellatorVertexBuffer.getInstance();
            tess.startDrawingQuads(DefaultVertexFormats.field_181712_l);
            PlantRenderer.renderPlant((ITessellator)tess, (IAgriPlant)this.plant, (int)FloatUtils.discretize(growth, this.growthStages));
            tess.draw();
            GlStateManager.func_179121_F();
        }
    }
}

