/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.mojang.authlib.GameProfile;
import com.rwtema.funkylocomotion.blocks.BlockMassFrameCorner;
import com.rwtema.funkylocomotion.blocks.FLBlocks;
import com.rwtema.funkylocomotion.blocks.TileMassFrame;
import com.rwtema.funkylocomotion.blocks.TilePusher;
import com.rwtema.funkylocomotion.helper.NullHelper;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileMassFrameController
extends TileMassFrame {
    BlockPos start = BlockPos.field_177992_a;
    BlockPos end = BlockPos.field_177992_a;
    int energyRequirements = -1;

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.start = new BlockPos(tag.func_74762_e("start_x"), tag.func_74762_e("start_y"), tag.func_74762_e("start_z"));
        this.end = new BlockPos(tag.func_74762_e("end_x"), tag.func_74762_e("end_y"), tag.func_74762_e("end_z"));
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74768_a("start_x", this.start.func_177958_n());
        tag.func_74768_a("start_y", this.start.func_177956_o());
        tag.func_74768_a("start_z", this.start.func_177952_p());
        tag.func_74768_a("end_x", this.end.func_177958_n());
        tag.func_74768_a("end_y", this.end.func_177956_o());
        tag.func_74768_a("end_z", this.end.func_177952_p());
        return super.func_189515_b(tag);
    }

    public void recalcEnergy() {
        BlockPos.MutableBlockPos blockPos;
        IBlockState blockState;
        Block block;
        this.energyRequirements = 0;
        if (this.start.equals((Object)this.end) || TilePusher.powerPerTile == 0) {
            return;
        }
        int numBlocks = 0;
        Iterator iterator = BlockPos.func_177975_b((BlockPos)this.field_174879_c.func_177971_a((Vec3i)this.start), (BlockPos)this.field_174879_c.func_177971_a((Vec3i)this.end)).iterator();
        while (iterator.hasNext() && ((block = (blockState = this.field_145850_b.func_180495_p((BlockPos)(blockPos = (BlockPos.MutableBlockPos)iterator.next()))).func_177230_c()) == NullHelper.notNull(FLBlocks.MASS_FRAME_CORNER) || block == NullHelper.notNull(FLBlocks.MASS_FRAME_EDGE) || block.isAir(blockState, (IBlockAccess)this.field_145850_b, (BlockPos)blockPos) || ++numBlocks <= TilePusher.maxTiles)) {
        }
        this.energyRequirements = numBlocks * TilePusher.powerPerTile;
    }

    @Override
    public EnumActionResult canMove(World worldObj, BlockPos pos, @Nullable GameProfile profile) {
        BlockPos end = this.func_174877_v().func_177971_a((Vec3i)this.end);
        BlockPos start = this.func_174877_v().func_177971_a((Vec3i)this.start);
        if (!BlockMassFrameCorner.checkEdgeFrame(this.field_145850_b, null, start.func_177958_n(), start.func_177956_o(), start.func_177952_p(), end.func_177958_n(), end.func_177956_o(), end.func_177952_p())) {
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public Iterable<BlockPos> getBlocksToMove(World world, BlockPos pos) {
        this.recalcEnergy();
        if (this.start.equals((Object)this.end)) {
            return ImmutableSet.of();
        }
        BlockPos end = this.func_174877_v().func_177971_a((Vec3i)this.end);
        BlockPos start = this.func_174877_v().func_177971_a((Vec3i)this.start);
        if (!BlockMassFrameCorner.checkEdgeFrame(world, null, start.func_177958_n(), start.func_177956_o(), start.func_177952_p(), end.func_177958_n(), end.func_177956_o(), end.func_177952_p())) {
            return ImmutableList.of();
        }
        Stream posStream = Streams.stream((Iterable)BlockPos.func_177980_a((BlockPos)start, (BlockPos)end));
        return posStream::iterator;
    }
}

