/*
 * Decompiled with CFR 0.152.
 */
package ninjabrain.gendustryjei.wrappers;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.ISpeciesRoot;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import net.bdew.gendustry.forestry.GeneSampleInfo;
import net.bdew.gendustry.items.GeneSample;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import ninjabrain.gendustryjei.util.GeneticHelper;
import ninjabrain.gendustryjei.wrappers.WrapperGenetic;

public class WrapperSampler
extends WrapperGenetic {
    ISpeciesRoot root;
    IAllele[] input;
    ItemStack output;
    static List<ItemStack> labware = Collections.singletonList(WrapperSampler.createLabwareStack());
    static List<ItemStack> blankSample = Collections.singletonList(new ItemStack(Item.func_111206_d((String)"gendustry:gene_sample_blank")));
    private float chance = 0.0f;

    public WrapperSampler(IAllele[] input, IAllele allele, int chromosome, ISpeciesRoot root) {
        this.root = root;
        this.input = input;
        this.output = GeneSample.newStack((GeneSampleInfo)new GeneSampleInfo(root, chromosome, allele));
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
        inputs.add(GeneticHelper.getAllItemsFromTemplate(this.root, this.input));
        inputs.add(blankSample);
        inputs.add(labware);
        ingredients.setInputLists(ItemStack.class, inputs);
        ingredients.setOutput(ItemStack.class, (Object)this.output);
    }

    public void setInputStack(ItemStack inputStack) {
        if (AlleleManager.alleleRegistry.isIndividual(inputStack)) {
            GeneSampleInfo info = GeneSample.getInfo((ItemStack)this.output);
            IAllele outputAllele = info.allele();
            int chromosomeNumber = info.chromosome();
            IChromosome[] chromosomes = AlleleManager.alleleRegistry.getIndividual(inputStack).getGenome().getChromosomes();
            int matchingAlleles = 0;
            if (chromosomeNumber < chromosomes.length) {
                if (chromosomes[chromosomeNumber].getPrimaryAllele() == outputAllele) {
                    ++matchingAlleles;
                }
                if (chromosomes[chromosomeNumber].getSecondaryAllele() == outputAllele) {
                    ++matchingAlleles;
                }
            }
            this.chance = (float)matchingAlleles / 2.0f / (float)chromosomes.length;
        } else {
            this.chance = -1.0f;
        }
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        if (this.chance != -1.0f) {
            minecraft.field_71466_p.func_78276_b(String.format("Chance: %.1f%%", Float.valueOf(this.chance * 100.0f)), 40, 46, Color.darkGray.getRGB());
        }
    }
}

