/*
 * Decompiled with CFR 0.152.
 */
package mods.su5ed.ic2patcher.asm;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import net.minecraftforge.fml.common.patcher.ClassPatch;
import net.minecraftforge.fml.repackage.com.nothome.delta.GDiffPatcher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BinPatchManager {
    public static final boolean dumpPatched = Boolean.parseBoolean(System.getProperty("fml.dumpPatchedClasses", "false"));
    public static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("fml.debugClassPatchManager", "false"));
    public static final Logger LOG = LogManager.getLogger((String)"BinPatchManager");
    public static final BinPatchManager INSTANCE = new BinPatchManager();
    private final GDiffPatcher patcher = new GDiffPatcher();
    private ListMultimap<String, ClassPatch> patches;
    private final Map<String, byte[]> patchedClasses = Maps.newHashMap();
    private File tempDir;

    private BinPatchManager() {
        if (dumpPatched) {
            this.tempDir = Files.createTempDir();
            LOG.info("Dumping patched classes to {}", (Object)this.tempDir.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] applyPatch(String name, String mappedName, byte[] inputData) {
        if (this.patches == null) {
            return inputData;
        }
        if (this.patchedClasses.containsKey(name)) {
            return this.patchedClasses.get(name);
        }
        List list = this.patches.get((Object)name);
        if (list.isEmpty()) {
            return inputData;
        }
        boolean ignoredError = false;
        if (DEBUG) {
            LOG.debug("Runtime patching class {} (input size {}), found {} patch{}", (Object)mappedName, (Object)(inputData == null ? 0 : inputData.length), (Object)list.size(), (Object)(list.size() != 1 ? "es" : ""));
        }
        for (ClassPatch patch : list) {
            if (!patch.targetClassName.equals(mappedName) && !patch.sourceClassName.equals(name)) {
                LOG.warn("Binary patch found {} for wrong class {}", (Object)patch.targetClassName, (Object)mappedName);
            }
            if (!(patch.existsAtTarget || inputData != null && inputData.length != 0)) {
                inputData = new byte[]{};
            } else if (!patch.existsAtTarget) {
                LOG.warn("Patcher expecting empty class data file for {}, but received non-empty", (Object)patch.targetClassName);
            } else {
                if (patch.existsAtTarget && (inputData == null || inputData.length == 0)) {
                    LOG.fatal("Patcher expecting non-empty class data file for {}, but received empty.", (Object)patch.targetClassName);
                    throw new RuntimeException(String.format("Patcher expecting non-empty class data file for %s, but received empty, your vanilla jar may be corrupt.", patch.targetClassName));
                }
                int inputChecksum = Hashing.adler32().hashBytes(inputData).asInt();
                if (patch.inputChecksum != inputChecksum) {
                    LOG.fatal("There is a binary discrepancy between the expected input class {} ({}) and the actual class. Checksum on disk is {}, in patch {}. Things are probably about to go very wrong. Did you put something into the jar file?", (Object)mappedName, (Object)name, (Object)Integer.toHexString(inputChecksum), (Object)Integer.toHexString(patch.inputChecksum));
                    if (!Boolean.parseBoolean(System.getProperty("fml.ignorePatchDiscrepancies", "false"))) {
                        LOG.fatal("The game is going to exit, because this is a critical error, and it is very improbable that the modded game will work, please obtain clean jar files.");
                        System.exit(1);
                    } else {
                        LOG.fatal("FML is going to ignore this error, note that the patch will not be applied, and there is likely to be a malfunctioning behaviour, including not running at all");
                        ignoredError = true;
                        continue;
                    }
                }
            }
            GDiffPatcher gDiffPatcher = this.patcher;
            synchronized (gDiffPatcher) {
                try {
                    inputData = this.patcher.patch(inputData, patch.patch);
                }
                catch (IOException e) {
                    LOG.error("Encountered problem runtime patching class {}", (Object)name, (Object)e);
                }
            }
        }
        if (!ignoredError) {
            LOG.info("Successfully applied runtime patches for {} (new size {})", (Object)mappedName, (Object)inputData.length);
        }
        if (dumpPatched) {
            try {
                Files.write((byte[])inputData, (File)new File(this.tempDir, mappedName));
            }
            catch (IOException e) {
                LOG.error(LOG.getMessageFactory().newMessage("Failed to write {} to {}", new Object[]{mappedName, this.tempDir.getAbsolutePath()}), (Throwable)e);
            }
        }
        this.patchedClasses.put(name, inputData);
        return inputData;
    }

    /*
     * Exception decompiling
     */
    public void setup(Map<String, Object> data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ClassPatch readPatch(JarEntry patchEntry, JarInputStream jis) {
        ByteArrayDataInput input;
        if (DEBUG) {
            LOG.trace("Reading patch data from {}", (Object)patchEntry.getName());
        }
        try {
            input = ByteStreams.newDataInput((byte[])ByteStreams.toByteArray((InputStream)jis));
        }
        catch (IOException e) {
            LOG.warn(LOG.getMessageFactory().newMessage("Unable to read binpatch file {} - ignoring", new Object[]{patchEntry.getName()}), (Throwable)e);
            return null;
        }
        byte version = input.readByte();
        String name = input.readUTF();
        String sourceClassName = name.replace('/', '.');
        String targetClassName = input.readUTF().replace('/', '.');
        boolean exists = input.readBoolean();
        int inputChecksum = 0;
        if (exists) {
            inputChecksum = input.readInt();
        }
        int patchLength = input.readInt();
        byte[] patchBytes = new byte[patchLength];
        input.readFully(patchBytes);
        return new ClassPatch(name, sourceClassName, targetClassName, exists, inputChecksum, patchBytes);
    }
}

