/*
 * Decompiled with CFR 0.152.
 */
package mods.su5ed.ic2patcher.compat;

import ic2.core.item.ItemClassicCell;
import ic2.core.item.type.CellType;
import ic2.core.ref.ItemName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mods.su5ed.ic2patcher.Patcher;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class JeiModule
implements IModPlugin {
    private static final MethodHandle INSTANCE_FIELD;
    private static final MethodHandle APPLY_HANDLE;

    public void registerItemSubtypes(ISubtypeRegistry registry) {
        registry.registerSubtypeInterpreter(ItemName.cell.getInstance(), (ISubtypeRegistry.ISubtypeInterpreter)new CellSubtypeInterpreter());
    }

    static {
        MethodHandle applyHandle;
        MethodHandle instanceField;
        try {
            Class<?> classFluidSubtypeInterpreter = Class.forName("mezz.jei.plugins.vanilla.ingredients.item.ItemStackListFactory$FluidSubtypeInterpreter");
            Field fieldInstance = classFluidSubtypeInterpreter.getDeclaredField("INSTANCE");
            fieldInstance.setAccessible(true);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            instanceField = lookup.unreflectGetter(fieldInstance);
            Method methodApply = classFluidSubtypeInterpreter.getDeclaredMethod("apply", ItemStack.class);
            methodApply.setAccessible(true);
            applyHandle = lookup.unreflect(methodApply);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            applyHandle = null;
            instanceField = null;
            Patcher.logger.info("Failed to unreflect members of FluidSubtypeInterpreter, the JEI cell subtype patch won't work");
        }
        INSTANCE_FIELD = instanceField;
        APPLY_HANDLE = applyHandle;
    }

    private static class CellSubtypeInterpreter
    implements ISubtypeRegistry.ISubtypeInterpreter {
        private CellSubtypeInterpreter() {
        }

        public String apply(ItemStack itemStack) {
            ItemClassicCell cell = (ItemClassicCell)ItemName.cell.getInstance();
            CellType type = (CellType)cell.getType(itemStack);
            if (type != null) {
                if (type.isFluidContainer()) {
                    String name = CellSubtypeInterpreter.getName(itemStack);
                    if (name != null) {
                        return name;
                    }
                } else {
                    return "m=" + itemStack.func_77960_j();
                }
            }
            return "";
        }

        private static String getName(ItemStack stack) {
            try {
                Object instance = INSTANCE_FIELD.invoke();
                return APPLY_HANDLE.invoke(instance, stack);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }
}

