/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.proxy.base;

import com.infinityraider.infinitylib.capability.CapabilityHandler;
import com.infinityraider.infinitylib.capability.ICapabilityImplementation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.relauncher.Side;

public interface IProxyBase {
    default public void preInitStart(FMLPreInitializationEvent event) {
    }

    default public void preInitEnd(FMLPreInitializationEvent event) {
    }

    default public void initStart(FMLInitializationEvent event) {
    }

    default public void initEnd(FMLInitializationEvent event) {
    }

    default public void postInitStart(FMLPostInitializationEvent event) {
    }

    default public void postInitEnd(FMLPostInitializationEvent event) {
    }

    default public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
    }

    default public void onServerStarting(FMLServerStartingEvent event) {
    }

    default public void onServerStarted(FMLServerStartedEvent event) {
    }

    default public void onServerStopping(FMLServerStoppingEvent event) {
    }

    default public void onServerStopped(FMLServerStoppedEvent event) {
    }

    public void registerEventHandlers();

    public void activateRequiredModules();

    public void registerCapabilities();

    default public void registerEventHandler(Object handler) {
        MinecraftForge.EVENT_BUS.register(handler);
    }

    default public void registerCapability(ICapabilityImplementation capability) {
        CapabilityHandler.getInstance().registerCapability(capability);
    }

    public Side getPhysicalSide();

    public Side getEffectiveSide();

    default public MinecraftServer getMinecraftServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public EntityPlayer getClientPlayer();

    public World getClientWorld();

    public World getWorldByDimensionId(int var1);

    default public Entity getEntityById(int dimension, int id) {
        return this.getEntityById(this.getWorldByDimensionId(dimension), id);
    }

    default public Entity getEntityById(World world, int id) {
        return world == null ? null : world.func_73045_a(id);
    }

    public void queueTask(Runnable var1);
}

