/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.item;

import com.infinityraider.infinitylib.render.item.IItemRenderingHandler;
import com.infinityraider.infinitylib.render.item.ItemRenderer;
import com.infinityraider.infinitylib.render.item.RenderItemAuto;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ItemRendererRegistry
implements ICustomModelLoader {
    private static final ItemRendererRegistry INSTANCE = new ItemRendererRegistry();
    private final Map<ResourceLocation, ItemRenderer> renderers = new HashMap<ResourceLocation, ItemRenderer>();

    public static ItemRendererRegistry getInstance() {
        return INSTANCE;
    }

    private ItemRendererRegistry() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)this);
    }

    public boolean accepts(ResourceLocation loc) {
        return this.renderers.containsKey(loc);
    }

    public IModel loadModel(ResourceLocation loc) throws Exception {
        return this.renderers.get(loc);
    }

    public void func_110549_a(IResourceManager resourceManager) {
    }

    public void registerCustomItemRenderer(Item item, IItemRenderingHandler handler) {
        ModelResourceLocation itemModel = new ModelResourceLocation(item.getRegistryName(), "inventory");
        ItemRenderer instance = new ItemRenderer(handler);
        ModelLoader.setCustomMeshDefinition((Item)item, stack -> itemModel);
        this.renderers.put((ResourceLocation)itemModel, instance);
    }

    public <T extends Item> void registerCustomItemRendererAuto(T item) {
        ModelResourceLocation itemModel = new ModelResourceLocation(item.getRegistryName(), "inventory");
        ItemRenderer instance = new ItemRenderer(new RenderItemAuto<T>(item));
        ModelLoader.setCustomMeshDefinition(item, stack -> itemModel);
        this.renderers.put((ResourceLocation)itemModel, instance);
    }
}

