/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.kotlinx.serialization.internal;

import java.util.Arrays;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.PublishedApi;
import logisticspipes.kotlin.Unit;
import logisticspipes.kotlin.collections.ArraysKt;
import logisticspipes.kotlin.jvm.functions.Function1;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlinx.serialization.KSerializer;
import logisticspipes.kotlinx.serialization.SerializationException;
import logisticspipes.kotlinx.serialization.descriptors.ClassSerialDescriptorBuilder;
import logisticspipes.kotlinx.serialization.descriptors.SerialDescriptor;
import logisticspipes.kotlinx.serialization.descriptors.SerialDescriptorsKt;
import logisticspipes.kotlinx.serialization.descriptors.SerialKind;
import logisticspipes.kotlinx.serialization.descriptors.StructureKind;
import logisticspipes.kotlinx.serialization.encoding.Decoder;
import logisticspipes.kotlinx.serialization.encoding.Encoder;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0005H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0019"}, d2={"Llogisticspipes/kotlinx/serialization/internal/EnumSerializer;", "T", "", "Llogisticspipes/kotlinx/serialization/KSerializer;", "serialName", "", "values", "", "(Ljava/lang/String;[Ljava/lang/Enum;)V", "descriptor", "Llogisticspipes/kotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "[Ljava/lang/Enum;", "deserialize", "decoder", "Llogisticspipes/kotlinx/serialization/encoding/Decoder;", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/lang/Enum;", "serialize", "", "encoder", "Llogisticspipes/kotlinx/serialization/encoding/Encoder;", "value", "(Lkotlinx/serialization/encoding/Encoder;Ljava/lang/Enum;)V", "toString", "logisticspipes.kotlinx-serialization-core"})
@PublishedApi
public final class EnumSerializer<T extends Enum<T>>
implements KSerializer<T> {
    @NotNull
    private final T[] values;
    @NotNull
    private final SerialDescriptor descriptor;

    public EnumSerializer(@NotNull String serialName, @NotNull T[] values2) {
        Intrinsics.checkNotNullParameter(serialName, "serialName");
        Intrinsics.checkNotNullParameter(values2, "values");
        this.values = values2;
        this.descriptor = SerialDescriptorsKt.buildSerialDescriptor(serialName, SerialKind.ENUM.INSTANCE, new SerialDescriptor[0], (Function1<? super ClassSerialDescriptorBuilder, Unit>)new Function1<ClassSerialDescriptorBuilder, Unit>(this, serialName){
            final /* synthetic */ EnumSerializer<T> this$0;
            final /* synthetic */ String $serialName;
            {
                this.this$0 = $receiver;
                this.$serialName = $serialName;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ClassSerialDescriptorBuilder $this$buildSerialDescriptor) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter($this$buildSerialDescriptor, "$this$buildSerialDescriptor");
                Enum[] enumArray = EnumSerializer.access$getValues$p(this.this$0);
                String string = this.$serialName;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv;
                    void it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    String fqn = string + '.' + it.name();
                    SerialDescriptor enumMemberDescriptor = SerialDescriptorsKt.buildSerialDescriptor$default(fqn, StructureKind.OBJECT.INSTANCE, new SerialDescriptor[0], null, 8, null);
                    ClassSerialDescriptorBuilder.element$default($this$buildSerialDescriptor, it.name(), enumMemberDescriptor, null, false, 12, null);
                }
            }
        });
    }

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void serialize(@NotNull Encoder encoder2, @NotNull T value) {
        Intrinsics.checkNotNullParameter(encoder2, "encoder");
        Intrinsics.checkNotNullParameter(value, "value");
        int index = ArraysKt.indexOf(this.values, value);
        if (index == -1) {
            StringBuilder stringBuilder = new StringBuilder().append(value).append(" is not a valid enum ").append(this.getDescriptor().getSerialName()).append(", must be one of ");
            String string = Arrays.toString(this.values);
            Intrinsics.checkNotNullExpressionValue(string, "toString(this)");
            throw new SerializationException(stringBuilder.append(string).toString());
        }
        encoder2.encodeEnum(this.getDescriptor(), index);
    }

    @Override
    @NotNull
    public T deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        int index = decoder.decodeEnum(this.getDescriptor());
        if (!(0 <= index ? index < this.values.length : false)) {
            throw new SerializationException(index + " is not among valid " + this.getDescriptor().getSerialName() + " enum values, values size is " + this.values.length);
        }
        return this.values[index];
    }

    @NotNull
    public String toString() {
        return "logisticspipes.kotlinx.serialization.internal.EnumSerializer<" + this.getDescriptor().getSerialName() + '>';
    }

    public static final /* synthetic */ Enum[] access$getValues$p(EnumSerializer $this) {
        return $this.values;
    }
}

