/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.kotlinx.serialization.json;

import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.ULong;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.jvm.internal.Reflection;
import logisticspipes.kotlin.text.UStringsKt;
import logisticspipes.kotlinx.serialization.KSerializer;
import logisticspipes.kotlinx.serialization.builtins.BuiltinSerializersKt;
import logisticspipes.kotlinx.serialization.descriptors.PrimitiveKind;
import logisticspipes.kotlinx.serialization.descriptors.SerialDescriptor;
import logisticspipes.kotlinx.serialization.descriptors.SerialDescriptorsKt;
import logisticspipes.kotlinx.serialization.encoding.Decoder;
import logisticspipes.kotlinx.serialization.encoding.Encoder;
import logisticspipes.kotlinx.serialization.json.JsonElement;
import logisticspipes.kotlinx.serialization.json.JsonElementKt;
import logisticspipes.kotlinx.serialization.json.JsonElementSerializersKt;
import logisticspipes.kotlinx.serialization.json.JsonLiteral;
import logisticspipes.kotlinx.serialization.json.internal.JsonExceptionsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Llogisticspipes/kotlinx/serialization/json/JsonLiteralSerializer;", "Llogisticspipes/kotlinx/serialization/KSerializer;", "Llogisticspipes/kotlinx/serialization/json/JsonLiteral;", "()V", "descriptor", "Llogisticspipes/kotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Llogisticspipes/kotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Llogisticspipes/kotlinx/serialization/encoding/Encoder;", "value", "logisticspipes.kotlinx-serialization-json"})
final class JsonLiteralSerializer
implements KSerializer<JsonLiteral> {
    @NotNull
    public static final JsonLiteralSerializer INSTANCE = new JsonLiteralSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor("logisticspipes.kotlinx.serialization.json.JsonLiteral", PrimitiveKind.STRING.INSTANCE);

    private JsonLiteralSerializer() {
    }

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @Override
    public void serialize(@NotNull Encoder encoder2, @NotNull JsonLiteral value) {
        Intrinsics.checkNotNullParameter(encoder2, "encoder");
        Intrinsics.checkNotNullParameter(value, "value");
        JsonElementSerializersKt.access$verify(encoder2);
        if (value.isString()) {
            encoder2.encodeString(value.getContent());
            return;
        }
        Comparable<Long> comparable = JsonElementKt.getLongOrNull(value);
        if (comparable != null) {
            long it = ((Number)((Object)comparable)).longValue();
            boolean bl = false;
            encoder2.encodeLong(it);
            return;
        }
        comparable = UStringsKt.toULongOrNull(value.getContent());
        if (comparable != null) {
            long it = ((ULong)comparable).unbox-impl();
            boolean bl = false;
            encoder2.encodeInline(BuiltinSerializersKt.serializer(ULong.Companion).getDescriptor()).encodeLong(it);
            return;
        }
        comparable = JsonElementKt.getDoubleOrNull(value);
        if (comparable != null) {
            double it = ((Number)((Object)comparable)).doubleValue();
            boolean bl = false;
            encoder2.encodeDouble(it);
            return;
        }
        comparable = JsonElementKt.getBooleanOrNull(value);
        if (comparable != null) {
            boolean it = (Boolean)comparable;
            boolean bl = false;
            encoder2.encodeBoolean(it);
            return;
        }
        encoder2.encodeString(value.getContent());
    }

    @Override
    @NotNull
    public JsonLiteral deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        JsonElement result2 = JsonElementSerializersKt.asJsonDecoder(decoder).decodeJsonElement();
        if (!(result2 instanceof JsonLiteral)) {
            throw JsonExceptionsKt.JsonDecodingException(-1, "Unexpected JSON element, expected JsonLiteral, had " + Reflection.getOrCreateKotlinClass(result2.getClass()), result2.toString());
        }
        return (JsonLiteral)result2;
    }
}

