/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.guis.pipe.ChassisGuiProvider;
import logisticspipes.pipes.PipeLogisticsChassis;
import logisticspipes.pipes.upgrades.ModuleUpgradeManager;
import logisticspipes.proxy.computers.objects.CCSinkResponder;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import network.rs485.logisticspipes.module.Gui;
import network.rs485.logisticspipes.module.PipeServiceProviderUtilKt;
import network.rs485.logisticspipes.property.Property;
import network.rs485.logisticspipes.property.SlottedModule;
import network.rs485.logisticspipes.property.SlottedModuleListProperty;
import network.rs485.logisticspipes.property.UpgradeManagerListProperty;

public class ChassisModule
extends LogisticsModule
implements Gui {
    private final PipeLogisticsChassis parentChassis;
    private final SlottedModuleListProperty modules;
    private final UpgradeManagerListProperty slotUpgradeManagers;

    public ChassisModule(int moduleCount, PipeLogisticsChassis parentChassis) {
        this.parentChassis = parentChassis;
        this.modules = new SlottedModuleListProperty(moduleCount, "modules");
        this.slotUpgradeManagers = new UpgradeManagerListProperty(moduleCount, parentChassis, "chassisUpgradeManagers");
        this.registerPosition(LogisticsModule.ModulePositionType.IN_PIPE, 0);
    }

    @Override
    @Nonnull
    public String getLPName() {
        throw new RuntimeException("Cannot get LP name for " + this);
    }

    @Override
    @Nonnull
    public List<Property<?>> getProperties() {
        return ImmutableList.builder().add((Object)this.modules).add((Object)this.slotUpgradeManagers).build();
    }

    public void installModule(int slot, LogisticsModule module) {
        this.modules.set(slot, module);
    }

    public void removeModule(int slot) {
        this.modules.clear(slot);
    }

    @Nullable
    public LogisticsModule getModule(int slot) {
        return ((SlottedModule)this.modules.get(slot)).getModule();
    }

    public boolean hasModule(int slot) {
        return !((SlottedModule)this.modules.get(slot)).isEmpty();
    }

    public Stream<LogisticsModule> getModules() {
        return this.modules.stream().filter(slottedModule -> !slottedModule.isEmpty()).map(SlottedModule::getModule);
    }

    public Stream<SlottedModule> slottedModules() {
        return this.modules.stream();
    }

    @Override
    public SinkReply sinksItem(@Nonnull ItemStack stack, ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
        int roomForItem;
        SinkReply bestresult = null;
        for (SlottedModule slottedModule : this.modules) {
            SinkReply result2;
            LogisticsModule module = slottedModule.getModule();
            if (module == null || forcePassive && !module.receivePassive() || (result2 = module.sinksItem(stack, item, bestPriority, bestCustomPriority, allowDefault, includeInTransit, forcePassive)) == null || result2.maxNumberOfItems < 0) continue;
            bestresult = result2;
            bestPriority = result2.fixedPriority.ordinal();
            bestCustomPriority = result2.customPriority;
        }
        if (bestresult == null) {
            return null;
        }
        ISlotUpgradeManager upgradeManager = this.parentChassis.getUpgradeManager(LogisticsModule.ModulePositionType.SLOT, ((PipeLogisticsChassis.ChassiTargetInformation)bestresult.addInfo).getModuleSlot());
        IInventoryUtil invUtil = PipeServiceProviderUtilKt.availableSneakyInventories((IPipeServiceProvider)this.parentChassis, upgradeManager).stream().findFirst().orElse(null);
        if (invUtil == null) {
            return null;
        }
        if (includeInTransit) {
            int onRoute = this.parentChassis.countOnRoute(item);
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(onRoute + item.getMaxStackSize());
            roomForItem = invUtil.roomForItem(copy);
            roomForItem -= onRoute;
        } else {
            roomForItem = invUtil.roomForItem(stack);
        }
        if (roomForItem < 1) {
            return null;
        }
        if (bestresult.maxNumberOfItems == 0) {
            return new SinkReply(bestresult, roomForItem);
        }
        return new SinkReply(bestresult, Math.min(bestresult.maxNumberOfItems, roomForItem));
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.modules.stream().filter(slottedModule -> !slottedModule.isEmpty() && tag.func_74764_b("slot" + slottedModule.getSlot())).forEach(slottedModule -> Objects.requireNonNull(slottedModule.getModule()).readFromNBT(tag.func_74775_l("slot" + slottedModule.getSlot())));
        for (int i = 0; i < this.parentChassis.getChassisSize(); ++i) {
            ((ModuleUpgradeManager)this.slotUpgradeManagers.get(i)).readFromNBT(tag, Integer.toString(i));
        }
    }

    @Override
    public void tick() {
        for (SlottedModule slottedModule : this.modules) {
            LogisticsModule module = slottedModule.getModule();
            if (module == null) continue;
            module.tick();
        }
    }

    @Override
    public void finishInit() {
        super.finishInit();
        this.getModules().forEach(LogisticsModule::finishInit);
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean receivePassive() {
        for (SlottedModule slottedModule : this.modules) {
            LogisticsModule module = slottedModule.getModule();
            if (module == null || !module.receivePassive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<CCSinkResponder> queueCCSinkEvent(ItemIdentifierStack item) {
        ArrayList<CCSinkResponder> list = new ArrayList<CCSinkResponder>();
        for (SlottedModule slottedModule : this.modules) {
            LogisticsModule module = slottedModule.getModule();
            if (module == null) continue;
            list.addAll(module.queueCCSinkEvent(item));
        }
        return list;
    }

    @Override
    @Nonnull
    public ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return NewGuiHandler.getGui(ChassisGuiProvider.class).setFlag(this.parentChassis.getUpgradeManager().hasUpgradeModuleUpgrade());
    }

    @Override
    @Nonnull
    public ModuleInHandGuiProvider getInHandGuiProvider() {
        throw new UnsupportedOperationException("Chassis GUI can never be opened in hand");
    }

    @Nonnull
    public ModuleUpgradeManager getModuleUpgradeManager(int slot) {
        return (ModuleUpgradeManager)this.slotUpgradeManagers.get(slot);
    }
}

