/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.guis.module.inpipe;

import logisticspipes.gui.GuiCraftingPipe;
import logisticspipes.modules.ModuleCrafter;
import logisticspipes.network.abstractguis.GuiProvider;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.StaticResolve;
import logisticspipes.utils.gui.DummyContainer;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class CraftingModuleSlot
extends ModuleCoordinatesGuiProvider {
    private boolean isAdvancedSat;
    private int liquidCrafter;
    private int[] amount;
    private boolean hasByproductExtractor;
    private boolean isFuzzy;
    private int cleanupSize;
    private boolean cleanupExclude;

    public CraftingModuleSlot(int id) {
        super(id);
    }

    @Override
    public Object getClientGui(EntityPlayer player) {
        ModuleCrafter module = this.getLogisticsModule(player.func_130014_f_(), ModuleCrafter.class);
        if (module == null) {
            return null;
        }
        return new GuiCraftingPipe(player, module, this.isAdvancedSat, this.liquidCrafter, this.amount, this.hasByproductExtractor, this.isFuzzy, this.cleanupSize, this.cleanupExclude);
    }

    @Override
    public DummyContainer getContainer(EntityPlayer player) {
        ModuleCrafter module = this.getLogisticsModule(player.func_130014_f_(), ModuleCrafter.class);
        if (module == null) {
            return null;
        }
        MainProxy.sendPacketToPlayer(module.getCPipePacket(), player);
        DummyContainer dummy = new DummyContainer(player, module.dummyInventory, module);
        dummy.addNormalSlotsForPlayerInventory(18, 97);
        for (int l = 0; l < 9; ++l) {
            dummy.addFuzzyDummySlot(l, 18 + l * 18, 18, module.inputFuzzy(l));
        }
        dummy.addFuzzyDummySlot(9, 90, 64, module.outputFuzzy());
        for (int i = 0; i < this.liquidCrafter; ++i) {
            int liquidLeft = -(i * 40) - 40;
            dummy.addFluidSlot(i, module.liquidInventory, liquidLeft + 13, 42);
        }
        if (this.hasByproductExtractor) {
            dummy.addDummySlot(10, 197, 104);
        }
        for (int Y = 0; Y < this.cleanupSize; ++Y) {
            for (int X = 0; X < 3; ++X) {
                dummy.addDummySlot(Y * 3 + X, module.cleanupInventory, X * 18 - 57, Y * 18 + 13);
            }
        }
        return dummy;
    }

    @Override
    public GuiProvider template() {
        return new CraftingModuleSlot(this.getId());
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeBoolean(this.isAdvancedSat);
        output.writeInt(this.liquidCrafter);
        output.writeIntArray(this.amount);
        output.writeBoolean(this.hasByproductExtractor);
        output.writeBoolean(this.isFuzzy);
        output.writeInt(this.cleanupSize);
        output.writeBoolean(this.cleanupExclude);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.isAdvancedSat = input.readBoolean();
        this.liquidCrafter = input.readInt();
        this.amount = input.readIntArray();
        this.hasByproductExtractor = input.readBoolean();
        this.isFuzzy = input.readBoolean();
        this.cleanupSize = input.readInt();
        this.cleanupExclude = input.readBoolean();
    }

    public boolean isAdvancedSat() {
        return this.isAdvancedSat;
    }

    public CraftingModuleSlot setAdvancedSat(boolean isAdvancedSat) {
        this.isAdvancedSat = isAdvancedSat;
        return this;
    }

    public int getLiquidCrafter() {
        return this.liquidCrafter;
    }

    public CraftingModuleSlot setLiquidCrafter(int liquidCrafter) {
        this.liquidCrafter = liquidCrafter;
        return this;
    }

    public int[] getAmount() {
        return this.amount;
    }

    public CraftingModuleSlot setAmount(int[] amount) {
        this.amount = amount;
        return this;
    }

    public boolean isHasByproductExtractor() {
        return this.hasByproductExtractor;
    }

    public CraftingModuleSlot setHasByproductExtractor(boolean hasByproductExtractor) {
        this.hasByproductExtractor = hasByproductExtractor;
        return this;
    }

    public boolean isFuzzy() {
        return this.isFuzzy;
    }

    public CraftingModuleSlot setFuzzy(boolean isFuzzy) {
        this.isFuzzy = isFuzzy;
        return this;
    }

    public int getCleanupSize() {
        return this.cleanupSize;
    }

    public CraftingModuleSlot setCleanupSize(int cleanupSize) {
        this.cleanupSize = cleanupSize;
        return this;
    }

    public boolean isCleanupExclude() {
        return this.cleanupExclude;
    }

    public CraftingModuleSlot setCleanupExclude(boolean cleanupExclude) {
        this.cleanupExclude = cleanupExclude;
        return this;
    }
}

