/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.abstractpackets.ModuleCoordinatesPacket;
import logisticspipes.renderer.GuiOverlay;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class SlotFinderActivatePacket
extends ModuleCoordinatesPacket {
    private int targetPosX;
    private int targetPosY;
    private int targetPosZ;
    private int slot;

    public SlotFinderActivatePacket(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new SlotFinderActivatePacket(this.getId());
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeInt(this.targetPosX);
        output.writeInt(this.targetPosY);
        output.writeInt(this.targetPosZ);
        output.writeInt(this.slot);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.targetPosX = input.readInt();
        this.targetPosY = input.readInt();
        this.targetPosZ = input.readInt();
        this.slot = input.readInt();
    }

    @Override
    public void processPacket(EntityPlayer player) {
        GuiOverlay overlay = GuiOverlay.getInstance();
        overlay.setPipePosX(this.getPosX());
        overlay.setPipePosY(this.getPosY());
        overlay.setPipePosZ(this.getPosZ());
        overlay.setTargetPosX(this.getTargetPosX());
        overlay.setTargetPosY(this.getTargetPosY());
        overlay.setTargetPosZ(this.getTargetPosZ());
        overlay.setSlot(this.getSlot());
        overlay.setOverlaySlotActive(true);
        overlay.setPositionInt(this.getPositionInt());
        overlay.setPositionType(this.getType());
    }

    public int getTargetPosX() {
        return this.targetPosX;
    }

    public SlotFinderActivatePacket setTargetPosX(int targetPosX) {
        this.targetPosX = targetPosX;
        return this;
    }

    public int getTargetPosY() {
        return this.targetPosY;
    }

    public SlotFinderActivatePacket setTargetPosY(int targetPosY) {
        this.targetPosY = targetPosY;
        return this;
    }

    public int getTargetPosZ() {
        return this.targetPosZ;
    }

    public SlotFinderActivatePacket setTargetPosZ(int targetPosZ) {
        this.targetPosZ = targetPosZ;
        return this;
    }

    public int getSlot() {
        return this.slot;
    }

    public SlotFinderActivatePacket setSlot(int slot) {
        this.slot = slot;
        return this;
    }
}

