/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.PipeFluidTransportLogistics;
import logisticspipes.utils.FluidIdentifierStack;
import logisticspipes.utils.FluidSinkReply;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;

public class PipeFluidInsertion
extends FluidRoutedPipe {
    private final List<Pair<Integer, Integer>> localJamList = new ArrayList<Pair<Integer, Integer>>();
    private int[] nextSendMax = new int[EnumFacing.field_82609_l.length];
    private int[] nextSendMin = new int[EnumFacing.field_82609_l.length];

    public PipeFluidInsertion(Item item) {
        super(item);
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        ArrayList<Integer> tempJamList = new ArrayList<Integer>();
        if (!this.localJamList.isEmpty()) {
            ArrayList<Pair> toRemove = new ArrayList<Pair>();
            for (Pair pair : this.localJamList) {
                pair.setValue2((Integer)pair.getValue2() - 1);
                if ((Integer)pair.getValue2() <= 0) {
                    toRemove.add(pair);
                    continue;
                }
                tempJamList.add((Integer)pair.getValue1());
            }
            if (!toRemove.isEmpty()) {
                this.localJamList.removeAll(toRemove);
            }
        }
        PipeFluidTransportLogistics transport = (PipeFluidTransportLogistics)this.transport;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            FluidStack stack = transport.sideTanks[dir.ordinal()].getFluid();
            if (stack == null) continue;
            stack = stack.copy();
            if (this.nextSendMax[dir.ordinal()] > 0 && stack.amount < transport.sideTanks[dir.ordinal()].getCapacity()) {
                int n = dir.ordinal();
                this.nextSendMax[n] = this.nextSendMax[n] - 1;
                continue;
            }
            if (this.nextSendMin[dir.ordinal()] > 0) {
                int n = dir.ordinal();
                this.nextSendMin[n] = this.nextSendMin[n] - 1;
                continue;
            }
            Pair<Integer, FluidSinkReply> result2 = SimpleServiceLocator.logisticsFluidManager.getBestReply(FluidIdentifierStack.getFromStack(stack), this.getRouter(), tempJamList);
            if (result2 == null || result2.getValue2().sinkAmount <= 0L) {
                this.nextSendMax[dir.ordinal()] = 100;
                this.nextSendMin[dir.ordinal()] = 10;
                continue;
            }
            if (!this.useEnergy((int)(0.01 * (double)result2.getValue2().getSinkAmountInt()))) {
                this.nextSendMax[dir.ordinal()] = 100;
                this.nextSendMin[dir.ordinal()] = 10;
                continue;
            }
            FluidStack toSend = transport.sideTanks[dir.ordinal()].drain(result2.getValue2().getSinkAmountInt(), true);
            ItemIdentifierStack liquidContainer = SimpleServiceLocator.logisticsFluidManager.getFluidContainer(FluidIdentifierStack.getFromStack(toSend));
            LPTravelingItem.LPTravelingItemServer routed = SimpleServiceLocator.routedItemHelper.createNewTravelItem(liquidContainer);
            routed.setDestination(result2.getValue1());
            routed.setTransportMode(IRoutedItem.TransportMode.Passive);
            this.queueRoutedItem(routed, dir);
            this.nextSendMax[dir.ordinal()] = 100;
            this.nextSendMin[dir.ordinal()] = 5;
        }
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74783_a("nextSendMax", this.nextSendMax);
        tag.func_74783_a("nextSendMin", this.nextSendMin);
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.nextSendMax = tag.func_74759_k("nextSendMax");
        if (this.nextSendMax.length < 6) {
            this.nextSendMax = new int[6];
        }
        this.nextSendMin = tag.func_74759_k("nextSendMin");
        if (this.nextSendMin.length < 6) {
            this.nextSendMin = new int[6];
        }
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUID_INSERTION;
    }

    @Override
    public boolean canInsertToTanks() {
        return false;
    }

    @Override
    public boolean canInsertFromSideToTanks() {
        return false;
    }

    @Override
    public boolean canReceiveFluid() {
        return true;
    }
}

