/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import logisticspipes.interfaces.ISpecialTankAccessHandler;
import logisticspipes.interfaces.ISpecialTankHandler;
import logisticspipes.interfaces.ITankUtil;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.streams.jdk8.StreamsKt;
import logisticspipes.pipes.PipeFluidSatellite;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.FluidIdentifierStack;
import logisticspipes.utils.SpecialTankUtil;
import logisticspipes.utils.TankUtil;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import network.rs485.logisticspipes.connection.LPNeighborTileEntityKt;
import network.rs485.logisticspipes.connection.NeighborTileEntity;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0010\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\fJ@\u0010\r\u001a0\u0012,\u0012*\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0010*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00040\u00040\u000e0\n*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\n*\u00020\u0011\u00a8\u0006\u0015"}, d2={"Llogisticspipes/pipes/PipeFluidUtil;", "", "()V", "getTankUtilForTE", "Llogisticspipes/interfaces/ITankUtil;", "tile", "Lnet/minecraft/tileentity/TileEntity;", "dirOnEntity", "Lnet/minecraft/util/EnumFacing;", "fluidsToItemList", "", "Llogisticspipes/utils/item/ItemIdentifierStack;", "Llogisticspipes/pipes/PipeFluidSatellite;", "getAdjacentTanks", "Llogisticspipes/utils/tuples/Pair;", "Lnetwork/rs485/logisticspipes/connection/NeighborTileEntity;", "logisticspipes.kotlin.jvm.PlatformType", "Llogisticspipes/pipes/basic/fluid/FluidRoutedPipe;", "listNearbyPipes", "", "getAllTankTiles", "logisticspipes"})
public final class PipeFluidUtil {
    @NotNull
    public static final PipeFluidUtil INSTANCE = new PipeFluidUtil();

    private PipeFluidUtil() {
    }

    @Nullable
    public final ITankUtil getTankUtilForTE(@Nullable TileEntity tile, @Nullable EnumFacing dirOnEntity) {
        IFluidHandler fluidHandler;
        ISpecialTankHandler handler;
        if (SimpleServiceLocator.specialTankHandler.hasHandlerFor(tile) && (handler = SimpleServiceLocator.specialTankHandler.getTankHandlerFor(tile)) instanceof ISpecialTankAccessHandler) {
            IFluidHandler fluidHandler2;
            TileEntity tileEntity = tile;
            Intrinsics.checkNotNull(tileEntity);
            if (tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dirOnEntity) && (fluidHandler2 = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dirOnEntity)) != null) {
                return new SpecialTankUtil(fluidHandler2, tile, (ISpecialTankAccessHandler)handler);
            }
        }
        if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dirOnEntity) && (fluidHandler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dirOnEntity)) != null) {
            return new TankUtil(fluidHandler);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<NeighborTileEntity<TileEntity>, ITankUtil>> getAdjacentTanks(@NotNull FluidRoutedPipe $this$getAdjacentTanks, boolean listNearbyPipes) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getAdjacentTanks, "<this>");
        Iterable $this$filter$iv = $this$getAdjacentTanks.getAvailableAdjacent().fluidTanks();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NeighborTileEntity it = (NeighborTileEntity)element$iv$iv;
            boolean bl = false;
            if (!$this$getAdjacentTanks.isConnectableTank((TileEntity)it.getTileEntity(), it.getDirection(), listNearbyPipes)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Object object;
            block5: {
                block4: {
                    NeighborTileEntity adjacent = (NeighborTileEntity)element$iv$iv;
                    boolean bl = false;
                    object = LPNeighborTileEntityKt.getTankUtil(adjacent);
                    if (object == null) break block4;
                    ITankUtil it = object;
                    boolean bl2 = false;
                    List<Pair<NeighborTileEntity, ITankUtil>> list = CollectionsKt.listOf(new Pair<NeighborTileEntity, ITankUtil>(adjacent, it));
                    object = list;
                    if (list != null) break block5;
                }
                object = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = (Iterable)object;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TileEntity> getAllTankTiles(@NotNull FluidRoutedPipe $this$getAllTankTiles) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getAllTankTiles, "<this>");
        Iterable $this$flatMap$iv = this.getAdjacentTanks($this$getAllTankTiles, false);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            List<TileEntity> list = SimpleServiceLocator.specialTankHandler.getBaseTileFor((TileEntity)((NeighborTileEntity)pair.component1()).getTileEntity());
            Intrinsics.checkNotNullExpressionValue(list, "specialTankHandler.getBa\u2026.component1().tileEntity)");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ItemIdentifierStack> fluidsToItemList(@NotNull PipeFluidSatellite $this$fluidsToItemList) {
        void $this$mapNotNullTo$iv$iv;
        Iterator iterator2;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$fluidsToItemList, "<this>");
        Iterable $this$flatMap$iv = this.getAdjacentTanks($this$fluidsToItemList, false);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            iterator2 = (Pair)element$iv$iv;
            boolean bl = false;
            ITankUtil util = (ITankUtil)((Pair)((Object)iterator2)).component2();
            Stream<IFluidTankProperties> stream = util.tanks();
            Intrinsics.checkNotNullExpressionValue(stream, "util.tanks()");
            Iterable list$iv$iv = StreamsKt.toList(stream);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FluidIdentifierStack it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IFluidTankProperties tank = (IFluidTankProperties)element$iv$iv;
            boolean bl2 = false;
            if (FluidIdentifierStack.getFromStack(tank.getContents()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List fluidIdentStacks = (List)destination$iv$iv;
        HashSet<FluidIdentifier> distinctionSet = new HashSet<FluidIdentifier>();
        ArrayList<ItemIdentifierStack> outputList = new ArrayList<ItemIdentifierStack>();
        for (FluidIdentifierStack identStack : fluidIdentStacks) {
            Object v1;
            block5: {
                if (distinctionSet.add(identStack.getFluid())) {
                    outputList.add(identStack.getFluid().getItemIdentifier().makeStack(identStack.getAmount()));
                    continue;
                }
                Iterable iterable2 = outputList;
                for (Object t : iterable2) {
                    ItemIdentifierStack it = (ItemIdentifierStack)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getItem(), identStack.getFluid().getItemIdentifier())) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            Intrinsics.checkNotNull(v1);
            ItemIdentifierStack itemIdentifierStack = v1;
            itemIdentifierStack.setStackSize(itemIdentifierStack.getStackSize() + identStack.getAmount());
        }
        return outputList;
    }
}

