/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.ITankUtil;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.pipes.PipeFluidUtil;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestTree;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.PipeTransportLogistics;
import logisticspipes.utils.CacheHolder;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.FluidIdentifierStack;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import network.rs485.logisticspipes.connection.LPNeighborTileEntityKt;
import network.rs485.logisticspipes.connection.NeighborTileEntity;
import network.rs485.logisticspipes.inventory.IItemIdentifierInventory;

public class PipeItemsFluidSupplier
extends CoreRoutedPipe
implements IRequestItems,
IRequireReliableTransport {
    private boolean _lastRequestFailed = false;
    private boolean _requestPartials = false;
    private ItemIdentifierInventory dummyInventory = new ItemIdentifierInventory(9, "Fluids to keep stocked", 127);
    private final HashMap<ItemIdentifier, Integer> _requestedItems = new HashMap();

    public PipeItemsFluidSupplier(Item item) {
        super(new PipeTransportLogistics(true){

            @Override
            public boolean canPipeConnect(TileEntity tile, EnumFacing dir) {
                if (super.canPipeConnect(tile, dir)) {
                    return true;
                }
                if (SimpleServiceLocator.pipeInformationManager.isItemPipe(tile)) {
                    return false;
                }
                ITankUtil tank = PipeFluidUtil.INSTANCE.getTankUtilForTE(tile, dir.func_176734_d());
                return tank != null && tank.containsTanks();
            }
        }, item);
        this.throttleTime = 100;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUIDSUPPLIER_TEXTURE;
    }

    public boolean isRequestFailed() {
        return this._lastRequestFailed;
    }

    public void setRequestFailed(boolean value) {
        this._lastRequestFailed = value;
    }

    @Override
    @Nullable
    public LogisticsModule getLogisticsModule() {
        return null;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Fast;
    }

    public void endReached(LPTravelingItem.LPTravelingItemServer data, TileEntity tile) {
        ITankUtil util;
        this.getCacheHolder().trigger(CacheHolder.CacheTypes.Inventory);
        this.transport.markChunkModified(tile);
        this.notifyOfItemArival(data.getInfo());
        EnumFacing orientation = data.output.func_176734_d();
        if (this.getOriginalUpgradeManager().hasSneakyUpgrade()) {
            orientation = this.getOriginalUpgradeManager().getSneakyOrientation();
        }
        if ((util = PipeFluidUtil.INSTANCE.getTankUtilForTE(tile, orientation)) == null) {
            return;
        }
        if (SimpleServiceLocator.pipeInformationManager.isItemPipe(tile)) {
            return;
        }
        ItemIdentifierStack idStack = data.getItemIdentifierStack();
        if (idStack == null) {
            return;
        }
        FluidIdentifierStack liquidId = FluidIdentifierStack.getFromStack(FluidUtil.getFluidContained((ItemStack)idStack.makeNormalStack()));
        if (liquidId == null) {
            return;
        }
        while (idStack.getStackSize() > 0 && util.fill(liquidId, false) == liquidId.getAmount() && this.useEnergy(5)) {
            util.fill(liquidId, true);
            idStack.lowerStackSize(1);
            Item item = idStack.getItem().item;
            if (!item.hasContainerItem(idStack.makeNormalStack())) continue;
            Item containerItem = Objects.requireNonNull(item.func_77668_q());
            this.transport.sendItem(new ItemStack(containerItem, 1));
        }
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    public void throttledUpdateEntity() {
        if (!this.isEnabled()) {
            return;
        }
        if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
            return;
        }
        super.throttledUpdateEntity();
        block0: for (NeighborTileEntity<TileEntity> neighbor : this.getAdjacent().fluidTanks()) {
            ITankUtil tankUtil = LPNeighborTileEntityKt.getTankUtil(neighbor);
            if (tankUtil == null || !tankUtil.containsTanks()) continue;
            Map<ItemIdentifier, Integer> wantContainers = this.dummyInventory.getItemsAndCount();
            HashMap<FluidIdentifier, Integer> wantFluids = new HashMap<FluidIdentifier, Integer>();
            for (Map.Entry<ItemIdentifier, Integer> item : wantContainers.entrySet()) {
                ItemStack itemStack = item.getKey().unsafeMakeNormalStack(1);
                FluidStack liquidStack = FluidUtil.getFluidContained((ItemStack)itemStack);
                if (liquidStack == null) continue;
                wantFluids.put(FluidIdentifier.get(liquidStack), item.getValue() * liquidStack.amount);
            }
            HashMap haveFluids = new HashMap();
            tankUtil.tanks().map(tank -> FluidIdentifierStack.getFromStack(tank.getContents())).filter(Objects::nonNull).forEach(fluid -> {
                if (wantFluids.containsKey(fluid.getFluid())) {
                    haveFluids.merge(fluid.getFluid(), fluid.getAmount(), Integer::sum);
                }
            });
            for (Map.Entry entry : wantFluids.entrySet()) {
                Integer haveCount = (Integer)haveFluids.get(entry.getKey());
                if (haveCount == null) continue;
                entry.setValue((Integer)entry.getValue() - haveCount);
            }
            for (Map.Entry<Object, Object> entry : this._requestedItems.entrySet()) {
                FluidIdentifier requestedFluid;
                Integer want;
                ItemStack wantItem = ((ItemIdentifier)entry.getKey()).unsafeMakeNormalStack(1);
                FluidStack requestedFluidId = FluidUtil.getFluidContained((ItemStack)wantItem);
                if (requestedFluidId == null || (want = (Integer)wantFluids.get(requestedFluid = FluidIdentifier.get(requestedFluidId))) == null) continue;
                wantFluids.put(requestedFluid, want - (Integer)entry.getValue() * requestedFluidId.amount);
            }
            ((PipeItemsFluidSupplier)Objects.requireNonNull(this.container).pipe).setRequestFailed(false);
            for (ItemIdentifier itemIdentifier : wantContainers.keySet()) {
                int countToRequest;
                FluidStack requestedFluidId = FluidUtil.getFluidContained((ItemStack)itemIdentifier.unsafeMakeNormalStack(1));
                if (requestedFluidId == null || !wantFluids.containsKey(FluidIdentifier.get(requestedFluidId)) || (countToRequest = (Integer)wantFluids.get(FluidIdentifier.get(requestedFluidId)) / requestedFluidId.amount) < 1) continue;
                if (!this.useEnergy(11)) continue block0;
                boolean success = false;
                if (this._requestPartials) {
                    if ((countToRequest = RequestTree.requestPartial(itemIdentifier.makeStack(countToRequest), (IRequestItems)((Object)this.container.pipe), null)) > 0) {
                        success = true;
                    }
                } else {
                    success = RequestTree.request(itemIdentifier.makeStack(countToRequest), (IRequestItems)((Object)this.container.pipe), null, null);
                }
                if (success) {
                    Integer currentRequest = this._requestedItems.get(itemIdentifier);
                    if (currentRequest == null) {
                        this._requestedItems.put(itemIdentifier, countToRequest);
                        continue;
                    }
                    this._requestedItems.put(itemIdentifier, currentRequest + countToRequest);
                    continue;
                }
                ((PipeItemsFluidSupplier)this.container.pipe).setRequestFailed(true);
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.dummyInventory.readFromNBT(nbttagcompound, "");
        this._requestPartials = nbttagcompound.func_74767_n("requestpartials");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.dummyInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.func_74757_a("requestpartials", this._requestPartials);
    }

    private void decreaseRequested(ItemIdentifierStack item) {
        int remaining = item.getStackSize();
        Integer count2 = this._requestedItems.get(item.getItem());
        if (count2 != null) {
            this._requestedItems.put(item.getItem(), Math.max(0, count2 - remaining));
            remaining -= count2.intValue();
        }
        if (remaining <= 0) {
            return;
        }
        for (Map.Entry<ItemIdentifier, Integer> e : this._requestedItems.entrySet()) {
            if (e.getKey().item == item.getItem().item && e.getKey().itemDamage == item.getItem().itemDamage) {
                int expected = e.getValue();
                e.setValue(Math.max(0, expected - remaining));
                remaining -= expected;
            }
            if (remaining > 0) continue;
            return;
        }
        this.debug.log("liquid supplier got unexpected item " + item);
    }

    @Override
    public void itemLost(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        this.decreaseRequested(item);
    }

    @Override
    public void itemArrived(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        this.decreaseRequested(item);
        this.delayThrottle();
    }

    public boolean isRequestingPartials() {
        return this._requestPartials;
    }

    public void setRequestingPartials(boolean value) {
        this._requestPartials = value;
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        entityplayer.openGui((Object)LogisticsPipes.instance, 11, this.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    public IItemIdentifierInventory getDummyInventory() {
        return this.dummyInventory;
    }
}

