/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.LogisticsPipes;
import logisticspipes.gui.hud.HUDSatellite;
import logisticspipes.interfaces.IChestContentReceiver;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.modules.ModuleSatellite;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.hud.ChestContent;
import logisticspipes.network.packets.hud.HUDStartWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopWatchingPacket;
import logisticspipes.network.packets.satpipe.SyncSatelliteNamePacket;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.request.RequestTree;
import logisticspipes.textures.Textures;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.SatellitePipe;
import network.rs485.logisticspipes.connection.LPNeighborTileEntityKt;

public class PipeItemsSatelliteLogistics
extends CoreRoutedPipe
implements IRequestItems,
IRequireReliableTransport,
IHeadUpDisplayRendererProvider,
IChestContentReceiver,
SatellitePipe {
    public static final Set<PipeItemsSatelliteLogistics> AllSatellites = Collections.newSetFromMap(new WeakHashMap());
    public final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private final LinkedList<ItemIdentifierStack> itemList = new LinkedList();
    private final HUDSatellite HUD = new HUDSatellite(this);
    protected final LinkedList<ItemIdentifierStack> _lostItems = new LinkedList();
    private final ModuleSatellite moduleSatellite;
    private String satellitePipeName = "";

    public static void cleanup() {
        AllSatellites.clear();
    }

    public PipeItemsSatelliteLogistics(Item item) {
        super(item);
        this.throttleTime = 40;
        this.moduleSatellite = new ModuleSatellite();
        this.moduleSatellite.registerHandler(this, this);
        this.moduleSatellite.registerPosition(LogisticsModule.ModulePositionType.IN_PIPE, 0);
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_SATELLITE_TEXTURE;
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (this.isNthTick(20) && this.localModeWatchers.size() > 0) {
            this.updateInv(false);
        }
    }

    @Override
    @Nullable
    public LogisticsModule getLogisticsModule() {
        return this.moduleSatellite;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    private void addToList(ItemIdentifierStack stack) {
        for (ItemIdentifierStack ident : this.itemList) {
            if (!ident.getItem().equals(stack.getItem())) continue;
            ident.setStackSize(ident.getStackSize() + stack.getStackSize());
            return;
        }
        this.itemList.addLast(stack);
    }

    private void updateInv(boolean force) {
        ArrayList<ItemIdentifierStack> oldList = new ArrayList<ItemIdentifierStack>(this.itemList);
        this.itemList.clear();
        this.itemList.addAll(this.getAvailableAdjacent().inventories().stream().map(LPNeighborTileEntityKt::getInventoryUtil).filter(Objects::nonNull).flatMap(invUtil -> invUtil.getItemsAndCount().entrySet().stream().map(itemIdentifierAndCount -> new ItemIdentifierStack((ItemIdentifier)itemIdentifierAndCount.getKey(), (Integer)itemIdentifierAndCount.getValue()))).collect(Collectors.toList()));
        if (!oldList.equals(this.itemList) || force) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ChestContent.class).setIdentList(this.itemList).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), this.localModeWatchers);
        }
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            CoordinatesPacket packet = PacketHandler.getPacket(SyncSatelliteNamePacket.class).setString(this.satellitePipeName).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
            MainProxy.sendPacketToPlayer(packet, player);
            this.updateInv(true);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(EntityPlayer player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }

    @Override
    public void setReceivedChestContent(Collection<ItemIdentifierStack> list) {
        this.itemList.clear();
        this.itemList.addAll(list);
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("satelliteid")) {
            int satelliteId = nbttagcompound.func_74762_e("satelliteid");
            this.satellitePipeName = Integer.toString(satelliteId);
        } else {
            this.satellitePipeName = nbttagcompound.func_74779_i("satellitePipeName");
        }
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            this.ensureAllSatelliteStatus();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a("satellitePipeName", this.satellitePipeName);
        super.writeToNBT(nbttagcompound);
    }

    @Override
    public void ensureAllSatelliteStatus() {
        if (this.satellitePipeName.isEmpty()) {
            AllSatellites.remove(this);
        }
        if (!this.satellitePipeName.isEmpty()) {
            AllSatellites.add(this);
        }
    }

    @Override
    public void updateWatchers() {
        CoordinatesPacket packet = PacketHandler.getPacket(SyncSatelliteNamePacket.class).setString(this.satellitePipeName).setTilePos(this.getContainer());
        MainProxy.sendToPlayerList((ModernPacket)packet, this.localModeWatchers);
        MainProxy.sendPacketToAllWatchingChunk(this.getContainer(), (ModernPacket)packet);
    }

    @Override
    public void onAllowedRemoval() {
        if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
            return;
        }
        AllSatellites.remove(this);
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        CoordinatesPacket packet = PacketHandler.getPacket(SyncSatelliteNamePacket.class).setString(this.satellitePipeName).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
        MainProxy.sendPacketToPlayer(packet, entityplayer);
        entityplayer.openGui((Object)LogisticsPipes.instance, 13, this.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    @Override
    public void throttledUpdateEntity() {
        super.throttledUpdateEntity();
        if (this._lostItems.isEmpty()) {
            return;
        }
        Iterator iterator2 = this._lostItems.iterator();
        while (iterator2.hasNext()) {
            ItemIdentifierStack stack = (ItemIdentifierStack)iterator2.next();
            int received = RequestTree.requestPartial(stack, (CoreRoutedPipe)this.container.pipe, null);
            if (received <= 0) continue;
            if (received == stack.getStackSize()) {
                iterator2.remove();
                continue;
            }
            stack.setStackSize(stack.getStackSize() - received);
        }
    }

    @Override
    public void itemLost(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        this._lostItems.add(item);
    }

    @Override
    public void itemArrived(ItemIdentifierStack item, IAdditionalTargetInformation info) {
    }

    @Override
    @Nonnull
    public Set<SatellitePipe> getSatellitesOfType() {
        return Collections.unmodifiableSet(AllSatellites);
    }

    @Override
    public void setSatellitePipeName(@Nonnull String satellitePipeName) {
        this.satellitePipeName = satellitePipeName;
    }

    @Override
    @Nonnull
    public List<ItemIdentifierStack> getItemList() {
        return this.itemList;
    }

    @Override
    public String getSatellitePipeName() {
        return this.satellitePipeName;
    }
}

