/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.basic;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.api.ILPPipe;
import logisticspipes.config.Configs;
import logisticspipes.interfaces.IClientState;
import logisticspipes.interfaces.IPipeUpgradeManager;
import logisticspipes.pipes.basic.LogisticsBlockGenericPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.pipes.basic.debug.DebugLogController;
import logisticspipes.pipes.basic.debug.StatusEntry;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.computers.interfaces.ILPCCTypeHolder;
import logisticspipes.renderer.IIconProvider;
import logisticspipes.renderer.newpipe.IHighlightPlacementRenderer;
import logisticspipes.renderer.newpipe.ISpecialPipeRenderer;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.PipeTransportLogistics;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import network.rs485.logisticspipes.world.CoordinateUtils;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public abstract class CoreUnroutedPipe
implements IClientState,
ILPPipe,
ILPCCTypeHolder {
    private final Object[] ccTypeHolder = new Object[1];
    @Nullable
    public LogisticsTileGenericPipe container;
    public final PipeTransportLogistics transport;
    public final Item item;
    public DebugLogController debug = new DebugLogController(this);
    private boolean initialized = false;

    public CoreUnroutedPipe(PipeTransportLogistics transport, Item item) {
        this.transport = transport;
        this.item = item;
    }

    public void setTile(TileEntity tile) {
        this.container = (LogisticsTileGenericPipe)tile;
        this.transport.setTile((LogisticsTileGenericPipe)tile);
    }

    public boolean blockActivated(EntityPlayer entityplayer) {
        return false;
    }

    public void onBlockPlaced() {
        this.transport.onBlockPlaced();
    }

    public void onBlockPlacedBy(EntityLivingBase placer) {
    }

    public void onNeighborBlockChange() {
        this.transport.onNeighborBlockChange();
    }

    public boolean canPipeConnect(TileEntity tile, EnumFacing side) {
        CoreUnroutedPipe otherPipe;
        if (tile instanceof LogisticsTileGenericPipe && !LogisticsBlockGenericPipe.isFullyDefined(otherPipe = ((LogisticsTileGenericPipe)tile).pipe)) {
            return false;
        }
        return this.transport.canPipeConnect(tile, side);
    }

    public int getIconIndexForItem() {
        return this.getIconIndex(null);
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return Textures.LPpipeIconProvider;
    }

    public abstract int getIconIndex(EnumFacing var1);

    public void updateEntity() {
        this.transport.updateEntity();
    }

    public void writeToNBT(NBTTagCompound data) {
        this.transport.writeToNBT(data);
    }

    public void readFromNBT(NBTTagCompound data) {
        this.transport.readFromNBT(data);
    }

    public boolean needsInit() {
        return !this.initialized;
    }

    public void initialize() {
        this.transport.initialize();
        this.initialized = true;
    }

    public void onBlockRemoval() {
    }

    @Nullable
    public LogisticsTileGenericPipe getContainer() {
        return this.container;
    }

    public NonNullList<ItemStack> dropContents() {
        return this.transport.dropContents();
    }

    public void invalidate() {
    }

    public void validate() {
    }

    public void onChunkUnload() {
    }

    public World getWorld() {
        if (this.container == null) {
            return null;
        }
        return this.container.func_145831_w();
    }

    public boolean canPipeConnect(TileEntity tile, EnumFacing direction, boolean flag) {
        return this.canPipeConnect(tile, direction);
    }

    public boolean isSideBlocked(EnumFacing side, boolean ignoreSystemDisconnection) {
        return false;
    }

    public final int getX() {
        return this.getPos().func_177958_n();
    }

    public final int getY() {
        return this.getPos().func_177956_o();
    }

    public final int getZ() {
        return this.getPos().func_177952_p();
    }

    @Nonnull
    public final BlockPos getPos() {
        return this.container.func_174877_v();
    }

    public boolean canBeDestroyed() {
        return true;
    }

    public boolean destroyByPlayer() {
        return false;
    }

    public void setPreventRemove(boolean flag) {
    }

    public boolean preventRemove() {
        return false;
    }

    @Override
    public boolean isRoutedPipe() {
        return false;
    }

    public boolean isFluidPipe() {
        return false;
    }

    public abstract int getTextureIndex();

    public void triggerDebug() {
        if (this.debug.debugThisPipe) {
            System.out.print("");
        }
    }

    public void addStatusInformation(List<StatusEntry> status) {
    }

    public boolean isOpaque() {
        return Configs.OPAQUE;
    }

    public String toString() {
        if (this.container == null) {
            return this.getClass().getName() + "(NO CONTAINER)";
        }
        return String.format("%s(%s)", this.getClass().getName(), this.container.func_174877_v());
    }

    public DoubleCoordinates getLPPosition() {
        return new DoubleCoordinates(this);
    }

    public IPipeUpgradeManager getUpgradeManager() {
        return new IPipeUpgradeManager(){

            @Override
            public boolean hasPowerPassUpgrade() {
                return false;
            }

            @Override
            public boolean hasRFPowerSupplierUpgrade() {
                return false;
            }

            @Override
            public boolean hasBCPowerSupplierUpgrade() {
                return false;
            }

            @Override
            public int getIC2PowerLevel() {
                return 0;
            }

            @Override
            public int getSpeedUpgradeCount() {
                return 0;
            }

            @Override
            public boolean isSideDisconnected(EnumFacing side) {
                return false;
            }

            @Override
            public boolean hasCCRemoteControlUpgrade() {
                return false;
            }

            @Override
            public boolean hasCraftingMonitoringUpgrade() {
                return false;
            }

            @Override
            public boolean isOpaque() {
                return false;
            }

            @Override
            public boolean hasUpgradeModuleUpgrade() {
                return false;
            }

            @Override
            public boolean hasCombinedSneakyUpgrade() {
                return false;
            }

            @Override
            public EnumFacing[] getCombinedSneakyOrientation() {
                return null;
            }
        };
    }

    public double getDistanceTo(int destinationint, EnumFacing ignore, ItemIdentifier ident, boolean isActive, double travled, double max, List<DoubleCoordinates> visited) {
        double lowest = 2.147483647E9;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            DoubleCoordinates pos;
            IPipeInformationProvider information;
            if (ignore == dir || (information = SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(this.container.getNextConnectedTile(dir))) == null || visited.contains(pos = new DoubleCoordinates(information))) continue;
            visited.add(pos);
            lowest = information.getDistanceTo(destinationint, dir.func_176734_d(), ident, isActive, travled, Math.min(max, lowest), visited);
            visited.remove(pos);
        }
        return lowest;
    }

    public boolean isMultiBlock() {
        return false;
    }

    public boolean actAsNormalPipe() {
        return true;
    }

    public boolean isHSTube() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ISpecialPipeRenderer getSpecialRenderer() {
        return null;
    }

    public boolean hasSpecialPipeEndAt(EnumFacing dir) {
        return false;
    }

    public DoubleCoordinates getItemRenderPos(float fPos, LPTravelingItem travelItem) {
        DoubleCoordinates pos = new DoubleCoordinates(0.5, 0.5, 0.5);
        if ((double)fPos < 0.5) {
            if (travelItem.input == null) {
                return null;
            }
            if (!this.container.renderState.pipeConnectionMatrix.isConnected(travelItem.input.func_176734_d())) {
                return null;
            }
            CoordinateUtils.add(pos, travelItem.input.func_176734_d(), 0.5 - (double)fPos);
        } else {
            if (travelItem.output == null) {
                return null;
            }
            if (!this.container.renderState.pipeConnectionMatrix.isConnected(travelItem.output)) {
                return null;
            }
            CoordinateUtils.add(pos, travelItem.output, (double)fPos - 0.5);
        }
        return pos;
    }

    public double getBoxRenderScale(float fPos, LPTravelingItem travelItem) {
        double boxScale = 1.0;
        if (this.container.renderState.pipeConnectionMatrix.isTDConnected(travelItem.input.func_176734_d())) {
            boxScale = (double)fPos * 0.35 + 0.65;
        }
        if (this.container.renderState.pipeConnectionMatrix.isTDConnected(travelItem.output)) {
            boxScale = (double)(1.0f - fPos) * 0.35 + 0.65;
        }
        if (this.container.renderState.pipeConnectionMatrix.isTDConnected(travelItem.input.func_176734_d()) && this.container.renderState.pipeConnectionMatrix.isTDConnected(travelItem.output)) {
            boxScale = 0.65;
        }
        return boxScale;
    }

    public double getItemRenderPitch(float fPos, LPTravelingItem travelItem) {
        return 0.0;
    }

    public double getItemRenderYaw(float fPos, LPTravelingItem travelItem) {
        return 0.0;
    }

    public boolean isInitialized() {
        return this.container != null;
    }

    public abstract IHighlightPlacementRenderer getHighlightRenderer();

    public World getWorldForHUD() {
        return this.getWorld();
    }

    public boolean isMultipartAllowedInPipe() {
        return true;
    }

    @Override
    public Object[] getTypeHolder() {
        return this.ccTypeHolder;
    }

    protected void updateAdjacentCache() {
    }

    protected void triggerConnectionCheck() {
    }

    public void finishInit() {
    }

    public boolean isPipeBlock() {
        return false;
    }
}

