/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.basic;

import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.ILPPipe;
import logisticspipes.api.ILPPipeTile;
import logisticspipes.asm.ModDependentField;
import logisticspipes.asm.ModDependentInterface;
import logisticspipes.asm.ModDependentMethod;
import logisticspipes.blocks.LogisticsSolidTileEntity;
import logisticspipes.interfaces.IClientState;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.logic.LogicController;
import logisticspipes.logic.interfaces.ILogicControllerTile;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.block.PipeSolidSideCheck;
import logisticspipes.network.packets.pipe.PipeTileStatePacket;
import logisticspipes.pipes.PipeItemsFirewall;
import logisticspipes.pipes.basic.CoreMultiBlockPipe;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.ItemInsertionHandler;
import logisticspipes.pipes.basic.LogisticsBlockGenericPipe;
import logisticspipes.pipes.basic.ltgpmodcompat.LPDuctHolderTileEntity;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.buildcraft.subproxies.IBCPipeCapabilityProvider;
import logisticspipes.proxy.computers.wrapper.CCObjectWrapper;
import logisticspipes.proxy.opencomputers.IOCTile;
import logisticspipes.proxy.opencomputers.asm.BaseWrapperClass;
import logisticspipes.renderer.IIconProvider;
import logisticspipes.renderer.LogisticsTileRenderController;
import logisticspipes.renderer.state.PipeRenderState;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.PipeFluidTransportLogistics;
import logisticspipes.utils.LPPositionSet;
import logisticspipes.utils.OrientationsUtil;
import logisticspipes.utils.ReflectionHelper;
import logisticspipes.utils.StackTraceUtil;
import logisticspipes.utils.TileBuffer;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import network.rs485.logisticspipes.connection.ConnectionType;
import network.rs485.logisticspipes.connection.PipeInventoryConnectionChecker;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.world.DoubleCoordinates;
import network.rs485.logisticspipes.world.DoubleCoordinatesType;
import network.rs485.logisticspipes.world.WorldCoordinatesWrapper;
import org.apache.logging.log4j.Level;

@ModDependentInterface(modId={"cofhcore", "opencomputers", "opencomputers", "opencomputers"}, interfacePath={"cofh.api.transport.IItemDuct", "li.cil.oc.api.network.ManagedPeripheral", "li.cil.oc.api.network.Environment", "li.cil.oc.api.network.SidedEnvironment"})
public class LogisticsTileGenericPipe
extends LPDuctHolderTileEntity
implements ITickable,
IOCTile,
ILPPipeTile,
IPipeInformationProvider,
ManagedPeripheral,
Environment,
SidedEnvironment,
ILogicControllerTile {
    public static PipeInventoryConnectionChecker pipeInventoryConnectionChecker = new PipeInventoryConnectionChecker();
    public int statePacketId = 0;
    public final PipeRenderState renderState;
    public final CoreState coreState = new CoreState();
    public final IBCPipeCapabilityProvider bcCapProvider;
    public Object OPENPERIPHERAL_IGNORE;
    public Set<DoubleCoordinates> subMultiBlock = new HashSet<DoubleCoordinates>();
    public boolean[] turtleConnect = new boolean[7];
    @ModDependentField(modId="computercraft")
    public HashMap<IComputerAccess, EnumFacing> connections;
    @ModDependentField(modId="computercraft")
    public IComputerAccess currentPC;
    @ModDependentField(modId="opencomputers")
    public Node node;
    public LogicController logicController = new LogicController();
    public boolean[] pipeConnectionsBuffer = new boolean[6];
    public boolean[] pipeBCConnectionsBuffer = new boolean[6];
    public boolean[] pipeTDConnectionsBuffer = new boolean[6];
    public CoreUnroutedPipe pipe;
    private LogisticsTileRenderController renderController;
    private boolean addedToNetwork = false;
    private boolean sendInitPacket = true;
    private boolean initialized = false;
    private boolean deletePipe = false;
    private TileBuffer[] tileBuffer;
    private boolean sendClientUpdate = false;
    private boolean blockNeighborChange = false;
    private boolean refreshRenderState = false;
    private boolean pipeBound = false;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderBox;
    private EnumMap<EnumFacing, ItemInsertionHandler> itemInsertionHandlers;

    public LogisticsTileGenericPipe() {
        if (SimpleServiceLocator.ccProxy.isCC()) {
            this.connections = new HashMap();
        }
        SimpleServiceLocator.openComputersProxy.initLogisticsTileGenericPipe(this);
        this.tdPart = SimpleServiceLocator.thermalDynamicsProxy.getTDPart(this);
        this.bcCapProvider = SimpleServiceLocator.buildCraftProxy.getIBCPipeCapabilityProvider(this);
        this.imcmpltgpCompanion = SimpleServiceLocator.mcmpProxy.createMCMPCompanionFor(this);
        this.itemInsertionHandlers = new EnumMap(EnumFacing.class);
        Arrays.stream(EnumFacing.values()).forEach(face -> this.itemInsertionHandlers.put((EnumFacing)face, new ItemInsertionHandler(this, (EnumFacing)face)));
        ItemInsertionHandler itemInsertionHandlerNull = new ItemInsertionHandler(this, null);
        this.renderState = new PipeRenderState();
    }

    @Override
    public void func_145843_s() {
        if (this.pipe == null) {
            this.field_145846_f = true;
            this.initialized = false;
            this.tileBuffer = null;
            super.func_145843_s();
        } else if (!this.pipe.preventRemove()) {
            this.field_145846_f = true;
            this.initialized = false;
            this.tileBuffer = null;
            this.pipe.invalidate();
            super.func_145843_s();
            SimpleServiceLocator.openComputersProxy.handleInvalidate(this);
            this.tdPart.invalidate();
        }
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.initialized = false;
        this.tileBuffer = null;
        this.bindPipe();
        if (this.pipe != null) {
            this.pipe.validate();
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.pipe != null) {
            this.pipe.onChunkUnload();
        }
        SimpleServiceLocator.openComputersProxy.handleChunkUnload(this);
        this.tdPart.onChunkUnload();
    }

    public void func_73660_a() {
        this.imcmpltgpCompanion.update();
        StackTraceUtil.Info superDebug = StackTraceUtil.addSuperTraceInformation(() -> "Time: " + this.func_145831_w().func_72820_D(), new StackTraceUtil.Info[0]);
        StackTraceUtil.Info debug = StackTraceUtil.addTraceInformation(() -> "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ")", superDebug);
        if (this.sendInitPacket && MainProxy.isServer((IBlockAccess)this.func_145831_w())) {
            this.sendInitPacket = false;
            this.getRenderController().sendInit();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.deletePipe) {
                this.field_145850_b.func_175698_g(this.func_174877_v());
            }
            if (this.pipe == null) {
                debug.end();
                return;
            }
            if (!this.initialized) {
                this.initialize(this.pipe);
            }
        }
        if (!LogisticsBlockGenericPipe.isValid(this.pipe)) {
            debug.end();
            return;
        }
        this.pipe.updateEntity();
        if (this.field_145850_b.field_72995_K) {
            debug.end();
            return;
        }
        if (this.blockNeighborChange) {
            this.computeConnections();
            this.pipe.onNeighborBlockChange();
            this.blockNeighborChange = false;
            this.refreshRenderState = true;
            if (MainProxy.isServer((IBlockAccess)this.field_145850_b)) {
                MainProxy.sendPacketToAllWatchingChunk(this, (ModernPacket)PacketHandler.getPacket(PipeSolidSideCheck.class).setTilePos(this));
            }
        }
        if (this.refreshRenderState) {
            this.refreshRenderState();
            if (this.renderState.isDirty()) {
                this.renderState.clean();
                this.sendUpdateToClient();
            }
            this.refreshRenderState = false;
        }
        if (this.sendClientUpdate) {
            this.sendClientUpdate = false;
            MainProxy.sendPacketToAllWatchingChunk(this, this.getLPDescriptionPacket());
        }
        this.getRenderController().onUpdate();
        if (!this.addedToNetwork) {
            this.addedToNetwork = true;
            SimpleServiceLocator.openComputersProxy.addToNetwork(this);
        }
        debug.end();
    }

    private void refreshRenderState() {
        for (EnumFacing o : EnumFacing.field_82609_l) {
            this.renderState.pipeConnectionMatrix.setConnected(o, this.pipeConnectionsBuffer[o.ordinal()]);
            this.renderState.pipeConnectionMatrix.setBCConnected(o, this.pipeBCConnectionsBuffer[o.ordinal()]);
            this.renderState.pipeConnectionMatrix.setTDConnected(o, this.pipeTDConnectionsBuffer[o.ordinal()]);
        }
        for (int i = 0; i < 7; ++i) {
            EnumFacing o = EnumFacing.func_82600_a((int)i);
            this.renderState.textureMatrix.setIconIndex(o, this.pipe.getIconIndex(o));
        }
        this.renderState.textureMatrix.refreshStates(this.pipe);
    }

    @Override
    public boolean isMultipartAllowedInPipe() {
        return !this.isMultiBlock() && (this.pipe == null || this.pipe.isMultipartAllowedInPipe());
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189517_E_() {
        this.sendInitPacket = true;
        NBTTagCompound nbt = super.func_189517_E_();
        try {
            PacketHandler.addPacketToNBT(this.getLPDescriptionPacket(), nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nbt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        PacketHandler.queueAndRemovePacketFromNBT(tag);
        super.handleUpdateTag(tag);
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        SPacketUpdateTileEntity superPacket = super.func_189518_D_();
        if (superPacket != null) {
            nbt.func_74782_a("LogisticsPipes:SuperUpdatePacket", (NBTBase)ReflectionHelper.getPrivateField(SPacketUpdateTileEntity.class, superPacket, "nbt", "field_148860_e"));
        }
        try {
            PacketHandler.addPacketToNBT(this.getLPDescriptionPacket(), nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbt);
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        PacketHandler.queueAndRemovePacketFromNBT(packet.func_148857_g());
        if (packet.func_148857_g().func_74764_b("LogisticsPipes:SuperUpdatePacket")) {
            super.onDataPacket(net, new SPacketUpdateTileEntity(this.func_174877_v(), 0, packet.func_148857_g().func_74775_l("LogisticsPipes:SuperUpdatePacket")));
        }
    }

    public void func_145828_a(@Nonnull CrashReportCategory reportCategory) {
        block8: {
            try {
                super.func_145828_a(reportCategory);
            }
            catch (Exception e) {
                if (!LogisticsPipes.isDEBUG()) break block8;
                e.printStackTrace();
            }
        }
        reportCategory.func_71507_a("LP-Version", (Object)LogisticsPipes.getVersionString());
        if (this.pipe != null) {
            reportCategory.func_71507_a("Pipe", (Object)this.pipe.getClass().getCanonicalName());
            if (this.pipe.transport != null) {
                reportCategory.func_71507_a("Transport", (Object)this.pipe.transport.getClass().getCanonicalName());
            } else {
                reportCategory.func_71507_a("Transport", (Object)"null");
            }
            if (this.pipe instanceof CoreRoutedPipe) {
                try {
                    ((CoreRoutedPipe)this.pipe).addCrashReport(reportCategory);
                }
                catch (Exception e) {
                    reportCategory.func_71499_a("Internal LogisticsPipes Error", (Throwable)e);
                }
            }
        }
    }

    public void scheduleNeighborChange() {
        this.tdPart.scheduleNeighborChange();
        if (MainProxy.isServer((IBlockAccess)this.field_145850_b)) {
            this.pipe.triggerConnectionCheck();
        }
        this.blockNeighborChange = true;
        boolean[] connected = new boolean[6];
        new WorldCoordinatesWrapper(this).allNeighborTileEntities().stream().filter(adjacent -> SimpleServiceLocator.ccProxy.isTurtle((TileEntity)adjacent.getTileEntity())).forEach(adjacent -> {
            connected[adjacent.getDirection().ordinal()] = true;
        });
        for (int i = 0; i < 6; ++i) {
            if (connected[i]) continue;
            this.turtleConnect[i] = false;
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        if (this.pipe != null) {
            nbt.func_74768_a("pipeId", Item.field_150901_e.func_148757_b((Object)this.pipe.item));
            this.pipe.writeToNBT(nbt);
        } else {
            nbt.func_74768_a("pipeId", this.coreState.pipeId);
        }
        for (int i = 0; i < this.turtleConnect.length; ++i) {
            nbt.func_74757_a("turtleConnect_" + i, this.turtleConnect[i]);
        }
        SimpleServiceLocator.openComputersProxy.handleWriteToNBT(this, nbt);
        NBTTagCompound logicNBT = new NBTTagCompound();
        this.logicController.writeToNBT(logicNBT);
        nbt.func_74782_a("logicController", (NBTBase)logicNBT);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        StackTraceElement[] trace;
        if (this.pipe != null && (trace = Thread.currentThread().getStackTrace()).length > 2 && trace[2].getMethodName().equals("handle") && trace[2].getClassName().equals("com.xcompwiz.lookingglass.network.packet.PacketTileEntityNBT")) {
            System.out.println("Prevented false data injection by LookingGlass");
            return;
        }
        super.func_145839_a(nbt);
        if (!nbt.func_74764_b("pipeId") && MainProxy.isClient((IBlockAccess)this.field_145850_b)) {
            return;
        }
        this.coreState.pipeId = nbt.func_74762_e("pipeId");
        this.pipe = LogisticsBlockGenericPipe.createPipe(Item.func_150899_d((int)this.coreState.pipeId));
        this.bindPipe();
        if (this.pipe != null) {
            this.pipe.readFromNBT(nbt);
            this.pipe.finishInit();
        } else {
            LogisticsPipes.log.log(Level.WARN, "Pipe failed to load from NBT at " + this.func_174877_v());
            this.deletePipe = true;
        }
        for (int i = 0; i < this.turtleConnect.length; ++i) {
            this.turtleConnect[i] = nbt.func_74767_n("turtleConnect_" + i);
        }
        SimpleServiceLocator.openComputersProxy.handleReadFromNBT(this, nbt);
        this.logicController.readFromNBT(nbt.func_74775_l("logicController"));
    }

    public boolean canPipeConnect(TileEntity with, EnumFacing side) {
        if (MainProxy.isClient((IBlockAccess)this.field_145850_b)) {
            return false;
        }
        if (with == null) {
            return false;
        }
        if (!LogisticsBlockGenericPipe.isValid(this.pipe)) {
            return false;
        }
        EnumFacing neighborOrientation = OrientationsUtil.getOrientationOfTilewithTile(this, with);
        if (SimpleServiceLocator.ccProxy.isTurtle(with) && (neighborOrientation == null || !this.turtleConnect[neighborOrientation.ordinal()])) {
            return false;
        }
        AxisAlignedBB aabb = LogisticsBlockGenericPipe.PIPE_CONN_BB.get(side.func_176745_a());
        if (SimpleServiceLocator.mcmpProxy.checkIntersectionWith(this, aabb)) {
            return false;
        }
        if (SimpleServiceLocator.thermalDynamicsProxy.isBlockedSide(with, side.func_176734_d())) {
            return false;
        }
        if (with instanceof LogisticsTileGenericPipe) {
            CoreUnroutedPipe otherPipe = ((LogisticsTileGenericPipe)with).pipe;
            if (!LogisticsBlockGenericPipe.isValid(otherPipe)) {
                return false;
            }
            if (!otherPipe.canPipeConnect(this, side.func_176734_d())) {
                return false;
            }
            AxisAlignedBB aabbB = LogisticsBlockGenericPipe.PIPE_CONN_BB.get(side.func_176734_d().func_176745_a());
            if (SimpleServiceLocator.mcmpProxy.checkIntersectionWith((LogisticsTileGenericPipe)with, aabbB)) {
                return false;
            }
        }
        return this.pipe.canPipeConnect(with, side);
    }

    public void queueEvent(String event, Object[] arguments) {
        SimpleServiceLocator.ccProxy.queueEvent(event, arguments, this);
    }

    public void handleMesssage(int computerId, Object message, int sourceId) {
        SimpleServiceLocator.ccProxy.handleMesssage(computerId, message, this, sourceId);
    }

    public boolean getTurtleConnect() {
        return SimpleServiceLocator.ccProxy.getTurtleConnect(this);
    }

    public void setTurtleConnect(boolean flag) {
        SimpleServiceLocator.ccProxy.setTurtleConnect(flag, this);
    }

    public int getLastCCID() {
        return SimpleServiceLocator.ccProxy.getLastCCID(this);
    }

    @Nonnull
    public ItemStack insertItem(EnumFacing from, @Nonnull ItemStack stack) {
        int used = this.injectItem(stack, true, from);
        if (used == stack.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        stack = stack.func_77946_l();
        stack.func_190918_g(used);
        return stack;
    }

    public void addLaser(EnumFacing dir, float length, int color, boolean reverse, boolean renderBall) {
        this.getRenderController().addLaser(dir, length, color, reverse, renderBall);
    }

    public void removeLaser(EnumFacing dir, int color, boolean isBall) {
        this.getRenderController().removeLaser(dir, color, isBall);
    }

    public LogisticsTileRenderController getRenderController() {
        if (this.renderController == null) {
            this.renderController = new LogisticsTileRenderController(this);
        }
        return this.renderController;
    }

    @Override
    public boolean isCorrect(ConnectionType type) {
        return true;
    }

    @Override
    public int getX() {
        return this.func_174877_v().func_177958_n();
    }

    @Override
    public int getY() {
        return this.func_174877_v().func_177956_o();
    }

    @Override
    public int getZ() {
        return this.func_174877_v().func_177952_p();
    }

    @Override
    public boolean isRouterInitialized() {
        return this.isInitialized() && (!this.isRoutingPipe() || !this.getRoutingPipe().stillNeedReplace());
    }

    @Override
    public boolean isRoutingPipe() {
        return this.pipe instanceof CoreRoutedPipe;
    }

    @Override
    public CoreRoutedPipe getRoutingPipe() {
        if (this.pipe instanceof CoreRoutedPipe) {
            return (CoreRoutedPipe)this.pipe;
        }
        throw new RuntimeException("This is no routing pipe");
    }

    @Override
    public boolean isFirewallPipe() {
        return this.pipe instanceof PipeItemsFirewall;
    }

    @Override
    public IFilter getFirewallFilter() {
        if (this.pipe instanceof PipeItemsFirewall) {
            return ((PipeItemsFirewall)this.pipe).getFilter();
        }
        throw new RuntimeException("This is no firewall pipe");
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    @Override
    public boolean divideNetwork() {
        return false;
    }

    @Override
    public boolean powerOnly() {
        return false;
    }

    @Override
    public boolean isOnewayPipe() {
        return false;
    }

    @Override
    public boolean isOutputClosed(EnumFacing direction) {
        return false;
    }

    @Override
    public boolean isItemPipe() {
        return true;
    }

    @Override
    public boolean isFluidPipe() {
        return this.pipe != null && this.pipe.isFluidPipe();
    }

    @Override
    public boolean isPowerPipe() {
        return false;
    }

    @Override
    public boolean canConnect(TileEntity to, EnumFacing direction, boolean flag) {
        AxisAlignedBB aabb;
        if (this.pipe == null) {
            return false;
        }
        if (direction != null && SimpleServiceLocator.mcmpProxy.checkIntersectionWith(this, aabb = LogisticsBlockGenericPipe.PIPE_CONN_BB.get(direction.func_176745_a()))) {
            return false;
        }
        return this.pipe.canPipeConnect(to, direction, flag);
    }

    @Override
    public double getDistance() {
        if (this.pipe != null && this.pipe.transport != null) {
            return this.pipe.transport.getPipeLength();
        }
        return 1.0;
    }

    @Override
    public double getDistanceWeight() {
        if (this.pipe != null && this.pipe.transport != null) {
            return this.pipe.transport.getDistanceWeight();
        }
        return 1.0;
    }

    public int injectItem(@Nonnull ItemStack payload, boolean doAdd, EnumFacing from) {
        if (LogisticsBlockGenericPipe.isValid(this.pipe) && this.pipe.transport != null && this.isPipeConnectedCached(from) && doAdd && MainProxy.isServer((IBlockAccess)this.func_145831_w())) {
            int lastIterLeft;
            ItemStack leftStack = payload.func_77946_l();
            do {
                lastIterLeft = leftStack.func_190916_E();
                LPTravelingItem.LPTravelingItemServer travelingItem = SimpleServiceLocator.routedItemHelper.createNewTravelItem(leftStack);
                leftStack.func_190920_e(this.pipe.transport.injectItem(travelingItem, from.func_176734_d()));
            } while (leftStack.func_190916_E() != lastIterLeft && leftStack.func_190916_E() != 0);
            return payload.func_190916_E() - leftStack.func_190916_E();
        }
        return 0;
    }

    public boolean isPipeConnectedCached(EnumFacing side) {
        if (MainProxy.isClient((IBlockAccess)this.field_145850_b)) {
            return this.renderState.pipeConnectionMatrix.isConnected(side);
        }
        return this.pipeConnectionsBuffer[side.ordinal()];
    }

    public boolean isOpaque() {
        return this.pipe.isOpaque();
    }

    @ModDependentMethod(modId="opencomputers")
    public Node node() {
        return this.node;
    }

    @ModDependentMethod(modId="opencomputers")
    public void onConnect(Node node1) {
    }

    @ModDependentMethod(modId="opencomputers")
    public void onDisconnect(Node node1) {
    }

    @ModDependentMethod(modId="opencomputers")
    public void onMessage(Message message) {
    }

    @ModDependentMethod(modId="opencomputers")
    public Object[] invoke(String s, Context context, Arguments arguments) {
        BaseWrapperClass object = (BaseWrapperClass)((Object)Objects.requireNonNull(CCObjectWrapper.getWrappedObject(this.pipe, BaseWrapperClass.WRAPPER), "wrapped object returned null in " + this.toString()));
        object.isDirectCall = true;
        return CCObjectWrapper.createArray((Object)object);
    }

    @ModDependentMethod(modId="opencomputers")
    public String[] methods() {
        return new String[]{"getPipe"};
    }

    @ModDependentMethod(modId="opencomputers")
    public Node sidedNode(EnumFacing side) {
        if (this.getTile(side) instanceof LogisticsTileGenericPipe || this.getTile(side) instanceof LogisticsSolidTileEntity) {
            return null;
        }
        return this.node();
    }

    @SideOnly(value=Side.CLIENT)
    @ModDependentMethod(modId="opencomputers")
    public boolean canConnect(EnumFacing side) {
        return !(this.getTile(side) instanceof LogisticsTileGenericPipe) && !(this.getTile(side) instanceof LogisticsSolidTileEntity);
    }

    @Override
    public Object getOCNode() {
        return this.node;
    }

    public void initialize(CoreUnroutedPipe pipe) {
        this.field_145854_h = this.func_145838_q();
        if (pipe == null) {
            LogisticsPipes.log.warn("Pipe failed to initialize at " + this.func_174877_v().toString() + ", deleting");
            this.field_145850_b.func_175698_g(this.func_174877_v());
            return;
        }
        this.pipe = pipe;
        this.bindPipe();
        this.computeConnections();
        this.scheduleRenderUpdate();
        if (pipe.needsInit()) {
            pipe.initialize();
        }
        this.initialized = true;
    }

    private void bindPipe() {
        if (!this.pipeBound && this.pipe != null) {
            this.pipe.setTile(this);
            this.coreState.pipeId = Item.func_150891_b((Item)this.pipe.item);
            this.pipeBound = true;
        }
    }

    public ModernPacket getLPDescriptionPacket() {
        this.bindPipe();
        PipeTileStatePacket packet = PacketHandler.getPacket(PipeTileStatePacket.class);
        packet.setTilePos(this);
        packet.setCoreState(this.coreState);
        packet.setRenderState(this.renderState);
        packet.setPipe(this.pipe);
        packet.setStatePacketId(this.statePacketId++);
        return packet;
    }

    public void afterStateUpdated() {
        if (this.pipe == null && this.coreState.pipeId != 0) {
            this.initialize(LogisticsBlockGenericPipe.createPipe((Item)Item.field_150901_e.func_148754_a(this.coreState.pipeId)));
        }
        if (this.pipe == null) {
            return;
        }
        this.field_145850_b.func_147458_c(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        if (this.renderState.needsRenderUpdate()) {
            this.field_145850_b.func_147458_c(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            this.renderState.clean();
        }
    }

    public void sendUpdateToClient() {
        this.sendClientUpdate = true;
    }

    public TileBuffer[] getTileCache() {
        if (this.tileBuffer == null && this.pipe != null) {
            this.tileBuffer = TileBuffer.makeBuffer(this.field_145850_b, this.field_174879_c, this.pipe.transport.delveIntoUnloadedChunks());
        }
        return this.tileBuffer;
    }

    public void blockCreated(EnumFacing from, Block block, TileEntity tile) {
        TileBuffer[] cache2 = this.getTileCache();
        if (cache2 != null) {
            cache2[from.func_176734_d().ordinal()].set(block, tile);
        }
    }

    @Override
    public TileEntity getNextConnectedTile(EnumFacing to) {
        if (this.pipe.isMultiBlock()) {
            return ((CoreMultiBlockPipe)this.pipe).getConnectedEndTile(to);
        }
        return this.getTile(to, false);
    }

    public TileEntity getTile(EnumFacing to) {
        return this.getTile(to, false);
    }

    public TileEntity getTile(EnumFacing to, boolean force) {
        TileBuffer[] cache2 = this.getTileCache();
        if (cache2 != null) {
            if (force) {
                cache2[to.ordinal()].refresh();
            }
            return cache2[to.ordinal()].getTile();
        }
        return null;
    }

    public Block getBlock(EnumFacing to) {
        TileBuffer[] cache2 = this.getTileCache();
        if (cache2 != null) {
            return cache2[to.ordinal()].getBlock();
        }
        return null;
    }

    private void computeConnections() {
        TileBuffer[] cache2 = this.getTileCache();
        if (cache2 == null) {
            return;
        }
        boolean[] pipeTDConnectionsBufferOld = (boolean[])this.pipeTDConnectionsBuffer.clone();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            TileBuffer t = cache2[side.ordinal()];
            t.refresh();
            this.pipeConnectionsBuffer[side.ordinal()] = this.canPipeConnect(t.getTile(), side);
            if (this.pipeConnectionsBuffer[side.ordinal()]) {
                this.pipeBCConnectionsBuffer[side.ordinal()] = SimpleServiceLocator.buildCraftProxy.isBuildCraftPipe(t.getTile());
                this.pipeTDConnectionsBuffer[side.ordinal()] = SimpleServiceLocator.thermalDynamicsProxy.isItemDuct(t.getTile());
                continue;
            }
            this.pipeBCConnectionsBuffer[side.ordinal()] = false;
            this.pipeTDConnectionsBuffer[side.ordinal()] = false;
        }
        if (!Arrays.equals(pipeTDConnectionsBufferOld, this.pipeTDConnectionsBuffer)) {
            this.tdPart.connectionsChanged();
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == LogisticsPipes.FLUID_HANDLER_CAPABILITY && LogisticsBlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof PipeFluidTransportLogistics && facing != null && ((PipeFluidTransportLogistics)this.pipe.transport).getIFluidHandler(facing) != null) {
            return true;
        }
        if (capability == LogisticsPipes.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return false;
            }
            TileEntity tile = this.getTile(facing);
            if (tile != null && pipeInventoryConnectionChecker.shouldLPProvideInventoryTo(tile)) {
                return true;
            }
        }
        if (this.bcCapProvider.hasCapability(capability, facing)) {
            return true;
        }
        if (this.imcmpltgpCompanion.hasCapability(capability, facing)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == LogisticsPipes.FLUID_HANDLER_CAPABILITY && LogisticsBlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof PipeFluidTransportLogistics && facing != null) {
            return (T)((PipeFluidTransportLogistics)this.pipe.transport).getIFluidHandler(facing);
        }
        if (capability == LogisticsPipes.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return null;
            }
            TileEntity tile = this.getTile(facing);
            if (tile != null && pipeInventoryConnectionChecker.shouldLPProvideInventoryTo(tile)) {
                return (T)this.itemInsertionHandlers.get(facing);
            }
        }
        if (this.bcCapProvider.hasCapability(capability, facing)) {
            return (T)this.bcCapProvider.getCapability(capability, facing);
        }
        if (this.imcmpltgpCompanion.hasCapability(capability, facing)) {
            return this.imcmpltgpCompanion.getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void scheduleRenderUpdate() {
        this.refreshRenderState = true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getPipeIcons() {
        if (this.pipe == null) {
            return null;
        }
        return this.pipe.getIconProvider();
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public Block getBlock() {
        return this.func_145838_q();
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this;
    }

    public boolean func_145837_r() {
        if (this.pipe != null && this.pipe.preventRemove()) {
            return false;
        }
        return super.func_145837_r();
    }

    @Override
    public LogicController getLogicController() {
        return this.logicController;
    }

    @Override
    public ILPPipe getLPPipe() {
        return this.pipe;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.func_174877_v();
    }

    @Override
    public void func_145834_a(@Nonnull World world) {
        super.func_145834_a(world);
        this.tdPart.setWorld_LP(world);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBox != null) {
            return this.renderBox;
        }
        if (this.pipe == null) {
            return new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 1, 1));
        }
        if (!this.pipe.isMultiBlock()) {
            this.renderBox = new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 1, 1));
        } else {
            LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> set = ((CoreMultiBlockPipe)this.pipe).getRotatedSubBlocks();
            set.addToAll(this.pipe.getLPPosition());
            set.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(this.func_174877_v(), CoreMultiBlockPipe.SubBlockTypeForShare.NON_SHARE));
            set.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(this.func_174877_v().func_177958_n() + 1, this.func_174877_v().func_177956_o() + 1, this.func_174877_v().func_177952_p() + 1, CoreMultiBlockPipe.SubBlockTypeForShare.NON_SHARE));
            this.renderBox = new AxisAlignedBB(set.getMinXD() - 1.0, set.getMinYD() - 1.0, set.getMinZD() - 1.0, set.getMaxXD() + 1.0, set.getMaxYD() + 1.0, set.getMaxZD() + 1.0);
        }
        return this.renderBox;
    }

    @Override
    public double getDistanceTo(int destinationint, EnumFacing ignore, ItemIdentifier ident, boolean isActive, double traveled, double max, List<DoubleCoordinates> visited) {
        if (this.pipe == null || traveled > max) {
            return 2.147483647E9;
        }
        double result2 = this.pipe.getDistanceTo(destinationint, ignore, ident, isActive, traveled + this.getDistance(), max, visited);
        if (result2 == 2.147483647E9) {
            return result2;
        }
        return result2 + (double)((int)this.getDistance());
    }

    @Override
    public boolean acceptItem(LPTravelingItem item, TileEntity from) {
        if (LogisticsBlockGenericPipe.isValid(this.pipe) && this.pipe.transport != null) {
            this.pipe.transport.injectItem(item, item.output);
            return true;
        }
        return false;
    }

    @Override
    public void refreshTileCacheOnSide(EnumFacing side) {
        TileBuffer[] cache2 = this.getTileCache();
        if (cache2 != null) {
            cache2[side.ordinal()].refresh();
        }
    }

    public boolean nonNull() {
        return Objects.nonNull(this.pipe);
    }

    @Override
    public boolean isMultiBlock() {
        return this.nonNull() && this.pipe.isMultiBlock();
    }

    public boolean isPipeBlock() {
        return this.nonNull() && this.pipe.isPipeBlock();
    }

    @Override
    public Stream<TileEntity> getPartsOfPipe() {
        return this.subMultiBlock.stream().map(pos -> pos.getTileEntity((IBlockAccess)this.field_145850_b));
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public static class CoreState
    implements IClientState {
        public int pipeId = -1;

        @Override
        public void writeData(LPDataOutput output) {
            output.writeInt(this.pipeId);
        }

        @Override
        public void readData(LPDataInput input) {
            this.pipeId = input.readInt();
        }
    }
}

