/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.tubes;

import java.util.List;
import logisticspipes.interfaces.ITubeOrientation;
import logisticspipes.interfaces.ITubeRenderOrientation;
import logisticspipes.pipes.basic.CoreMultiBlockPipe;
import logisticspipes.renderer.newpipe.IHighlightPlacementRenderer;
import logisticspipes.renderer.newpipe.ISpecialPipeRenderer;
import logisticspipes.renderer.newpipe.tube.LineTubeRenderer;
import logisticspipes.transport.PipeMultiBlockTransportLogistics;
import logisticspipes.utils.IPositionRotateble;
import logisticspipes.utils.LPPositionSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.world.DoubleCoordinates;
import network.rs485.logisticspipes.world.DoubleCoordinatesType;

public class HSTubeLine
extends CoreMultiBlockPipe {
    private TubeLineOrientation orientation;

    public HSTubeLine(Item item) {
        super(new PipeMultiBlockTransportLogistics(), item);
    }

    @Override
    public void writeData(LPDataOutput output) {
        if (this.orientation == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            output.writeEnum(this.orientation);
        }
    }

    @Override
    public void readData(LPDataInput input) {
        if (input.readBoolean()) {
            this.orientation = input.readEnum(TubeLineOrientation.class);
        }
    }

    @Override
    public LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> getSubBlocks() {
        return new LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>>(DoubleCoordinatesType.class);
    }

    @Override
    public LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> getRotatedSubBlocks() {
        LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> set = this.getSubBlocks();
        this.orientation.rotatePositions(set);
        return set;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74778_a("orientation", this.orientation.name());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.orientation = TubeLineOrientation.valueOf(data.func_74779_i("orientation"));
    }

    @Override
    public void addCollisionBoxesToList(List<AxisAlignedBB> arraylist, AxisAlignedBB axisalignedbb) {
        DoubleCoordinates pos = this.getLPPosition();
        LPPositionSet<DoubleCoordinates> set = new LPPositionSet<DoubleCoordinates>(DoubleCoordinates.class);
        set.addFrom(LineTubeRenderer.tubeLine.get(this.orientation.getRenderOrientation()).bounds().toAABB());
        set.forEach(o -> o.add(pos));
        AxisAlignedBB box = set.toABB();
        if (box != null && (axisalignedbb == null || axisalignedbb.func_72326_a(box))) {
            arraylist.add(box);
        }
    }

    @Override
    public AxisAlignedBB getCompleteBox() {
        return LineTubeRenderer.tubeLine.get(this.orientation.getRenderOrientation()).bounds().toAABB();
    }

    @Override
    public ITubeOrientation getTubeOrientation(EntityPlayer player, int xPos, int zPos) {
        double x = (double)xPos + 0.5 - player.field_70165_t;
        double z = (double)zPos + 0.5 - player.field_70161_v;
        double w = Math.atan2(x, z);
        double halfPI = 1.5707963267948966;
        double halfhalfPI = halfPI / 2.0;
        if ((w -= halfhalfPI) < 0.0) {
            w += Math.PI * 2;
        }
        EnumFacing dir = null;
        if (0.0 < w && w <= halfPI) {
            dir = EnumFacing.WEST;
        } else if (halfPI < w && w <= 2.0 * halfPI) {
            dir = EnumFacing.SOUTH;
        } else if (2.0 * halfPI < w && w <= 3.0 * halfPI) {
            dir = EnumFacing.EAST;
        } else if (3.0 * halfPI < w && w <= 4.0 * halfPI) {
            dir = EnumFacing.NORTH;
        }
        for (TubeLineOrientation ori : TubeLineOrientation.values()) {
            if (!ori.dir.equals((Object)dir)) continue;
            return ori;
        }
        return null;
    }

    @Override
    public float getPipeLength() {
        return 1.0f;
    }

    @Override
    public EnumFacing getExitForInput(EnumFacing commingFrom) {
        return commingFrom.func_176734_d();
    }

    @Override
    public TileEntity getConnectedEndTile(EnumFacing output) {
        if (output == this.orientation.dir || output.func_176734_d() == this.orientation.dir) {
            return this.container.getTile(output);
        }
        return null;
    }

    @Override
    public int getIconIndex(EnumFacing direction) {
        return 0;
    }

    @Override
    public int getTextureIndex() {
        return 0;
    }

    @Override
    public boolean actAsNormalPipe() {
        return false;
    }

    @Override
    public ISpecialPipeRenderer getSpecialRenderer() {
        return LineTubeRenderer.instance;
    }

    @Override
    public IHighlightPlacementRenderer getHighlightRenderer() {
        return LineTubeRenderer.instance;
    }

    @Override
    public boolean isHSTube() {
        return true;
    }

    public TubeLineOrientation getOrientation() {
        return this.orientation;
    }

    public static enum TubeLineRenderOrientation implements ITubeRenderOrientation
    {
        NORTH_SOUTH(EnumFacing.NORTH),
        EAST_WEST(EnumFacing.EAST);

        private EnumFacing dir;

        private TubeLineRenderOrientation(EnumFacing dir) {
            this.dir = dir;
        }

        public void rotateOrientation(IPositionRotateble set) {
            if (this == EAST_WEST) {
                set.rotateLeft();
            }
        }

        public EnumFacing getDir() {
            return this.dir;
        }
    }

    public static enum TubeLineOrientation implements ITubeOrientation
    {
        NORTH(TubeLineRenderOrientation.NORTH_SOUTH, new DoubleCoordinates(0.0, 0.0, 0.0), EnumFacing.NORTH),
        SOUTH(TubeLineRenderOrientation.NORTH_SOUTH, new DoubleCoordinates(0.0, 0.0, 0.0), EnumFacing.SOUTH),
        EAST(TubeLineRenderOrientation.EAST_WEST, new DoubleCoordinates(0.0, 0.0, 0.0), EnumFacing.EAST),
        WEST(TubeLineRenderOrientation.EAST_WEST, new DoubleCoordinates(0.0, 0.0, 0.0), EnumFacing.WEST);

        TubeLineRenderOrientation renderOrientation;
        DoubleCoordinates offset;
        EnumFacing dir;

        private TubeLineOrientation(TubeLineRenderOrientation render, DoubleCoordinates off, EnumFacing dir) {
            this.renderOrientation = render;
            this.offset = off;
            this.dir = dir;
        }

        @Override
        public void rotatePositions(IPositionRotateble set) {
            this.renderOrientation.rotateOrientation(set);
        }

        @Override
        public void setOnPipe(CoreMultiBlockPipe pipe) {
            ((HSTubeLine)pipe).orientation = this;
        }

        @Override
        public TubeLineRenderOrientation getRenderOrientation() {
            return this.renderOrientation;
        }

        @Override
        public DoubleCoordinates getOffset() {
            return this.offset;
        }

        public EnumFacing getDir() {
            return this.dir;
        }
    }
}

