/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.ic2;

import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.core.block.machine.tileentity.TileEntityStandardMachine;
import java.util.function.Function;
import javax.annotation.Nullable;
import logisticspipes.LogisticsPipes;
import logisticspipes.proxy.interfaces.IGenericProgressProvider;
import net.minecraft.tileentity.TileEntity;

public class IC2ProgressProvider
implements IGenericProgressProvider {
    @Nullable
    private Class<?> progressProviderClass = null;
    @Nullable
    private Function<TileEntity, Byte> getProgressFunction = null;

    public IC2ProgressProvider() {
        try {
            this.progressProviderClass = IProgressMachine.class;
            this.getProgressFunction = this::getIC2CProgress;
            return;
        }
        catch (LinkageError error) {
            block5: {
                if (LogisticsPipes.isDEBUG()) {
                    error.printStackTrace();
                }
                try {
                    this.progressProviderClass = TileEntityStandardMachine.class;
                    this.getProgressFunction = this::getIC2Progress;
                }
                catch (LinkageError error2) {
                    if (!LogisticsPipes.isDEBUG()) break block5;
                    error2.printStackTrace();
                }
            }
            return;
        }
    }

    @Override
    public boolean isType(TileEntity tile) {
        if (this.progressProviderClass == null) {
            return false;
        }
        return this.progressProviderClass.isInstance(tile);
    }

    private byte getIC2CProgress(TileEntity tile) {
        IProgressMachine progressMachine = (IProgressMachine)tile;
        float normalizedProgress = progressMachine.getProgress() / progressMachine.getMaxProgress();
        return (byte)Math.max(0.0f, Math.min(normalizedProgress * 100.0f, 100.0f));
    }

    private byte getIC2Progress(TileEntity tile) {
        TileEntityStandardMachine standardMachine = (TileEntityStandardMachine)tile;
        return (byte)Math.max(0.0f, Math.min(standardMachine.getProgress() * 100.0f, 100.0f));
    }

    @Override
    public byte getProgress(TileEntity tile) {
        if (this.getProgressFunction == null) {
            return 0;
        }
        return this.getProgressFunction.apply(tile);
    }
}

