/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

public enum Color {
    BLANK(0),
    WHITE(-1),
    WHITE_50(-2130706433),
    BLACK(-16777216),
    LIGHTER_GREY(-2039584),
    LIGHT_GREY(-4144960),
    GREY(-6250336),
    DARK_GREY(-8355712),
    DARKER_GREY(-11184811),
    RED(-65536),
    GREEN(-16711936),
    BLUE(-16776961),
    LIGHT_YELLOW(-96),
    TEXT_DARK(-12566464),
    TEXT_WHITE(-1),
    TEXT_HOVERED(-96),
    TEXT_DISABLED(-6250336),
    BACKGROUND_LIGHT(-3750202),
    BACKGROUND_DARK(-7631989),
    FUZZY_ORE_DICT_COLOR(-49088),
    FUZZY_IGNORE_DAMAGE_COLOR(-12517568),
    FUZZY_IGNORE_NBT_COLOR(-12566273),
    FUZZY_ORE_CATEGORY_COLOR(-8421568);

    private final int colorValue;

    private Color(int value) {
        this.colorValue = value;
    }

    public int getValue() {
        return this.colorValue;
    }

    public static int getValue(Color color) {
        return color.colorValue;
    }

    public static float getAlpha(int colorValue) {
        return (float)(colorValue >> 24 & 0xFF) / 255.0f;
    }

    public static float getRed(int colorValue) {
        return (float)(colorValue >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int colorValue) {
        return (float)(colorValue >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int colorValue) {
        return (float)(colorValue & 0xFF) / 255.0f;
    }
}

