/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.InventoryUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import network.rs485.logisticspipes.connection.NeighborTileEntity;
import network.rs485.logisticspipes.inventory.ProviderMode;

public class InventoryUtilFactory {
    private final ArrayList<SpecialInventoryHandler.Factory> handlerFactories = new ArrayList();

    public void registerHandler(@Nonnull SpecialInventoryHandler.Factory handlerFactory) {
        if (handlerFactory.init()) {
            this.handlerFactories.add(handlerFactory);
            LogisticsPipes.log.info("Loaded SpecialInventoryHandler.Factory: " + handlerFactory.getClass().getCanonicalName());
        } else {
            LogisticsPipes.log.warn("Could not load SpecialInventoryHandler.Factory: " + handlerFactory.getClass().getCanonicalName());
        }
    }

    @Nullable
    public SpecialInventoryHandler getSpecialHandlerFor(TileEntity tile, EnumFacing direction, ProviderMode mode) {
        return this.handlerFactories.stream().filter(factory2 -> factory2.isType(tile, direction)).map(factory2 -> factory2.getUtilForTile(tile, direction, mode)).filter(Objects::nonNull).findAny().orElse(null);
    }

    @Nullable
    public IInventoryUtil getInventoryUtil(@Nonnull NeighborTileEntity<TileEntity> adj) {
        return this.getHidingInventoryUtil(adj.getTileEntity(), adj.getOurDirection(), ProviderMode.DEFAULT);
    }

    @Nullable
    public IInventoryUtil getInventoryUtil(TileEntity inv, EnumFacing dir) {
        return this.getHidingInventoryUtil(inv, dir, ProviderMode.DEFAULT);
    }

    @Nullable
    public IInventoryUtil getHidingInventoryUtil(@Nullable TileEntity tile, @Nullable EnumFacing direction, @Nonnull ProviderMode mode) {
        if (tile != null) {
            SpecialInventoryHandler util = this.getSpecialHandlerFor(tile, direction, mode);
            if (util != null) {
                return util;
            }
            if (tile.hasCapability(LogisticsPipes.ITEM_HANDLER_CAPABILITY, direction)) {
                return new InventoryUtil((IItemHandler)tile.getCapability(LogisticsPipes.ITEM_HANDLER_CAPABILITY, direction), mode);
            }
        }
        return null;
    }
}

