/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.transactor;

import java.util.Iterator;
import javax.annotation.Nonnull;
import logisticspipes.utils.transactor.IInvSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

class InventoryIteratorSimple
implements Iterable<IInvSlot> {
    private final IItemHandler inv;

    InventoryIteratorSimple(IItemHandler inv) {
        this.inv = inv;
    }

    @Override
    @Nonnull
    public Iterator<IInvSlot> iterator() {
        return new Iterator<IInvSlot>(){
            int slot = 0;

            @Override
            public boolean hasNext() {
                return this.slot < InventoryIteratorSimple.this.inv.getSlots();
            }

            @Override
            public IInvSlot next() {
                return new InvSlot(this.slot++);
            }
        };
    }

    private class InvSlot
    implements IInvSlot {
        private final int slot;

        public InvSlot(int slot) {
            this.slot = slot;
        }

        @Override
        @Nonnull
        public ItemStack getStackInSlot() {
            return InventoryIteratorSimple.this.inv.getStackInSlot(this.slot);
        }

        @Override
        @Nonnull
        public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate) {
            return InventoryIteratorSimple.this.inv.insertItem(this.slot, stack.func_77946_l(), simulate);
        }

        @Override
        @Nonnull
        public ItemStack extractItem(int amount, boolean simulate) {
            return InventoryIteratorSimple.this.inv.extractItem(this.slot, amount, simulate);
        }

        @Override
        public int getSlotLimit() {
            return InventoryIteratorSimple.this.inv.getSlotLimit(this.slot);
        }

        @Override
        public boolean canPutStackInSlot(@Nonnull ItemStack stack) {
            ItemStack toTest = stack.func_77946_l();
            toTest.func_190920_e(1);
            return InventoryIteratorSimple.this.inv.insertItem(this.slot, toTest, true).func_190926_b();
        }
    }
}

