/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui;

import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.jvm.functions.Function0;
import logisticspipes.kotlin.jvm.internal.DefaultConstructorMarker;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import network.rs485.logisticspipes.gui.HorizontalAlignment;
import network.rs485.logisticspipes.gui.Margin;
import network.rs485.logisticspipes.gui.Size;
import network.rs485.logisticspipes.gui.VerticalAlignment;
import network.rs485.logisticspipes.gui.guidebook.Drawable;
import network.rs485.logisticspipes.gui.guidebook.MouseHoverable;
import network.rs485.logisticspipes.gui.guidebook.Screen;
import network.rs485.logisticspipes.gui.widget.LPGuiWidget;
import network.rs485.logisticspipes.util.IRectangle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ%\u0010\u0016\u001a\u0002H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\u0014\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0%H&R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lnetwork/rs485/logisticspipes/gui/WidgetContainer;", "Lnetwork/rs485/logisticspipes/gui/guidebook/MouseHoverable;", "Lnetwork/rs485/logisticspipes/gui/widget/LPGuiWidget;", "children", "", "parent", "Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "margin", "Lnetwork/rs485/logisticspipes/gui/Margin;", "gap", "", "(Ljava/util/List;Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;Lnetwork/rs485/logisticspipes/gui/Margin;I)V", "getChildren", "()Ljava/util/List;", "getGap", "()I", "setGap", "(I)V", "getParent", "()Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "setParent", "(Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;)V", "createChild", "T", "childGetter", "Llogisticspipes/kotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "draw", "", "mouseX", "", "mouseY", "delta", "visibleArea", "Lnetwork/rs485/logisticspipes/util/IRectangle;", "getHovered", "placeChildren", "Llogisticspipes/kotlin/Pair;", "logisticspipes"})
public abstract class WidgetContainer
extends LPGuiWidget
implements MouseHoverable {
    @NotNull
    private final List<LPGuiWidget> children;
    @Nullable
    private Drawable parent;
    private int gap;

    public WidgetContainer(@NotNull List<? extends LPGuiWidget> children2, @Nullable Drawable parent, @Nullable Margin margin, int gap) {
        Margin margin2;
        Intrinsics.checkNotNullParameter(children2, "children");
        Drawable drawable = parent;
        if (drawable == null) {
            drawable = Screen.INSTANCE;
        }
        if ((margin2 = margin) == null) {
            margin2 = Margin.Companion.getNONE();
        }
        super(drawable, HorizontalAlignment.LEFT, VerticalAlignment.TOP, Size.GROW, Size.GROW, margin2);
        this.children = children2;
        this.parent = parent;
        this.gap = gap;
    }

    public /* synthetic */ WidgetContainer(List list, Drawable drawable, Margin margin, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            drawable = null;
        }
        if ((n2 & 4) != 0) {
            margin = null;
        }
        this(list, drawable, margin, n);
    }

    @NotNull
    public final List<LPGuiWidget> getChildren() {
        return this.children;
    }

    @Override
    @Nullable
    public Drawable getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable Drawable drawable) {
        this.parent = drawable;
    }

    public final int getGap() {
        return this.gap;
    }

    public final void setGap(int n) {
        this.gap = n;
    }

    @Override
    @NotNull
    public <T extends Drawable> T createChild(@NotNull Function0<? extends T> childGetter) {
        Intrinsics.checkNotNullParameter(childGetter, "childGetter");
        if (LogisticsPipes.isDEBUG()) {
            LogisticsPipes.log.warn("createChild called on WidgetContainer, but WidgetContainer does not support lazy child creation");
            new Throwable().printStackTrace();
        }
        return (T)((Drawable)childGetter.invoke());
    }

    @Override
    public void draw(float mouseX, float mouseY, float delta, @NotNull IRectangle visibleArea) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        super.draw(mouseX, mouseY, delta, visibleArea);
        Iterable $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LPGuiWidget it = (LPGuiWidget)element$iv;
            boolean bl = false;
            it.draw(mouseX, mouseY, delta, visibleArea);
        }
    }

    @NotNull
    public abstract Pair<Integer, Integer> placeChildren();

    @Nullable
    public final MouseHoverable getHovered(float mouseX, float mouseY) {
        for (LPGuiWidget child : this.children) {
            if (child instanceof WidgetContainer) {
                MouseHoverable mouseHoverable = ((WidgetContainer)child).getHovered(mouseX, mouseY);
                if (mouseHoverable == null) continue;
                MouseHoverable it = mouseHoverable;
                boolean bl = false;
                return it;
            }
            if (!(child instanceof MouseHoverable) || !((MouseHoverable)((Object)child)).isMouseHovering(mouseX, mouseY)) continue;
            return (MouseHoverable)((Object)child);
        }
        return null;
    }
}

