/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.font;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.TuplesKt;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.collections.IndexedValue;
import logisticspipes.kotlin.collections.MapsKt;
import logisticspipes.kotlin.io.CloseableKt;
import logisticspipes.kotlin.io.TextStreamsKt;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.sequences.Sequence;
import logisticspipes.kotlin.sequences.SequencesKt;
import logisticspipes.kotlin.text.CharsKt;
import logisticspipes.kotlin.text.Charsets;
import logisticspipes.kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import network.rs485.logisticspipes.gui.font.BDF;
import network.rs485.logisticspipes.gui.font.FontParser;
import network.rs485.logisticspipes.gui.font.IGlyph;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\n\u000b\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000e"}, d2={"Lnetwork/rs485/logisticspipes/gui/font/FontParser;", "", "()V", "read", "Lnetwork/rs485/logisticspipes/gui/font/BDF;", "lines", "", "", "resourceLocation", "Lnet/minecraft/util/ResourceLocation;", "FontParserSyntaxException", "Glyph", "LineParser", "State", "logisticspipes"})
public final class FontParser {
    @NotNull
    public static final FontParser INSTANCE = new FontParser();

    private FontParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final BDF read(@NotNull ResourceLocation resourceLocation) {
        Object object;
        Intrinsics.checkNotNullParameter(resourceLocation, "resourceLocation");
        try {
            InputStream inputStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation).func_110527_b();
            Intrinsics.checkNotNullExpressionValue(inputStream, "getMinecraft().resourceM\u2026urceLocation).inputStream");
            object = inputStream;
            Object object2 = Charsets.UTF_8;
            Object object3 = new InputStreamReader((InputStream)object, (Charset)object2);
            int n = 8192;
            object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            FontParser fontParser = this;
            object2 = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl = false;
                object3 = TextStreamsKt.readLines(it);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            object = fontParser.read((List<String>)object3);
        }
        catch (IOException e) {
            LogisticsPipes.log.error("Font " + resourceLocation.func_110623_a() + " not found, and will not be rendered.", (Throwable)e);
            object = null;
        }
        return object;
    }

    @NotNull
    public final BDF read(@NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        LineParser parser = new LineParser();
        Sequence $this$forEach$iv = SequencesKt.withIndex(SequencesKt.filter(CollectionsKt.asSequence((Iterable)lines), read.2.INSTANCE));
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            IndexedValue element$iv;
            IndexedValue indexedValue = element$iv = iterator2.next();
            boolean bl = false;
            int index = indexedValue.component1();
            String line = (String)indexedValue.component2();
            parser.line(index, line);
        }
        return new BDF(parser.getGlyphs(), parser.getDefaultChar(), parser.getGWidth(), parser.getGHeight(), parser.getGOffsetX(), parser.getGOffsetY());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0011\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u000205H\u0002J\u0018\u00106\u001a\u0002022\u0006\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u000205H\u0002J\u0018\u00107\u001a\u0002022\u0006\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u000205H\u0002J\u0018\u00108\u001a\u0002022\u0006\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u000205H\u0002J\u0016\u00109\u001a\u0002022\u0006\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u000205J\u0016\u00104\u001a\u0002022\u0006\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u000205R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\bR\u001a\u0010\u001b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0006\"\u0004\b\u001d\u0010\bR\u001a\u0010\u001e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0006\"\u0004\b \u0010\bR\u001a\u0010!\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0006\"\u0004\b#\u0010\bR&\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020&0%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100\u00a8\u0006:"}, d2={"Lnetwork/rs485/logisticspipes/gui/font/FontParser$LineParser;", "", "()V", "chars", "", "getChars", "()I", "setChars", "(I)V", "currentByte", "getCurrentByte", "setCurrentByte", "currentGlyph", "Lnetwork/rs485/logisticspipes/gui/font/FontParser$Glyph;", "getCurrentGlyph", "()Lnetwork/rs485/logisticspipes/gui/font/FontParser$Glyph;", "setCurrentGlyph", "(Lnetwork/rs485/logisticspipes/gui/font/FontParser$Glyph;)V", "defaultChar", "", "getDefaultChar", "()C", "setDefaultChar", "(C)V", "gHeight", "getGHeight", "setGHeight", "gOffsetX", "getGOffsetX", "setGOffsetX", "gOffsetY", "getGOffsetY", "setGOffsetY", "gWidth", "getGWidth", "setGWidth", "glyphs", "", "Lnetwork/rs485/logisticspipes/gui/font/IGlyph;", "getGlyphs", "()Ljava/util/Map;", "setGlyphs", "(Ljava/util/Map;)V", "state", "Lnetwork/rs485/logisticspipes/gui/font/FontParser$State$IState;", "getState", "()Lnetwork/rs485/logisticspipes/gui/font/FontParser$State$IState;", "setState", "(Lnetwork/rs485/logisticspipes/gui/font/FontParser$State$IState;)V", "handleCharBitmap", "", "index", "line", "", "handleCharDefinition", "handleCharPre", "handleFontDefinition", "handleFontStart", "logisticspipes"})
    private static final class LineParser {
        @NotNull
        private State.IState state = State.Font.Start;
        private int chars;
        private int gWidth;
        private int gHeight;
        private int gOffsetX;
        private int gOffsetY;
        private char defaultChar = (char)63;
        public Glyph currentGlyph;
        @NotNull
        private Map<Character, ? extends IGlyph> glyphs = MapsKt.emptyMap();
        private int currentByte;

        @NotNull
        public final State.IState getState() {
            return this.state;
        }

        public final void setState(@NotNull State.IState iState) {
            Intrinsics.checkNotNullParameter(iState, "<set-?>");
            this.state = iState;
        }

        public final int getChars() {
            return this.chars;
        }

        public final void setChars(int n) {
            this.chars = n;
        }

        public final int getGWidth() {
            return this.gWidth;
        }

        public final void setGWidth(int n) {
            this.gWidth = n;
        }

        public final int getGHeight() {
            return this.gHeight;
        }

        public final void setGHeight(int n) {
            this.gHeight = n;
        }

        public final int getGOffsetX() {
            return this.gOffsetX;
        }

        public final void setGOffsetX(int n) {
            this.gOffsetX = n;
        }

        public final int getGOffsetY() {
            return this.gOffsetY;
        }

        public final void setGOffsetY(int n) {
            this.gOffsetY = n;
        }

        public final char getDefaultChar() {
            return this.defaultChar;
        }

        public final void setDefaultChar(char c) {
            this.defaultChar = c;
        }

        @NotNull
        public final Glyph getCurrentGlyph() {
            Glyph glyph = this.currentGlyph;
            if (glyph != null) {
                return glyph;
            }
            Intrinsics.throwUninitializedPropertyAccessException("currentGlyph");
            return null;
        }

        public final void setCurrentGlyph(@NotNull Glyph glyph) {
            Intrinsics.checkNotNullParameter(glyph, "<set-?>");
            this.currentGlyph = glyph;
        }

        @NotNull
        public final Map<Character, IGlyph> getGlyphs() {
            return this.glyphs;
        }

        public final void setGlyphs(@NotNull Map<Character, ? extends IGlyph> map2) {
            Intrinsics.checkNotNullParameter(map2, "<set-?>");
            this.glyphs = map2;
        }

        public final int getCurrentByte() {
            return this.currentByte;
        }

        public final void setCurrentByte(int n) {
            this.currentByte = n;
        }

        public final void line(int index, @NotNull String line) {
            Intrinsics.checkNotNullParameter(line, "line");
            State.IState iState = this.state;
            if (iState == State.Font.Start) {
                this.handleFontStart(index, line);
            } else if (iState == State.Font.Definition) {
                this.handleFontDefinition(index, line);
            } else if (iState == State.Char.Pre) {
                this.handleCharPre(index, line);
            } else if (iState == State.Char.Definition) {
                this.handleCharDefinition(index, line);
            } else if (iState == State.Char.Bitmap) {
                this.handleCharBitmap(index, line);
            } else if (iState == State.Font.End) {
                throw new FontParserSyntaxException(this.state, index, "There must be nothing in the lines following 'ENDFONT'");
            }
        }

        private final void handleCharBitmap(int index, String line) {
            String[] stringArray = new String[]{" "};
            List tokens = StringsKt.split$default((CharSequence)line, stringArray, false, 0, 6, null);
            String head = (String)CollectionsKt.first(tokens);
            if (Intrinsics.areEqual(head, "ENDCHAR")) {
                this.state = State.Char.Pre;
                if (this.currentByte != this.getCurrentGlyph().getHeight()) {
                    throw new FontParserSyntaxException(this.state, index, "Current Glyph is missing some Bytes, last byte index is " + this.currentByte + ", expected: " + this.getCurrentGlyph().getHeight() + ';');
                }
                this.glyphs = MapsKt.plus(this.glyphs, TuplesKt.to(Character.valueOf(this.getCurrentGlyph().getCharPoint()), this.getCurrentGlyph()));
            } else {
                int wordlen = head.length() * 4 - 1;
                int data = Integer.parseInt(head, CharsKt.checkRadix(16));
                int n = this.getCurrentGlyph().getWidth();
                for (int i = 0; i < n; ++i) {
                    this.getCurrentGlyph().getBitmap().set(i + this.currentByte * this.getCurrentGlyph().getWidth(), (data >>> wordlen - i & 1) != 0);
                }
                int n2 = this.currentByte;
                this.currentByte = n2 + 1;
            }
        }

        private final void handleCharDefinition(int index, String line) {
            String[] stringArray = new String[]{" "};
            List tokens = StringsKt.split$default((CharSequence)line, stringArray, false, 0, 6, null);
            switch ((String)CollectionsKt.first(tokens)) {
                case "ENCODING": {
                    this.getCurrentGlyph().setCharPoint((char)Integer.parseInt((String)tokens.get(1)));
                    break;
                }
                case "DWIDTH": {
                    Glyph glyph;
                    Glyph $this$handleCharDefinition_u24lambda_u2d0 = glyph = this.getCurrentGlyph();
                    boolean bl = false;
                    $this$handleCharDefinition_u24lambda_u2d0.setDWidthX(Integer.parseInt((String)tokens.get(1)));
                    $this$handleCharDefinition_u24lambda_u2d0.setDWidthY(Integer.parseInt((String)tokens.get(2)));
                    break;
                }
                case "BBX": {
                    Glyph glyph;
                    Glyph $this$handleCharDefinition_u24lambda_u2d1 = glyph = this.getCurrentGlyph();
                    boolean bl = false;
                    $this$handleCharDefinition_u24lambda_u2d1.setWidth(Integer.parseInt((String)tokens.get(1)));
                    $this$handleCharDefinition_u24lambda_u2d1.setHeight(Integer.parseInt((String)tokens.get(2)));
                    $this$handleCharDefinition_u24lambda_u2d1.setOffsetX(Integer.parseInt((String)tokens.get(3)));
                    $this$handleCharDefinition_u24lambda_u2d1.setOffsetY(Integer.parseInt((String)tokens.get(4)));
                    break;
                }
                case "BITMAP": {
                    this.state = State.Char.Bitmap;
                    this.currentByte = 0;
                    break;
                }
                default: {
                    String head;
                    if (!LogisticsPipes.isDEBUG()) break;
                    LogisticsPipes.log.warn("[@" + this.state + "][Ln" + index + "] Declaration start not recognized: " + head);
                }
                case "SWIDTH": 
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void handleCharPre(int index, String line) {
            String[] stringArray = new String[]{" "};
            List tokens = StringsKt.split$default((CharSequence)line, stringArray, false, 0, 6, null);
            String head = (String)CollectionsKt.first(tokens);
            if (Intrinsics.areEqual(head, "STARTCHAR")) {
                void $this$handleCharPre_u24lambda_u2d2;
                Glyph glyph;
                this.state = State.Char.Definition;
                Glyph glyph2 = glyph = new Glyph((String)tokens.get(1));
                LineParser lineParser = this;
                boolean bl = false;
                $this$handleCharPre_u24lambda_u2d2.setWidth(this.gWidth);
                $this$handleCharPre_u24lambda_u2d2.setHeight(this.gHeight);
                $this$handleCharPre_u24lambda_u2d2.setOffsetX(this.gOffsetX);
                $this$handleCharPre_u24lambda_u2d2.setOffsetY(this.gOffsetY);
                lineParser.setCurrentGlyph(glyph);
            } else if (Intrinsics.areEqual(head, "ENDFONT")) {
                if (this.chars != this.glyphs.size()) {
                    System.out.println((Object)("[@" + this.state + "][Ln" + index + "] Expected a different amount of Glyphs, got " + this.glyphs.size() + ", expected: " + this.chars));
                }
                this.state = State.Font.End;
            } else {
                System.out.println((Object)("[@" + this.state + "][Ln" + index + "] Declaration start not recognized: " + head));
            }
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         */
        private final void handleFontDefinition(int index, String line) {
            var4_3 = new String[]{" "};
            tokens = StringsKt.split$default((CharSequence)line, var4_3, false, 0, 6, null);
            head = (String)CollectionsKt.first(tokens);
            tmp = -1;
            switch (head.hashCode()) {
                case -34455566: {
                    if (!head.equals("WEIGHT_NAME")) break;
                    tmp = 1;
                    break;
                }
                case -2008746619: {
                    if (!head.equals("RESOLUTION_X")) break;
                    tmp = 1;
                    break;
                }
                case 97999605: {
                    if (!head.equals("STARTPROPERTIES")) break;
                    tmp = 1;
                    break;
                }
                case -1986360616: {
                    if (!head.equals("NOTICE")) break;
                    tmp = 1;
                    break;
                }
                case -2008746618: {
                    if (!head.equals("RESOLUTION_Y")) break;
                    tmp = 1;
                    break;
                }
                case -297036600: {
                    if (!head.equals("FONT_VERSION")) break;
                    tmp = 1;
                    break;
                }
                case 724718164: {
                    if (!head.equals("CAP_HEIGHT")) break;
                    tmp = 1;
                    break;
                }
                case 333977646: {
                    if (!head.equals("ENDPROPERTIES")) break;
                    tmp = 1;
                    break;
                }
                case 2545665: {
                    if (!head.equals("SIZE")) break;
                    tmp = 1;
                    break;
                }
                case 908209322: {
                    if (!head.equals("FONT_DESCENT")) break;
                    tmp = 1;
                    break;
                }
                case 1044500269: {
                    if (!head.equals("FACE_NAME")) break;
                    tmp = 1;
                    break;
                }
                case -710742290: {
                    if (!head.equals("X_HEIGHT")) break;
                    tmp = 1;
                    break;
                }
                case 1696075444: {
                    if (!head.equals("DEFAULT_CHAR")) break;
                    tmp = 2;
                    break;
                }
                case 64085949: {
                    if (!head.equals("CHARS")) break;
                    tmp = 3;
                    break;
                }
                case 2163791: {
                    if (!head.equals("FONT")) break;
                    tmp = 1;
                    break;
                }
                case 1668381247: {
                    if (!head.equals("COMMENT")) break;
                    tmp = 1;
                    break;
                }
                case 1895527114: {
                    if (!head.equals("FONT_ASCENT")) break;
                    tmp = 1;
                    break;
                }
                case 1780881776: {
                    if (!head.equals("POINT_SIZE")) break;
                    tmp = 1;
                    break;
                }
                case 1183963782: {
                    if (!head.equals("FAMILY_NAME")) break;
                    tmp = 1;
                    break;
                }
                case -1396638248: {
                    if (!head.equals("FONTBOUNDINGBOX")) break;
                    tmp = 4;
                    break;
                }
                case 14517159: {
                    if (!head.equals("COPYRIGHT")) break;
                    tmp = 1;
                    break;
                }
                case 78981326: {
                    if (!head.equals("SLANT")) break;
                    tmp = 1;
                    break;
                }
                case 0x2955929: {
                    if (head.equals("FOUNDRY")) ** GOTO lbl-1000
                }
            }
            block32: while (true) {
                switch (tmp) {
                    case 1: lbl-1000:
                    // 2 sources

                    {
                        tmp = 5;
                        continue block32;
                    }
                    case 2: {
                        this.defaultChar = (char)Integer.parseInt((String)tokens.get(1));
                        return;
                    }
                    case 4: {
                        this.gWidth = Integer.parseInt((String)tokens.get(1));
                        this.gHeight = Integer.parseInt((String)tokens.get(2));
                        this.gOffsetX = Integer.parseInt((String)tokens.get(3));
                        this.gOffsetY = Integer.parseInt((String)tokens.get(4));
                        return;
                    }
                    case 3: {
                        this.chars = Integer.parseInt((String)tokens.get(1));
                        this.state = State.Char.Pre;
                        return;
                    }
                    default: {
                        System.out.println((Object)("[@" + this.state + "][Ln" + index + "] Declaration start not recognized: " + head));
                        return;
                    }
                    case 5: 
                }
                break;
            }
        }

        public final void handleFontStart(int index, @NotNull String line) {
            Intrinsics.checkNotNullParameter(line, "line");
            String[] stringArray = new String[]{" "};
            List list = StringsKt.split$default((CharSequence)line, stringArray, false, 0, 6, null);
            String token = (String)list.get(0);
            String version = (String)list.get(1);
            if (!Intrinsics.areEqual(token, "STARTFONT")) {
                throw new FontParserSyntaxException(this.state, index, "Expected 'STARTFONT', found: '" + token + "';");
            }
            if (!Intrinsics.areEqual(version, "2.1")) {
                throw new FontParserSyntaxException(this.state, index, "Only supported version currently is '2.1' , found: '" + version + "';");
            }
            this.state = State.Font.Definition;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0016\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0012\"\u0004\b\u001f\u0010\u0014R\u001a\u0010 \u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0012\"\u0004\b\"\u0010\u0014R\u001a\u0010#\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0012\"\u0004\b%\u0010\u0014\u00a8\u0006&"}, d2={"Lnetwork/rs485/logisticspipes/gui/font/FontParser$Glyph;", "Lnetwork/rs485/logisticspipes/gui/font/IGlyph;", "name", "", "(Ljava/lang/String;)V", "bitmap", "Ljava/util/BitSet;", "getBitmap", "()Ljava/util/BitSet;", "charPoint", "", "getCharPoint", "()C", "setCharPoint", "(C)V", "dWidthX", "", "getDWidthX", "()I", "setDWidthX", "(I)V", "dWidthY", "getDWidthY", "setDWidthY", "height", "getHeight", "setHeight", "getName", "()Ljava/lang/String;", "offsetX", "getOffsetX", "setOffsetX", "offsetY", "getOffsetY", "setOffsetY", "width", "getWidth", "setWidth", "logisticspipes"})
    private static final class Glyph
    implements IGlyph {
        @NotNull
        private final String name;
        private char charPoint;
        private int dWidthX;
        private int dWidthY;
        private int width;
        private int height;
        private int offsetX;
        private int offsetY;
        @NotNull
        private final BitSet bitmap;

        public Glyph(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            this.name = name;
            this.bitmap = new BitSet();
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public char getCharPoint() {
            return this.charPoint;
        }

        public void setCharPoint(char c) {
            this.charPoint = c;
        }

        @Override
        public int getDWidthX() {
            return this.dWidthX;
        }

        public void setDWidthX(int n) {
            this.dWidthX = n;
        }

        @Override
        public int getDWidthY() {
            return this.dWidthY;
        }

        public void setDWidthY(int n) {
            this.dWidthY = n;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        public void setWidth(int n) {
            this.width = n;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        public void setHeight(int n) {
            this.height = n;
        }

        @Override
        public int getOffsetX() {
            return this.offsetX;
        }

        public void setOffsetX(int n) {
            this.offsetX = n;
        }

        @Override
        public int getOffsetY() {
            return this.offsetY;
        }

        @Override
        public void setOffsetY(int n) {
            this.offsetY = n;
        }

        @Override
        @NotNull
        public BitSet getBitmap() {
            return this.bitmap;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lnetwork/rs485/logisticspipes/gui/font/FontParser$State;", "", "(Ljava/lang/String;I)V", "Char", "Font", "IState", "logisticspipes"})
    public static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        private static final /* synthetic */ State[] $values() {
            return new State[0];
        }

        static {
            $VALUES = State.$values();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0002\u00c0\u0006\u0001"}, d2={"Lnetwork/rs485/logisticspipes/gui/font/FontParser$State$IState;", "", "logisticspipes"})
        public static interface IState {
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnetwork/rs485/logisticspipes/gui/font/FontParser$State$Font;", "", "Lnetwork/rs485/logisticspipes/gui/font/FontParser$State$IState;", "(Ljava/lang/String;I)V", "Start", "Definition", "End", "logisticspipes"})
        public static final class Font
        extends Enum<Font>
        implements IState {
            public static final /* enum */ Font Start = new Font();
            public static final /* enum */ Font Definition = new Font();
            public static final /* enum */ Font End = new Font();
            private static final /* synthetic */ Font[] $VALUES;

            public static Font[] values() {
                return (Font[])$VALUES.clone();
            }

            public static Font valueOf(String value) {
                return Enum.valueOf(Font.class, value);
            }

            static {
                $VALUES = fontArray = new Font[]{Font.Start, Font.Definition, Font.End};
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnetwork/rs485/logisticspipes/gui/font/FontParser$State$Char;", "", "Lnetwork/rs485/logisticspipes/gui/font/FontParser$State$IState;", "(Ljava/lang/String;I)V", "Pre", "Definition", "Bitmap", "logisticspipes"})
        public static final class Char
        extends Enum<Char>
        implements IState {
            public static final /* enum */ Char Pre = new Char();
            public static final /* enum */ Char Definition = new Char();
            public static final /* enum */ Char Bitmap = new Char();
            private static final /* synthetic */ Char[] $VALUES;

            public static Char[] values() {
                return (Char[])$VALUES.clone();
            }

            public static Char valueOf(String value) {
                return Enum.valueOf(Char.class, value);
            }

            static {
                $VALUES = charArray = new Char[]{Char.Pre, Char.Definition, Char.Bitmap};
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00060\u0001j\u0002`\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lnetwork/rs485/logisticspipes/gui/font/FontParser$FontParserSyntaxException;", "Ljava/lang/RuntimeException;", "Llogisticspipes/kotlin/RuntimeException;", "state", "Lnetwork/rs485/logisticspipes/gui/font/FontParser$State$IState;", "line", "", "s", "", "(Lnetwork/rs485/logisticspipes/gui/font/FontParser$State$IState;ILjava/lang/String;)V", "getLine", "()I", "getS", "()Ljava/lang/String;", "getState", "()Lnetwork/rs485/logisticspipes/gui/font/FontParser$State$IState;", "logisticspipes"})
    public static final class FontParserSyntaxException
    extends RuntimeException {
        @NotNull
        private final State.IState state;
        private final int line;
        @NotNull
        private final String s;

        public FontParserSyntaxException(@NotNull State.IState state, int line, @NotNull String s) {
            Intrinsics.checkNotNullParameter(state, "state");
            Intrinsics.checkNotNullParameter(s, "s");
            super("Syntax exception on line " + line + " (state " + state + "): " + s);
            this.state = state;
            this.line = line;
            this.s = s;
        }

        @NotNull
        public final State.IState getState() {
            return this.state;
        }

        public final int getLine() {
            return this.line;
        }

        @NotNull
        public final String getS() {
            return this.s;
        }
    }
}

