/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.guidebook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import network.rs485.logisticspipes.gui.guidebook.Drawable;
import network.rs485.logisticspipes.gui.guidebook.DrawableHeaderParagraph;
import network.rs485.logisticspipes.gui.guidebook.DrawableHorizontalLine;
import network.rs485.logisticspipes.gui.guidebook.DrawableKt;
import network.rs485.logisticspipes.gui.guidebook.DrawableParagraph;
import network.rs485.logisticspipes.gui.guidebook.DrawableWord;
import network.rs485.logisticspipes.gui.guidebook.DrawableWordKt;
import network.rs485.logisticspipes.gui.guidebook.GuiGuideBook;
import network.rs485.logisticspipes.gui.guidebook.GuideBookMouseInteractable;
import network.rs485.logisticspipes.util.IRectangle;
import network.rs485.logisticspipes.util.math.MutableRectangle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J(\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J.\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0018\u00010!R\u00020\"H\u0016J\b\u0010#\u001a\u00020\u001fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableHeaderParagraph;", "Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableParagraph;", "words", "", "Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableWord;", "(Ljava/util/List;)V", "horizontalLine", "Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableHorizontalLine;", "parent", "Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "getParent", "()Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "setParent", "(Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;)V", "relativeBody", "Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "getRelativeBody", "()Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "draw", "", "mouseX", "", "mouseY", "delta", "visibleArea", "Lnetwork/rs485/logisticspipes/util/IRectangle;", "drawChildren", "getHovered", "inBookMouseClicked", "", "mouseButton", "", "guideActionListener", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook$ActionListener;", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook;", "setChildrenPos", "logisticspipes"})
public final class DrawableHeaderParagraph
extends DrawableParagraph {
    @NotNull
    private final List<DrawableWord> words;
    @NotNull
    private final MutableRectangle relativeBody;
    @Nullable
    private Drawable parent;
    @NotNull
    private final DrawableHorizontalLine horizontalLine;

    public DrawableHeaderParagraph(@NotNull List<? extends DrawableWord> words) {
        Intrinsics.checkNotNullParameter(words, "words");
        this.words = words;
        this.relativeBody = new MutableRectangle();
        this.horizontalLine = (DrawableHorizontalLine)this.createChild(horizontalLine.1.INSTANCE);
    }

    @Override
    @NotNull
    public MutableRectangle getRelativeBody() {
        return this.relativeBody;
    }

    @Override
    @Nullable
    public Drawable getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable Drawable drawable) {
        this.parent = drawable;
    }

    @Override
    public boolean inBookMouseClicked(float mouseX, float mouseY, int mouseButton, @Nullable GuiGuideBook.ActionListener guideActionListener) {
        Object v0;
        block1: {
            Iterable iterable = this.words;
            for (Object t : iterable) {
                DrawableWord it = (DrawableWord)t;
                boolean bl = false;
                if (!it.isMouseHovering(mouseX, mouseY)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        DrawableWord drawableWord = v0;
        return drawableWord != null ? drawableWord.inBookMouseClicked(mouseX, mouseY, mouseButton, guideActionListener) : false;
    }

    @Override
    public void draw(float mouseX, float mouseY, float delta, @NotNull IRectangle visibleArea) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        super.draw(mouseX, mouseY, delta, visibleArea);
        this.drawChildren(mouseX, mouseY, delta, visibleArea);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawChildren(float mouseX, float mouseY, float delta, @NotNull IRectangle visibleArea) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        Iterable $this$filter$iv = CollectionsKt.plus((Collection)this.words, this.horizontalLine);
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!((Drawable)it).visible(visibleArea)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv;
            Object it = element$iv = object.next();
            boolean bl = false;
            ((Drawable)it).draw(mouseX, mouseY, delta, visibleArea);
        }
    }

    @Override
    @Nullable
    public Drawable getHovered(float mouseX, float mouseY) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = CollectionsKt.plus((Collection)this.words, this.horizontalLine);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Drawable it = (Drawable)element$iv;
                boolean bl = false;
                if (!((GuideBookMouseInteractable)((Object)it)).isMouseHovering(mouseX, mouseY)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    public int setChildrenPos() {
        int currentY = DrawableWordKt.splitAndInitialize(this.words, 0, 0, this.getWidth(), true);
        currentY += ((Number)DrawableKt.getY(this.horizontalLine.setPos(0, currentY))).intValue();
        return currentY;
    }
}

