/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.guidebook;

import java.util.Set;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.Unit;
import logisticspipes.kotlin.jvm.functions.Function3;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import network.rs485.logisticspipes.gui.GuiDrawer;
import network.rs485.logisticspipes.gui.guidebook.Drawable;
import network.rs485.logisticspipes.gui.guidebook.DrawableParagraph;
import network.rs485.logisticspipes.gui.guidebook.GuiGuideBook;
import network.rs485.logisticspipes.gui.guidebook.GuideBookMouseInteractable;
import network.rs485.logisticspipes.gui.guidebook.LinkInteractable;
import network.rs485.logisticspipes.util.IRectangle;
import network.rs485.logisticspipes.util.math.MutableRectangle;
import network.rs485.markdown.ElementKt;
import network.rs485.markdown.InlineDrawableState;
import network.rs485.markdown.TextFormat;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ(\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020'H\u0016J.\u0010(\u001a\u00020)2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\r2\f\u0010+\u001a\b\u0018\u00010,R\u00020-H\u0016J\u0018\u0010.\u001a\u00020)2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006H\u0016J$\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r002\u0006\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\rH\u0016J\u0010\u00103\u001a\u00020\"2\u0006\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u00020\u0004H\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R(\u0010\u0018\u001a\u0004\u0018\u00010\u00012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableWord;", "Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuideBookMouseInteractable;", "str", "", "scale", "", "state", "Lnetwork/rs485/markdown/InlineDrawableState;", "linkInteractable", "Lnetwork/rs485/logisticspipes/gui/guidebook/LinkInteractable;", "(Ljava/lang/String;FLnetwork/rs485/markdown/InlineDrawableState;Lnetwork/rs485/logisticspipes/gui/guidebook/LinkInteractable;)V", "color", "", "getColor", "()I", "format", "", "Lnetwork/rs485/markdown/TextFormat;", "getFormat", "()Ljava/util/Set;", "getLinkInteractable", "()Lnetwork/rs485/logisticspipes/gui/guidebook/LinkInteractable;", "value", "parent", "getParent", "()Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "setParent", "(Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;)V", "relativeBody", "Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "getRelativeBody", "()Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "draw", "", "mouseX", "mouseY", "delta", "visibleArea", "Lnetwork/rs485/logisticspipes/util/IRectangle;", "inBookMouseClicked", "", "mouseButton", "guideActionListener", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook$ActionListener;", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook;", "isMouseHovering", "setPos", "Llogisticspipes/kotlin/Pair;", "x", "y", "setupParent", "drawableParagraph", "Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableParagraph;", "toString", "logisticspipes"})
public class DrawableWord
implements Drawable,
GuideBookMouseInteractable {
    @NotNull
    private final String str;
    private final float scale;
    @Nullable
    private final LinkInteractable linkInteractable;
    @NotNull
    private final MutableRectangle relativeBody;
    @Nullable
    private Drawable parent;
    @NotNull
    private final Set<TextFormat> format;
    private final int color;

    public DrawableWord(@NotNull String str, float scale, @NotNull InlineDrawableState state, @Nullable LinkInteractable linkInteractable) {
        Intrinsics.checkNotNullParameter(str, "str");
        Intrinsics.checkNotNullParameter(state, "state");
        this.str = str;
        this.scale = scale;
        this.linkInteractable = linkInteractable;
        this.relativeBody = new MutableRectangle();
        this.format = state.getFormat();
        this.color = state.getColor();
        this.relativeBody.setSize(GuiDrawer.INSTANCE.getLpFontRenderer().getStringWidth(this.str, ElementKt.italic(this.format), ElementKt.bold(this.format), this.scale), GuiDrawer.INSTANCE.getLpFontRenderer().getFontHeight(this.scale));
    }

    @Nullable
    protected final LinkInteractable getLinkInteractable() {
        return this.linkInteractable;
    }

    @Override
    @NotNull
    public final MutableRectangle getRelativeBody() {
        return this.relativeBody;
    }

    @Override
    @Nullable
    public Drawable getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable Drawable value) {
        block0: {
            this.parent = value;
            DrawableParagraph drawableParagraph = value instanceof DrawableParagraph ? (DrawableParagraph)value : null;
            if (drawableParagraph == null) break block0;
            DrawableParagraph p0 = drawableParagraph;
            boolean bl = false;
            this.setupParent(p0);
        }
    }

    @NotNull
    public final Set<TextFormat> getFormat() {
        return this.format;
    }

    public final int getColor() {
        return this.color;
    }

    private final void setupParent(DrawableParagraph drawableParagraph) {
        if (this.linkInteractable != null) {
            drawableParagraph.registerPreRenderCallback((Function3<? super Float, ? super Float, ? super IRectangle, Unit>)new Function3<Float, Float, IRectangle, Unit>((Object)this.linkInteractable){

                public final void invoke(float p0, float p1, @NotNull IRectangle p2) {
                    Intrinsics.checkNotNullParameter(p2, "p2");
                    ((LinkInteractable)this.receiver).updateState(p0, p1, p2);
                }
            });
        }
    }

    @Override
    public boolean inBookMouseClicked(float mouseX, float mouseY, int mouseButton, @Nullable GuiGuideBook.ActionListener guideActionListener) {
        LinkInteractable linkInteractable = this.linkInteractable;
        return linkInteractable != null ? linkInteractable.inBookMouseClicked(mouseX, mouseY, mouseButton, guideActionListener) : GuideBookMouseInteractable.super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean isMouseHovering(float mouseX, float mouseY) {
        return this.getAbsoluteBody().contains(mouseX, mouseY);
    }

    @Override
    public void draw(float mouseX, float mouseY, float delta, @NotNull IRectangle visibleArea) {
        Set<TextFormat> updatedFormat;
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        LinkInteractable linkInteractable = this.linkInteractable;
        boolean hovering = linkInteractable != null ? linkInteractable.isMouseHovering(mouseX, mouseY) : false;
        LinkInteractable linkInteractable2 = this.linkInteractable;
        int updatedColor = linkInteractable2 != null ? linkInteractable2.updateColor(this.color) : this.color;
        Object object = this.linkInteractable;
        if (object == null || (object = object.updateFormat(this.format)) == null) {
            object = updatedFormat = this.format;
        }
        if (hovering) {
            GuiDrawer.INSTANCE.drawInteractionIndicator(mouseX, mouseY);
        }
        GuiDrawer.INSTANCE.getLpFontRenderer().drawString(this.str, this.getLeft(), this.getTop(), updatedColor, updatedFormat, this.scale);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> setPos(int x, int y) {
        this.relativeBody.setPos(x, y);
        return Drawable.super.setPos(x, y);
    }

    @NotNull
    public String toString() {
        return '\"' + this.str + '\"';
    }
}

