/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.guidebook;

import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.utils.MinecraftColor;
import net.minecraft.client.Minecraft;
import network.rs485.logisticspipes.gui.GuiDrawer;
import network.rs485.logisticspipes.gui.HorizontalAlignment;
import network.rs485.logisticspipes.gui.VerticalAlignment;
import network.rs485.logisticspipes.gui.guidebook.LPGuiButton;
import network.rs485.logisticspipes.gui.guidebook.Page;
import network.rs485.logisticspipes.gui.guidebook.TabButtonKt;
import network.rs485.logisticspipes.gui.guidebook.TabButtonReturn;
import network.rs485.logisticspipes.util.Rectangle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010 \u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0006\u0010!\u001a\u00020\u0010J\u0016\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0010J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/TabButton;", "Lnetwork/rs485/logisticspipes/gui/guidebook/LPGuiButton;", "tabPage", "Lnetwork/rs485/logisticspipes/gui/guidebook/Page;", "x", "", "y", "whisky", "Lnetwork/rs485/logisticspipes/gui/guidebook/TabButtonReturn;", "(Lnetwork/rs485/logisticspipes/gui/guidebook/Page;IILnetwork/rs485/logisticspipes/gui/guidebook/TabButtonReturn;)V", "bodyTrigger", "Lnetwork/rs485/logisticspipes/util/Rectangle;", "getBodyTrigger", "()Lnetwork/rs485/logisticspipes/util/Rectangle;", "circleArea", "isActive", "", "()Z", "isInactive", "getTabPage$logisticspipes", "()Lnetwork/rs485/logisticspipes/gui/guidebook/Page;", "drawButton", "", "mc", "Lnet/minecraft/client/Minecraft;", "mouseX", "mouseY", "partialTicks", "", "drawButtonForegroundLayer", "getTooltipText", "", "mousePressed", "onLeftClick", "onRightClick", "shiftClick", "ctrlClick", "setPos", "newX", "newY", "logisticspipes"})
public final class TabButton
extends LPGuiButton {
    @NotNull
    private final Page tabPage;
    @NotNull
    private final TabButtonReturn whisky;
    @NotNull
    private final Rectangle bodyTrigger;
    @NotNull
    private final Rectangle circleArea;

    public TabButton(@NotNull Page tabPage, int x, int y, @NotNull TabButtonReturn whisky) {
        Intrinsics.checkNotNullParameter(tabPage, "tabPage");
        Intrinsics.checkNotNullParameter(whisky, "whisky");
        super(99, x, y - 24, 24, 32);
        this.tabPage = tabPage;
        this.whisky = whisky;
        this.bodyTrigger = new Rectangle(1, 1, 22, 22);
        this.circleArea = new Rectangle(4, 4, 16, 16);
    }

    @NotNull
    public final Page getTabPage$logisticspipes() {
        return this.tabPage;
    }

    @Override
    @NotNull
    public Rectangle getBodyTrigger() {
        return this.bodyTrigger;
    }

    public final boolean isActive() {
        return this.whisky.isPageActive();
    }

    public final boolean isInactive() {
        return !this.isActive();
    }

    public final boolean onLeftClick() {
        return this.whisky.onLeftClick();
    }

    public final boolean onRightClick(boolean shiftClick, boolean ctrlClick) {
        return this.whisky.onRightClick(shiftClick, ctrlClick);
    }

    public void func_191745_a(@NotNull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        Intrinsics.checkNotNullParameter(mc, "mc");
        this.field_146123_n = this.isHovered$logisticspipes(mouseX, mouseY);
        if (!this.field_146125_m) {
            return;
        }
        if (this.isInactive()) {
            int yOffset = this.whisky.isPageActive() ? 0 : 3;
            int color = MinecraftColor.values()[this.whisky.getColor()].getColorCode() & 0xFFFFFF | 0xFF000000;
            GuiDrawer.INSTANCE.drawGuiTexturedRect(this.getBody().translated(0, yOffset), TabButtonKt.access$getButtonTextureArea$p(), true, this.whisky.isPageActive() ? -1 : color);
        }
    }

    @Override
    @NotNull
    public String getTooltipText() {
        return this.tabPage.getTitle();
    }

    public void func_146111_b(int mouseX, int mouseY) {
        if (this.isActive()) {
            int color = MinecraftColor.values()[this.whisky.getColor()].getColorCode() & 0xFFFFFF | 0xFF000000;
            GuiDrawer.INSTANCE.drawGuiTexturedRect(this.getBody(), TabButtonKt.access$getButtonTextureArea$p(), true, -1);
            GuiDrawer.INSTANCE.drawGuiTexturedRect(this.circleArea.translated(this.getBody()), TabButtonKt.access$getCircleAreaTexture$p(), true, color);
        }
        if (this.field_146123_n && this.field_146125_m) {
            this.drawTooltip(this.getBody().getRoundedRight(), this.getBody().getRoundedTop(), HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM);
        }
    }

    @Override
    public void setPos(int newX, int newY) {
        this.getBody().setPos(newX, newY - 24);
    }

    @Override
    public boolean func_146116_c(@NotNull Minecraft mc, int mouseX, int mouseY) {
        Intrinsics.checkNotNullParameter(mc, "mc");
        return this.getBodyTrigger().translated(this.getBody()).translated(0, this.whisky.isPageActive() ? -3 : 0).contains(mouseX, mouseY);
    }
}

