/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.module;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import logisticspipes.config.Configs;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.Unit;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.coroutines.Continuation;
import logisticspipes.kotlin.coroutines.intrinsics.IntrinsicsKt;
import logisticspipes.kotlin.jvm.functions.Function0;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.jvm.internal.Ref;
import logisticspipes.kotlin.ranges.IntProgression;
import logisticspipes.kotlin.ranges.IntRange;
import logisticspipes.kotlin.ranges.RangesKt;
import logisticspipes.kotlin.sequences.Sequence;
import logisticspipes.kotlinx.coroutines.channels.Channel;
import logisticspipes.kotlinx.coroutines.channels.ChannelKt;
import logisticspipes.kotlinx.coroutines.channels.ReceiveChannel;
import logisticspipes.kotlinx.coroutines.channels.SendChannel;
import logisticspipes.kotlinx.coroutines.flow.FlowCollector;
import logisticspipes.kotlinx.coroutines.flow.FlowKt;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.routing.AsyncRouting;
import logisticspipes.routing.ServerRouter;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import network.rs485.logisticspipes.logistics.LogisticsManager;
import network.rs485.logisticspipes.module.AsyncExtractorModule;
import network.rs485.logisticspipes.module.UtilKt;
import network.rs485.logisticspipes.util.ItemKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006J(\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\rH\u0002J\u0011\u0010\u001c\u001a\u00020\u0014H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u0014R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Lnetwork/rs485/logisticspipes/module/ExtractorJob;", "", "module", "Lnetwork/rs485/logisticspipes/module/AsyncExtractorModule;", "inventoryGetter", "Llogisticspipes/kotlin/Function0;", "Llogisticspipes/interfaces/IInventoryUtil;", "(Lnetwork/rs485/logisticspipes/module/AsyncExtractorModule;Lkotlin/jvm/functions/Function0;)V", "inventorySize", "", "itemsLeft", "slotItemsToExtract", "", "Llogisticspipes/utils/item/ItemIdentifierStack;", "slotStartIter", "", "slotsPerTick", "stacksLeft", "updateRoutingTableMsgChannel", "Llogisticspipes/kotlinx/coroutines/channels/Channel;", "", "extractAndSend", "serverRouter", "Llogisticspipes/routing/ServerRouter;", "inventory", "extractAndSendStack", "slot", "itemIdStack", "runAsyncWork", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runSyncWork", "logisticspipes"})
public final class ExtractorJob {
    @NotNull
    private final AsyncExtractorModule module;
    @NotNull
    private final Function0<IInventoryUtil> inventoryGetter;
    private int inventorySize;
    private final int slotsPerTick;
    @NotNull
    private final Iterator<Integer> slotStartIter;
    private int itemsLeft;
    private int stacksLeft;
    @NotNull
    private final Channel<Unit> updateRoutingTableMsgChannel;
    @NotNull
    private final Map<Integer, ItemIdentifierStack> slotItemsToExtract;

    public ExtractorJob(@NotNull AsyncExtractorModule module, @NotNull Function0<? extends IInventoryUtil> inventoryGetter) {
        Intrinsics.checkNotNullParameter(module, "module");
        Intrinsics.checkNotNullParameter(inventoryGetter, "inventoryGetter");
        this.module = module;
        this.inventoryGetter = inventoryGetter;
        IInventoryUtil iInventoryUtil = this.inventoryGetter.invoke();
        this.inventorySize = iInventoryUtil != null ? iInventoryUtil.getSizeInventory() : 0;
        this.slotsPerTick = UtilKt.determineSlotsPerTick(this.module.getEveryNthTick(), this.inventorySize);
        this.slotStartIter = this.slotsPerTick == 0 ? CollectionsKt.emptyList().iterator() : (Iterator)IntProgression.Companion.fromClosedRange(0, this.inventorySize - 1, this.slotsPerTick).iterator();
        this.itemsLeft = this.module.getItemsToExtract();
        this.stacksLeft = this.module.getStacksToExtract();
        this.updateRoutingTableMsgChannel = ChannelKt.Channel$default(-1, null, null, 6, null);
        this.slotItemsToExtract = new HashMap();
    }

    public final void runSyncWork() {
        try {
            int n;
            int stopSlot;
            ServerRouter serverRouter = this.module.getServerRouter$logisticspipes();
            IInventoryUtil inventory = this.inventoryGetter.invoke();
            if (this.slotsPerTick == 0 || !this.slotStartIter.hasNext() || serverRouter == null || inventory == null) {
                SendChannel.DefaultImpls.close$default(this.updateRoutingTableMsgChannel, null, 1, null);
                return;
            }
            this.inventorySize = inventory.getSizeInventory();
            int startSlot = ((Number)this.slotStartIter.next()).intValue();
            IntRange slotRange = RangesKt.until(startSlot, stopSlot = this.slotStartIter.hasNext() ? Math.min(this.inventorySize, startSlot + this.slotsPerTick) : this.inventorySize);
            int slot = slotRange.getFirst();
            if (slot <= (n = slotRange.getLast())) {
                while (true) {
                    ItemStack stack;
                    Intrinsics.checkNotNullExpressionValue(inventory.getStackInSlot(slot), "inventory.getStackInSlot(slot)");
                    if (!this.module.getInverseFilter().invoke(stack).booleanValue()) {
                        int toExtract = Math.min(this.itemsLeft, stack.func_190916_E());
                        this.itemsLeft -= toExtract;
                        this.stacksLeft += -1;
                        Integer n2 = slot;
                        this.slotItemsToExtract.put(n2, new ItemIdentifierStack(ItemIdentifier.get(stack), toExtract));
                        if (this.itemsLeft < 1 || this.stacksLeft < 1) break;
                    }
                    if (slot == n) break;
                    ++slot;
                }
            }
            AsyncRouting.INSTANCE.updateServerRouterLsa(serverRouter);
            if (AsyncRouting.INSTANCE.needsRoutingTableUpdate(serverRouter)) {
                this.updateRoutingTableMsgChannel.trySend-JP2dKIU(Unit.INSTANCE);
            } else {
                this.extractAndSend(serverRouter, inventory);
            }
            if (!this.slotStartIter.hasNext()) {
                SendChannel.DefaultImpls.close$default(this.updateRoutingTableMsgChannel, null, 1, null);
            }
        }
        catch (Exception error) {
            this.updateRoutingTableMsgChannel.close(error);
            throw error;
        }
    }

    @Nullable
    public final Object runAsyncWork(@NotNull Continuation<? super Unit> $completion) {
        if (!Configs.DISABLE_ASYNC_WORK) {
            Object object = FlowKt.consumeAsFlow((ReceiveChannel)this.updateRoutingTableMsgChannel).collect(new FlowCollector(this){
                final /* synthetic */ ExtractorJob this$0;
                {
                    this.this$0 = $receiver;
                }

                @Nullable
                public final Object emit(@NotNull Unit it, @NotNull Continuation<? super Unit> $completion) {
                    block0: {
                        ServerRouter serverRouter;
                        ServerRouter serverRouter2 = ExtractorJob.access$getModule$p(this.this$0).getServerRouter$logisticspipes();
                        if (serverRouter2 == null) break block0;
                        ServerRouter serverRouter3 = serverRouter = serverRouter2;
                        boolean bl = false;
                        AsyncRouting.INSTANCE.updateRoutingTable(serverRouter3);
                    }
                    return Unit.INSTANCE;
                }
            }, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    public final void extractAndSend(@NotNull ServerRouter serverRouter, @NotNull IInventoryUtil inventory) {
        Intrinsics.checkNotNullParameter(serverRouter, "serverRouter");
        Intrinsics.checkNotNullParameter(inventory, "inventory");
        Map<Integer, ItemIdentifierStack> $this$forEach$iv = this.slotItemsToExtract;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, ItemIdentifierStack>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Integer, ItemIdentifierStack> element$iv;
            Map.Entry<Integer, ItemIdentifierStack> entry = element$iv = iterator2.next();
            boolean bl = false;
            int slot = ((Number)entry.getKey()).intValue();
            ItemIdentifierStack itemIdStack = entry.getValue();
            this.extractAndSendStack(serverRouter, inventory, slot, itemIdStack);
        }
        this.slotItemsToExtract.clear();
    }

    private final void extractAndSendStack(ServerRouter serverRouter, IInventoryUtil inventory, int slot, ItemIdentifierStack itemIdStack) {
        Sequence<Pair<Integer, SinkReply>> validDestinationSequence2;
        IPipeServiceProvider iPipeServiceProvider = this.module.getService$logisticspipes();
        if (iPipeServiceProvider == null) {
            return;
        }
        IPipeServiceProvider service = iPipeServiceProvider;
        EnumFacing enumFacing = service.getPointedOrientation();
        if (enumFacing == null) {
            return;
        }
        EnumFacing pointedOrientation = enumFacing;
        ItemStack itemStack = inventory.getStackInSlot(slot);
        Intrinsics.checkNotNullExpressionValue(itemStack, "inventory.getStackInSlot(slot)");
        ItemStack stack = itemStack;
        ItemIdentifier itemIdentifier = itemIdStack.getItem();
        Intrinsics.checkNotNullExpressionValue(itemIdentifier, "itemIdStack.item");
        if (!ItemKt.equalsWithNBT(itemIdentifier, stack)) {
            return;
        }
        Ref.IntRef sourceStackLeft = new Ref.IntRef();
        sourceStackLeft.element = itemIdStack.getStackSize();
        ItemIdentifier itemIdentifier2 = ItemIdentifier.get(stack);
        Intrinsics.checkNotNullExpressionValue(itemIdentifier2, "get(stack)");
        Sequence<Pair<Integer, SinkReply>> $this$forEach$iv = validDestinationSequence2 = LogisticsManager.INSTANCE.allDestinations(stack, itemIdentifier2, true, serverRouter, new Function0<Boolean>(sourceStackLeft){
            final /* synthetic */ Ref.IntRef $sourceStackLeft;
            {
                this.$sourceStackLeft = $sourceStackLeft;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$sourceStackLeft.element > 0;
            }
        });
        boolean $i$f$forEach = false;
        Iterator<Pair<Integer, SinkReply>> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            ItemStack toSend;
            Pair<Integer, SinkReply> element$iv;
            Pair<Integer, SinkReply> pair = element$iv = iterator2.next();
            boolean bl = false;
            int destRouterId = ((Number)pair.component1()).intValue();
            SinkReply sinkReply = pair.component2();
            int extract = ItemKt.getExtractionMax(stack.func_190916_E(), sourceStackLeft.element, sinkReply);
            if (extract < 1) continue;
            while (!service.useEnergy(this.module.getEnergyPerItem$logisticspipes() * extract)) {
                service.spawnParticle(Particles.OrangeParticle, 2);
                if (extract < 2) break;
                extract /= 2;
            }
            Intrinsics.checkNotNullExpressionValue(inventory.decrStackSize(slot, extract), "inventory.decrStackSize(slot, extract)");
            if (toSend.func_190926_b()) continue;
            service.sendStack(toSend, destRouterId, sinkReply, this.module.getItemSendMode$logisticspipes(), pointedOrientation);
            sourceStackLeft.element -= toSend.func_190916_E();
        }
    }

    public static final /* synthetic */ AsyncExtractorModule access$getModule$p(ExtractorJob $this) {
        return $this.module;
    }
}

