/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.util;

import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.TuplesKt;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.math.MathKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b!\n\u0002\u0010\u000b\n\u0002\b\u000b\bf\u0018\u00002\u00020\u0001J\u0018\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u0003H\u0016J\u0018\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u0013H\u0016J\u0010\u00104\u001a\u0002052\u0006\u00108\u001a\u00020\u0000H\u0016J\u0010\u00109\u001a\u0002052\u0006\u00108\u001a\u00020\u0000H\u0016J\u0010\u0010:\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0000H&J\u0010\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0003H&J\u0018\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\u0003H&J\u0018\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u00132\u0006\u0010?\u001a\u00020\u0013H&J\u0010\u0010=\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0000H\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0012\u0010\f\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0005R\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0005R\u0014\u0010\u0010\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0005R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u0014\u0010\u001a\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u0014\u0010\u001c\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0015R\u0014\u0010\u001e\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0015R\u0014\u0010 \u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015R\u0014\u0010\"\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0015R\u0014\u0010$\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0005R \u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\tR \u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\tR\u0012\u0010*\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0005R\u0012\u0010,\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0005R\u0014\u0010.\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0005R\u0012\u00100\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0005R\u0014\u00102\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006@\u00c0\u0006\u0001"}, d2={"Lnetwork/rs485/logisticspipes/util/IRectangle;", "", "bottom", "", "getBottom", "()F", "bottomLeft", "Llogisticspipes/kotlin/Pair;", "getBottomLeft", "()Lkotlin/Pair;", "bottomRight", "getBottomRight", "height", "getHeight", "left", "getLeft", "right", "getRight", "roundedBottom", "", "getRoundedBottom", "()I", "roundedHeight", "getRoundedHeight", "roundedLeft", "getRoundedLeft", "roundedRight", "getRoundedRight", "roundedTop", "getRoundedTop", "roundedWidth", "getRoundedWidth", "roundedX", "getRoundedX", "roundedY", "getRoundedY", "top", "getTop", "topLeft", "getTopLeft", "topRight", "getTopRight", "width", "getWidth", "x0", "getX0", "x1", "getX1", "y0", "getY0", "y1", "getY1", "contains", "", "x", "y", "rect", "intersects", "overlap", "scaled", "multiplier", "translated", "translateX", "translateY", "logisticspipes_api"})
public interface IRectangle {
    public float getWidth();

    public float getHeight();

    public float getX0();

    public float getY0();

    default public float getX1() {
        return this.getX0() + this.getWidth();
    }

    default public float getY1() {
        return this.getY0() + this.getHeight();
    }

    default public float getLeft() {
        return this.getX0();
    }

    default public float getRight() {
        return this.getX1();
    }

    default public float getTop() {
        return this.getY0();
    }

    default public float getBottom() {
        return this.getY1();
    }

    @NotNull
    default public Pair<Float, Float> getTopRight() {
        return TuplesKt.to(Float.valueOf(this.getRight()), Float.valueOf(this.getTop()));
    }

    @NotNull
    default public Pair<Float, Float> getTopLeft() {
        return TuplesKt.to(Float.valueOf(this.getLeft()), Float.valueOf(this.getTop()));
    }

    @NotNull
    default public Pair<Float, Float> getBottomLeft() {
        return TuplesKt.to(Float.valueOf(this.getLeft()), Float.valueOf(this.getBottom()));
    }

    @NotNull
    default public Pair<Float, Float> getBottomRight() {
        return TuplesKt.to(Float.valueOf(this.getRight()), Float.valueOf(this.getBottom()));
    }

    default public int getRoundedX() {
        return MathKt.roundToInt(this.getX0());
    }

    default public int getRoundedY() {
        return MathKt.roundToInt(this.getY0());
    }

    default public int getRoundedWidth() {
        return MathKt.roundToInt(this.getWidth());
    }

    default public int getRoundedHeight() {
        return MathKt.roundToInt(this.getHeight());
    }

    default public int getRoundedLeft() {
        return this.getRoundedX();
    }

    default public int getRoundedRight() {
        return MathKt.roundToInt(this.getRight());
    }

    default public int getRoundedTop() {
        return this.getRoundedY();
    }

    default public int getRoundedBottom() {
        return MathKt.roundToInt(this.getBottom());
    }

    @NotNull
    public IRectangle translated(float var1, float var2);

    @NotNull
    public IRectangle translated(int var1, int var2);

    @NotNull
    default public IRectangle translated(@NotNull IRectangle rect) {
        Intrinsics.checkNotNullParameter(rect, "rect");
        return this.translated(rect.getX0(), rect.getY0());
    }

    @NotNull
    public IRectangle scaled(float var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean contains(float x, float y) {
        float f = this.getX0();
        if (!(x <= this.getX1())) return false;
        if (!(f <= x)) return false;
        boolean bl = true;
        if (!bl) return false;
        f = this.getY0();
        if (!(y <= this.getY1())) return false;
        if (!(f <= y)) return false;
        return true;
    }

    default public boolean contains(int x, int y) {
        return this.contains((float)x, (float)y);
    }

    default public boolean contains(@NotNull IRectangle rect) {
        Intrinsics.checkNotNullParameter(rect, "rect");
        return this.contains(rect.getX0(), rect.getY0()) && this.contains(rect.getX1(), rect.getY1());
    }

    default public boolean intersects(@NotNull IRectangle rect) {
        Intrinsics.checkNotNullParameter(rect, "rect");
        return !(this.getRight() < rect.getLeft() || rect.getRight() < this.getLeft() || this.getBottom() < rect.getTop() || rect.getBottom() < this.getTop());
    }

    @NotNull
    public IRectangle overlap(@NotNull IRectangle var1);
}

