/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.markdown;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Lazy;
import logisticspipes.kotlin.LazyKt;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.Triple;
import logisticspipes.kotlin.TuplesKt;
import logisticspipes.kotlin.Unit;
import logisticspipes.kotlin._Assertions;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.collections.IntIterator;
import logisticspipes.kotlin.comparisons.ComparisonsKt;
import logisticspipes.kotlin.jvm.functions.Function0;
import logisticspipes.kotlin.jvm.functions.Function1;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.jvm.internal.Ref;
import logisticspipes.kotlin.ranges.IntRange;
import logisticspipes.kotlin.ranges.RangesKt;
import logisticspipes.kotlin.sequences.Sequence;
import logisticspipes.kotlin.sequences.SequencesKt;
import logisticspipes.kotlin.text.CharsKt;
import logisticspipes.kotlin.text.Charsets;
import logisticspipes.kotlin.text.MatchGroup;
import logisticspipes.kotlin.text.MatchGroupCollection;
import logisticspipes.kotlin.text.MatchResult;
import logisticspipes.kotlin.text.Regex;
import logisticspipes.kotlin.text.RegexOption;
import logisticspipes.kotlin.text.StringsKt;
import network.rs485.markdown.Break;
import network.rs485.markdown.HeaderParagraph;
import network.rs485.markdown.HorizontalLineParagraph;
import network.rs485.markdown.ImageParagraph;
import network.rs485.markdown.InlineElement;
import network.rs485.markdown.ItemLink;
import network.rs485.markdown.Link;
import network.rs485.markdown.LinkFormatting;
import network.rs485.markdown.MarkdownParser;
import network.rs485.markdown.MenuParagraph;
import network.rs485.markdown.MenuParagraphType;
import network.rs485.markdown.PageLink;
import network.rs485.markdown.Paragraph;
import network.rs485.markdown.RegularParagraph;
import network.rs485.markdown.Space;
import network.rs485.markdown.TextFormat;
import network.rs485.markdown.TextFormatting;
import network.rs485.markdown.WebLink;
import network.rs485.markdown.Word;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002,-B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u000e\u001a\u00020\r2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002J,\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\b\b\u0002\u0010\u0016\u001a\u00020\u00062\b\b\u0002\u0010\u0017\u001a\u00020\u0006H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00042\u0006\u0010\u0015\u001a\u00020\rJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\rH\u0002J\u001b\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\"J4\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u001c\u0010#\u001a\u0018\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00040$j\u0002`%H\u0002J\u001b\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b'J0\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u001f0$j\u0002`)H\u0002J\u001b\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b+R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006.\u00b2\u0006\f\u0010/\u001a\u0004\u0018\u000100X\u008a\u0084\u0002"}, d2={"Lnetwork/rs485/markdown/MarkdownParser;", "", "()V", "boldItalicRegexes", "", "Llogisticspipes/kotlin/Pair;", "", "Llogisticspipes/kotlin/text/Regex;", "htmlBreakRegex", "linkRegex", "pathRegex", "webLinkRegex", "bufferOrReturnLine", "", "line", "buffer", "Ljava/lang/StringBuilder;", "Llogisticspipes/kotlin/text/StringBuilder;", "countChars", "char", "", "str", "index", "maximum", "parseLinks", "Lnetwork/rs485/markdown/InlineElement;", "inputChars", "", "parseParagraphs", "Lnetwork/rs485/markdown/Paragraph;", "parseTextElement", "Lnetwork/rs485/markdown/Word;", "word", "splitAndFormatWords", "splitAndFormatWords$logisticspipes", "wordSplitter", "Llogisticspipes/kotlin/Function1;", "Lnetwork/rs485/markdown/TextToElements;", "splitSpacesAndWords", "splitSpacesAndWords$logisticspipes", "makeWord", "Lnetwork/rs485/markdown/WordCreator;", "splitWhitespaceCharactersAndWords", "splitWhitespaceCharactersAndWords$logisticspipes", "LinkMatcher", "ReplacedCharSequence", "logisticspipes", "lineLinkMatch", "Lnetwork/rs485/markdown/MarkdownParser$LinkMatcher;"})
public final class MarkdownParser {
    @NotNull
    public static final MarkdownParser INSTANCE;
    @NotNull
    private static final Regex linkRegex;
    @NotNull
    private static final Regex webLinkRegex;
    @NotNull
    private static final List<Pair<Integer, Regex>> boldItalicRegexes;
    @NotNull
    private static final Regex pathRegex;
    @NotNull
    private static final Regex htmlBreakRegex;

    private MarkdownParser() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<InlineElement> splitWhitespaceCharactersAndWords$logisticspipes(@NotNull CharSequence inputChars) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(inputChars, "inputChars");
        String chars = htmlBreakRegex.replace(inputChars, "\n");
        char[] cArray = new char[]{'\n'};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)chars, cArray, false, 0, 6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void words;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CollectionsKt.plus((Collection)INSTANCE.splitAndFormatWords$logisticspipes((CharSequence)words), (Iterable)CollectionsKt.listOf(Break.INSTANCE)));
        }
        return CollectionsKt.dropLast(CollectionsKt.flatten((List)destination$iv$iv), 1);
    }

    private final List<InlineElement> splitAndFormatWords(CharSequence inputChars, Function1<? super CharSequence, ? extends List<? extends InlineElement>> wordSplitter) {
        CharSequence textLine = StringsKt.trimEnd(inputChars);
        ReplacedCharSequence replacingChars = new ReplacedCharSequence(textLine);
        Iterable $this$forEach$iv = boldItalicRegexes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EnumSet<Enum> enumSet;
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            int level = ((Number)pair.component1()).intValue();
            Regex regex = (Regex)pair.component2();
            switch (level) {
                case 3: {
                    enumSet = EnumSet.of((Enum)TextFormat.Italic, (Enum)TextFormat.Bold);
                    break;
                }
                case 2: {
                    enumSet = EnumSet.of((Enum)TextFormat.Bold);
                    break;
                }
                case 1: {
                    enumSet = EnumSet.of((Enum)TextFormat.Italic);
                    break;
                }
                default: {
                    enumSet = TextFormat.Companion.getNone();
                }
            }
            EnumSet<Enum> format = enumSet;
            Sequence $this$forEach$iv2 = Regex.findAll$default(regex, replacingChars, 0, 2, null);
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                MatchGroup textGroup;
                Object element$iv2 = iterator2.next();
                MatchResult match = (MatchResult)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull(match.getGroups().get(1));
                IntRange intRange = match.getRange();
                IntRange intRange2 = textGroup.getRange();
                Intrinsics.checkNotNullExpressionValue(format, "format");
                replacingChars.addReplacement(intRange, intRange2, format);
            }
            replacingChars.commit();
        }
        ArrayList<InlineElement> mappedWords = new ArrayList<InlineElement>();
        Ref.IntRef startIdx = new Ref.IntRef();
        replacingChars.forEachReplace((Function1<? super Pair<IntRange, ? extends InlineElement>, Unit>)new Function1<Pair<? extends IntRange, ? extends InlineElement>, Unit>(startIdx, mappedWords, wordSplitter, textLine){
            final /* synthetic */ Ref.IntRef $startIdx;
            final /* synthetic */ ArrayList<InlineElement> $mappedWords;
            final /* synthetic */ Function1<CharSequence, List<InlineElement>> $wordSplitter;
            final /* synthetic */ CharSequence $textLine;
            {
                this.$startIdx = $startIdx;
                this.$mappedWords = $mappedWords;
                this.$wordSplitter = $wordSplitter;
                this.$textLine = $textLine;
                super(1);
            }

            public final void invoke(@NotNull Pair<IntRange, ? extends InlineElement> pair) {
                Intrinsics.checkNotNullParameter(pair, "<name for destructuring parameter 0>");
                IntRange range = pair.component1();
                InlineElement inlineElem = pair.component2();
                MarkdownParser.access$splitAndFormatWords$addMappedWords(this.$mappedWords, this.$wordSplitter, this.$textLine, RangesKt.until(this.$startIdx.element, range.getFirst()));
                this.$mappedWords.add(inlineElem);
                this.$startIdx.element = range.getLast() + 1;
            }
        });
        MarkdownParser.splitAndFormatWords$addMappedWords(mappedWords, wordSplitter, textLine, new IntRange(startIdx.element, StringsKt.getLastIndex(replacingChars.getOriginal())));
        return mappedWords;
    }

    @NotNull
    public final List<InlineElement> splitAndFormatWords$logisticspipes(@NotNull CharSequence inputChars) {
        Intrinsics.checkNotNullParameter(inputChars, "inputChars");
        return this.splitAndFormatWords(inputChars, (Function1<? super CharSequence, ? extends List<? extends InlineElement>>)new Function1<CharSequence, List<? extends InlineElement>>((Object)this){

            @NotNull
            public final List<InlineElement> invoke(@NotNull CharSequence p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((MarkdownParser)this.receiver).splitSpacesAndWords$logisticspipes(p0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List<InlineElement> splitSpacesAndWords(CharSequence inputChars, Function1<? super String, Word> makeWord) {
        List list;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        char[] cArray = new char[]{' '};
        Iterable $this$flatMap$iv = StringsKt.split$default(inputChars, cArray, false, 0, 6, null);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String word = (String)element$iv$iv;
            boolean bl = false;
            list$iv$iv = CollectionsKt.listOfNotNull(makeWord.invoke(word));
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$zipWithNext$iv = CollectionsKt.plus((Collection)((List)destination$iv$iv), Space.INSTANCE);
        boolean $i$f$zipWithNext = false;
        Iterator iterator$iv = $this$zipWithNext$iv.iterator();
        if (!iterator$iv.hasNext()) {
            list = CollectionsKt.emptyList();
        } else {
            List result$iv = new ArrayList();
            Object current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                List<Object> list2;
                void right;
                void left;
                Object element$iv$iv;
                Object next$iv = iterator$iv.next();
                element$iv$iv = (InlineElement)next$iv;
                list$iv$iv = (InlineElement)current$iv;
                List list3 = result$iv;
                boolean bl = false;
                if (left instanceof Word && right instanceof Word) {
                    InlineElement[] inlineElementArray = new InlineElement[]{left, Space.INSTANCE};
                    list2 = CollectionsKt.listOf(inlineElementArray);
                } else {
                    list2 = CollectionsKt.listOf(left);
                }
                list3.add(list2);
                current$iv = next$iv;
            }
            list = result$iv;
        }
        return CollectionsKt.flatten(list);
    }

    @NotNull
    public final List<InlineElement> splitSpacesAndWords$logisticspipes(@NotNull CharSequence inputChars) {
        Intrinsics.checkNotNullParameter(inputChars, "inputChars");
        return this.splitSpacesAndWords(inputChars, (Function1<? super String, Word>)new Function1<String, Word>((Object)this){

            @Nullable
            public final Word invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return MarkdownParser.access$parseTextElement((MarkdownParser)this.receiver, p0);
            }
        });
    }

    private final Word parseTextElement(String word) {
        return !StringsKt.isBlank(word) ? new Word(word) : null;
    }

    private final List<InlineElement> parseLinks(CharSequence inputChars) {
        Ref.IntRef lastCharLookedAt = new Ref.IntRef();
        Function0 postfixGetter2 = new Function0<CharSequence>(lastCharLookedAt, inputChars){
            final /* synthetic */ Ref.IntRef $lastCharLookedAt;
            final /* synthetic */ CharSequence $inputChars;
            {
                this.$lastCharLookedAt = $lastCharLookedAt;
                this.$inputChars = $inputChars;
                super(0);
            }

            @NotNull
            public final CharSequence invoke() {
                return this.$lastCharLookedAt.element < this.$inputChars.length() ? this.$inputChars.subSequence(this.$lastCharLookedAt.element, this.$inputChars.length()) : (CharSequence)"";
            }
        };
        Function0 isLastWhitespace2 = new Function0<Boolean>(lastCharLookedAt, inputChars){
            final /* synthetic */ Ref.IntRef $lastCharLookedAt;
            final /* synthetic */ CharSequence $inputChars;
            {
                this.$lastCharLookedAt = $lastCharLookedAt;
                this.$inputChars = $inputChars;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return (1 <= this.$lastCharLookedAt.element ? this.$lastCharLookedAt.element < this.$inputChars.length() : false) && CharsKt.isWhitespace(this.$inputChars.charAt(this.$lastCharLookedAt.element));
            }
        };
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)SequencesKt.toList(SequencesKt.flatMapIterable(SequencesKt.map(Regex.findAll$default(linkRegex, inputChars, 0, 2, null), parseLinks.1.INSTANCE), (Function1)new Function1<LinkMatcher, List<? extends InlineElement>>(inputChars, lastCharLookedAt, (Function0<Boolean>)isLastWhitespace2){
            final /* synthetic */ CharSequence $inputChars;
            final /* synthetic */ Ref.IntRef $lastCharLookedAt;
            final /* synthetic */ Function0<Boolean> $isLastWhitespace;
            {
                this.$inputChars = $inputChars;
                this.$lastCharLookedAt = $lastCharLookedAt;
                this.$isLastWhitespace = $isLastWhitespace;
                super(1);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @NotNull
            public final List<InlineElement> invoke(@NotNull LinkMatcher link) {
                Intrinsics.checkNotNullParameter(link, "link");
                before = this.$inputChars.subSequence(this.$lastCharLookedAt.element, link.getMatch().getRange().getFirst());
                var3_3 /* !! */  = new List[2];
                var4_4 = MarkdownParser.INSTANCE.splitWhitespaceCharactersAndWords$logisticspipes(before);
                var5_5 = this.$isLastWhitespace;
                var6_6 = var4_4;
                var17_8 = 0;
                var16_9 = var3_3 /* !! */ ;
                $i$a$-let-MarkdownParser$parseLinks$2$1 = false;
                var16_9[var17_8] = var18_12 = var5_5.invoke() == false && it.isEmpty() != false ? CollectionsKt.emptyList() : CollectionsKt.plus((Collection)it, (Iterable)CollectionsKt.listOf(Space.INSTANCE));
                v0 = var3_3 /* !! */ ;
                v1 = 1;
                if (link.isPageLink()) {
                    v2 = link.getPath();
                    Intrinsics.checkNotNull(v2);
                    v3 = new PageLink(v2);
                } else if (link.isWebLink()) {
                    v4 = link.getLink();
                    Intrinsics.checkNotNull(v4);
                    v3 = new WebLink(v4);
                } else if (link.isItemLink()) {
                    v5 = link.getPath();
                    Intrinsics.checkNotNull(v5);
                    v3 = new ItemLink(v5);
                } else {
                    v3 = var4_4 = null;
                }
                if (var4_4 == null) ** GOTO lbl-1000
                $i$a$-let-MarkdownParser$parseLinks$2$1 = var4_4;
                var17_8 = v1;
                var16_9 = v0;
                $i$a$-let-MarkdownParser$parseLinks$2$2 = false;
                var9_14 = new List[4];
                var11_16 = var10_15 = new Word("!");
                var12_17 = 0;
                var13_18 = var9_14;
                $i$a$-takeIf-MarkdownParser$parseLinks$2$2$1 = false;
                var15_20 = link.getImageLinkFlag();
                var13_18[var12_17] = CollectionsKt.listOfNotNull(var15_20 != false ? var10_15 : null);
                var9_14[1] = CollectionsKt.listOf(new LinkFormatting((Link)linkRef));
                v6 = link.getText();
                Intrinsics.checkNotNull(v6);
                var9_14[2] = MarkdownParser.INSTANCE.splitAndFormatWords$logisticspipes(v6);
                var9_14[3] = CollectionsKt.listOf(new LinkFormatting(null));
                var18_12 = CollectionsKt.flatten((Iterable)CollectionsKt.listOf(var9_14));
                v0 = var16_9;
                v1 = var17_8;
                var5_5 = var18_12;
                if (var5_5 != null) {
                    v7 = var5_5;
                } else lbl-1000:
                // 2 sources

                {
                    v7 = MarkdownParser.INSTANCE.splitWhitespaceCharactersAndWords$logisticspipes(link.getMatch().getValue());
                }
                v0[v1] = v7;
                var3_3 /* !! */  = CollectionsKt.flatten((Iterable)CollectionsKt.listOf(var3_3 /* !! */ ));
                var4_4 = this.$lastCharLookedAt;
                it /* !! */  = var3_3 /* !! */ ;
                $i$a$-also-MarkdownParser$parseLinks$2$3 = false;
                var4_4.element = link.getMatch().getRange().getLast() + 1;
                return var3_3 /* !! */ ;
            }
        })), (Iterable)((Boolean)isLastWhitespace2.invoke() != false ? CollectionsKt.listOf(Space.INSTANCE) : CollectionsKt.emptyList())), (Iterable)this.splitWhitespaceCharactersAndWords$logisticspipes((CharSequence)postfixGetter2.invoke()));
    }

    private final int countChars(char c, String str, int index, int maximum) {
        int count2;
        if (str.charAt(index) != c) {
            return 0;
        }
        int actualMax = Integer.min(str.length() - index, maximum);
        for (count2 = 1; count2 < actualMax && str.charAt(index + count2) == c; ++count2) {
        }
        return count2;
    }

    static /* synthetic */ int countChars$default(MarkdownParser markdownParser, char c, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = string.length();
        }
        return markdownParser.countChars(c, string, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Paragraph> parseParagraphs(@NotNull String str) {
        void $this$forEach$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(str, "str");
        ArrayList<Paragraph> paragraphs2 = new ArrayList<Paragraph>();
        StringBuilder sb = new StringBuilder();
        char[] cArray = new char[]{'\n'};
        List lines = StringsKt.split$default((CharSequence)str, cArray, false, 0, 6, null);
        Iterable $this$flatMap$iv = lines;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String line = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = INSTANCE.bufferOrReturnLine(line, sb);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LinkMatcher it;
            LinkMatcher linkMatcher;
            String dirtyLine = (String)element$iv;
            boolean bl = false;
            String line = ((Object)StringsKt.trimStart((CharSequence)dirtyLine)).toString();
            Lazy<LinkMatcher> lineLinkMatch$delegate = LazyKt.lazy((Function0)new Function0<LinkMatcher>(line){
                final /* synthetic */ String $line;
                {
                    this.$line = $line;
                    super(0);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final LinkMatcher invoke() {
                    MatchResult matchResult = Regex.find$default(MarkdownParser.access$getLinkRegex$p(), this.$line, 0, 2, null);
                    MatchResult matchResult2 = matchResult;
                    if (matchResult == null) return null;
                    MatchResult matchResult3 = matchResult2;
                    String string = this.$line;
                    MatchResult it = matchResult3;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getValue(), ((Object)StringsKt.trimEnd((CharSequence)string)).toString())) return null;
                    MatchResult matchResult4 = matchResult3;
                    matchResult2 = matchResult4;
                    if (matchResult4 == null) return null;
                    MatchResult it2 = matchResult2;
                    boolean bl2 = false;
                    LinkMatcher linkMatcher = new LinkMatcher(it2);
                    return linkMatcher;
                }
            });
            if (((CharSequence)line).length() == 0) {
                MarkdownParser.parseParagraphs$completeParagraph(sb, paragraphs2);
                continue;
            }
            if (StringsKt.startsWith$default((CharSequence)line, '#', false, 2, null)) {
                int charCount = MarkdownParser.countChars$default(INSTANCE, '#', line, 0, 6, 4, null);
                char[] cArray2 = new char[]{'#'};
                String text = StringsKt.trimStart(line, cArray2);
                if (StringsKt.isBlank(text)) {
                    MarkdownParser.parseParagraphs$lambda-12$dumpLineToBuffer(sb, line);
                    continue;
                }
                if (text.charAt(0) == ' ') {
                    MarkdownParser.parseParagraphs$completeParagraph(sb, paragraphs2);
                    cArray2 = new char[]{'#'};
                    paragraphs2.add(new HeaderParagraph(INSTANCE.parseLinks(StringsKt.trimEnd(text, cArray2)), charCount));
                    continue;
                }
                MarkdownParser.parseParagraphs$lambda-12$dumpLineToBuffer(sb, line);
                continue;
            }
            if (StringsKt.startsWith$default(line, "===", false, 2, null)) {
                Paragraph paragraph;
                if (StringsKt.isBlank(sb)) {
                    paragraph = HorizontalLineParagraph.INSTANCE;
                } else {
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
                    paragraph = new HeaderParagraph(INSTANCE.parseLinks(string), 1);
                }
                paragraphs2.add(paragraph);
                StringsKt.clear(sb);
                continue;
            }
            if (StringsKt.startsWith$default(line, "---", false, 2, null)) {
                Paragraph paragraph;
                if (StringsKt.isBlank(sb)) {
                    paragraph = HorizontalLineParagraph.INSTANCE;
                } else {
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
                    paragraph = new HeaderParagraph(INSTANCE.parseLinks(string), 2);
                }
                paragraphs2.add(paragraph);
                StringsKt.clear(sb);
                continue;
            }
            LinkMatcher linkMatcher2 = MarkdownParser.parseParagraphs$lambda-12$lambda-9(lineLinkMatch$delegate);
            if ((linkMatcher2 != null ? linkMatcher2.getMenuType() : null) != null) {
                LinkMatcher linkMatcher3 = MarkdownParser.parseParagraphs$lambda-12$lambda-9(lineLinkMatch$delegate);
                Intrinsics.checkNotNull(linkMatcher3);
                if (!linkMatcher3.getImageLinkFlag()) {
                    if (MarkdownParser.parseParagraphs$lambda-12$lambda-9(lineLinkMatch$delegate) != null) {
                        it = linkMatcher;
                        boolean bl2 = false;
                        MarkdownParser.parseParagraphs$completeParagraph(sb, paragraphs2);
                        String string = it.getText();
                        Intrinsics.checkNotNull(string);
                        String string2 = it.getPath();
                        Intrinsics.checkNotNull(string2);
                        MenuParagraphType menuParagraphType = it.getMenuType();
                        Intrinsics.checkNotNull((Object)menuParagraphType);
                        paragraphs2.add(new MenuParagraph(string, string2, menuParagraphType));
                    }
                    continue;
                }
            }
            LinkMatcher linkMatcher4 = MarkdownParser.parseParagraphs$lambda-12$lambda-9(lineLinkMatch$delegate);
            boolean bl3 = linkMatcher4 != null ? linkMatcher4.isImageLink() : false;
            if (bl3) {
                LinkMatcher linkMatcher5 = MarkdownParser.parseParagraphs$lambda-12$lambda-9(lineLinkMatch$delegate);
                Intrinsics.checkNotNull(linkMatcher5);
                if (linkMatcher5.getImageLinkFlag()) {
                    if (MarkdownParser.parseParagraphs$lambda-12$lambda-9(lineLinkMatch$delegate) != null) {
                        it = linkMatcher;
                        boolean bl4 = false;
                        MarkdownParser.parseParagraphs$completeParagraph(sb, paragraphs2);
                        String string = it.getText();
                        Intrinsics.checkNotNull(string);
                        String string3 = it.getPath();
                        Intrinsics.checkNotNull(string3);
                        paragraphs2.add(new ImageParagraph(string, string3));
                    }
                    continue;
                }
            }
            MarkdownParser.parseParagraphs$lambda-12$dumpLineToBuffer(sb, line);
        }
        MarkdownParser.parseParagraphs$completeParagraph(sb, paragraphs2);
        return paragraphs2;
    }

    private final List<String> bufferOrReturnLine(String line, StringBuilder buffer) {
        if (StringsKt.endsWith$default((CharSequence)line, '\\', false, 2, null)) {
            String string = line.substring(0, line.length() - 1);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            buffer.append(string);
            return CollectionsKt.emptyList();
        }
        if (StringsKt.endsWith$default(line, "  ", false, 2, null)) {
            String string = line.substring(0, line.length() - 2);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            buffer.append(string);
            buffer.append('\n');
        } else {
            buffer.append(line);
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue(string, "buffer.toString()");
        String concatLine = string;
        StringsKt.clear(buffer);
        return CollectionsKt.listOf(concatLine);
    }

    private static final void splitAndFormatWords$addMappedWords(ArrayList<InlineElement> mappedWords, Function1<? super CharSequence, ? extends List<? extends InlineElement>> $wordSplitter, CharSequence textLine, IntRange originalRange) {
        if (originalRange.isEmpty()) {
            return;
        }
        mappedWords.addAll((Collection<InlineElement>)$wordSplitter.invoke(StringsKt.subSequence(textLine, originalRange)));
    }

    private static final void parseParagraphs$completeParagraph(StringBuilder sb, ArrayList<Paragraph> paragraphs2) {
        if (!StringsKt.isBlank(sb)) {
            paragraphs2.add(new RegularParagraph(INSTANCE.parseLinks(sb)));
        }
        StringsKt.clear(sb);
    }

    private static final void parseParagraphs$lambda-12$dumpLineToBuffer(StringBuilder sb, String line) {
        if (((CharSequence)sb).length() > 0) {
            sb.append(' ');
        }
        sb.append(line);
    }

    private static final LinkMatcher parseParagraphs$lambda-12$lambda-9(Lazy<LinkMatcher> $lineLinkMatch$delegate) {
        Lazy<LinkMatcher> lazy = $lineLinkMatch$delegate;
        return lazy.getValue();
    }

    public static final /* synthetic */ void access$splitAndFormatWords$addMappedWords(ArrayList mappedWords, Function1 $wordSplitter, CharSequence textLine, IntRange originalRange) {
        MarkdownParser.splitAndFormatWords$addMappedWords(mappedWords, $wordSplitter, textLine, originalRange);
    }

    public static final /* synthetic */ Word access$parseTextElement(MarkdownParser $this, String word) {
        return $this.parseTextElement(word);
    }

    public static final /* synthetic */ Regex access$getLinkRegex$p() {
        return linkRegex;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        INSTANCE = new MarkdownParser();
        linkRegex = new Regex("!?\\[(.+?)]\\((.+?)\\)");
        webLinkRegex = new Regex("^https?://.+", RegexOption.IGNORE_CASE);
        Iterable $this$flatMap$iv = RangesKt.downTo(3, 1);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv2;
            int element$iv$iv;
            int times = element$iv$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            String[] stringArray = new String[]{"_", "\\*"};
            Iterable $this$map$iv = CollectionsKt.listOf(stringArray);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(TuplesKt.to(times, StringsKt.repeat((CharSequence)it, times)));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int times = ((Number)pair.component1()).intValue();
            String formatChain = (String)pair.component2();
            collection.add(TuplesKt.to(times, new Regex("(?!\\\\)" + formatChain + "(.+?)(?!\\\\)" + formatChain)));
        }
        boldItalicRegexes = (List)var3_3;
        pathRegex = new Regex("^.*?://([^?]+)");
        htmlBreakRegex = new Regex("<br(\\s*/)?>");
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0006\u0010 \u001a\u00020\u0006J\u0006\u0010!\u001a\u00020\u0006J\u0006\u0010\"\u001a\u00020\u0006J\u0006\u0010#\u001a\u00020\u0006R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\fR\u001d\u0010\u0018\u001a\u0004\u0018\u00010\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006$"}, d2={"Lnetwork/rs485/markdown/MarkdownParser$LinkMatcher;", "", "match", "Llogisticspipes/kotlin/text/MatchResult;", "(Lkotlin/text/MatchResult;)V", "imageLinkFlag", "", "getImageLinkFlag", "()Z", "link", "", "getLink", "()Ljava/lang/String;", "getMatch", "()Lkotlin/text/MatchResult;", "path", "getPath", "queryComponents", "", "Lorg/apache/http/NameValuePair;", "getQueryComponents", "()Ljava/util/List;", "text", "getText", "uri", "Ljava/net/URI;", "getUri", "()Ljava/net/URI;", "uri$delegate", "Llogisticspipes/kotlin/Lazy;", "getMenuType", "Lnetwork/rs485/markdown/MenuParagraphType;", "isImageLink", "isItemLink", "isPageLink", "isWebLink", "logisticspipes"})
    private static final class LinkMatcher {
        @NotNull
        private final MatchResult match;
        @NotNull
        private final Lazy uri$delegate;

        public LinkMatcher(@NotNull MatchResult match) {
            Intrinsics.checkNotNullParameter(match, "match");
            this.match = match;
            this.uri$delegate = LazyKt.lazy((Function0)new Function0<URI>(this){
                final /* synthetic */ LinkMatcher this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final URI invoke() {
                    URI uRI;
                    String string = this.this$0.getLink();
                    if (string != null) {
                        URI uRI2;
                        String it = string;
                        boolean bl = false;
                        try {
                            uRI2 = new URI(it);
                        }
                        catch (URISyntaxException error) {
                            uRI2 = null;
                        }
                        uRI = uRI2;
                    } else {
                        uRI = null;
                    }
                    return uRI;
                }
            });
        }

        @NotNull
        public final MatchResult getMatch() {
            return this.match;
        }

        @Nullable
        public final String getText() {
            MatchGroup matchGroup = this.match.getGroups().get(1);
            return matchGroup != null ? matchGroup.getValue() : null;
        }

        @Nullable
        public final String getLink() {
            MatchGroup matchGroup = this.match.getGroups().get(2);
            return matchGroup != null ? matchGroup.getValue() : null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final String getPath() {
            String string = this.getLink();
            Object object = string;
            if (string == null) return null;
            String it = object;
            boolean bl = false;
            MatchResult matchResult = Regex.find$default(pathRegex, it, 0, 2, null);
            object = matchResult;
            if (matchResult == null) return null;
            MatchGroupCollection matchGroupCollection = object.getGroups();
            object = matchGroupCollection;
            if (matchGroupCollection == null) return null;
            MatchGroup matchGroup = object.get(1);
            object = matchGroup;
            if (matchGroup == null) return null;
            String string2 = ((MatchGroup)object).getValue();
            return string2;
        }

        public final boolean getImageLinkFlag() {
            return StringsKt.startsWith$default((CharSequence)((Object)StringsKt.trimStart((CharSequence)this.match.getValue())).toString(), '!', false, 2, null);
        }

        @Nullable
        public final URI getUri() {
            Lazy lazy = this.uri$delegate;
            return (URI)lazy.getValue();
        }

        @NotNull
        public final List<NameValuePair> getQueryComponents() {
            List list;
            List list2;
            URI uRI = this.getUri();
            if (uRI != null) {
                URI it = uRI;
                boolean bl = false;
                list2 = URLEncodedUtils.parse((String)it.getQuery(), (Charset)Charsets.UTF_8);
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        @Nullable
        public final MenuParagraphType getMenuType() {
            MenuParagraphType menuParagraphType;
            URI uRI = this.getUri();
            if (Intrinsics.areEqual(uRI != null ? uRI.getScheme() : null, "menu")) {
                Object v1;
                block3: {
                    Iterable iterable = this.getQueryComponents();
                    for (Object t : iterable) {
                        NameValuePair it = (NameValuePair)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getName(), "type")) continue;
                        v1 = t;
                        break block3;
                    }
                    v1 = null;
                }
                NameValuePair type = v1;
                boolean bl = false;
                menuParagraphType = type == null ? MenuParagraphType.LIST : (Intrinsics.areEqual(type.getValue(), "list") ? MenuParagraphType.LIST : (Intrinsics.areEqual(type.getValue(), "tile") ? MenuParagraphType.TILE : null));
            } else {
                menuParagraphType = null;
            }
            return menuParagraphType;
        }

        public final boolean isPageLink() {
            String string = this.getLink();
            return string != null ? StringsKt.startsWith(string, "page://", true) : false;
        }

        public final boolean isWebLink() {
            boolean bl;
            String string = this.getLink();
            if (string != null) {
                CharSequence charSequence = string;
                bl = webLinkRegex.matches(charSequence);
            } else {
                bl = false;
            }
            return bl;
        }

        public final boolean isImageLink() {
            String string = this.getLink();
            return string != null ? StringsKt.startsWith(string, "image://", true) : false;
        }

        public final boolean isItemLink() {
            String string = this.getLink();
            return string != null ? StringsKt.startsWith(string, "item://", true) : false;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J\u0006\u0010!\u001a\u00020\u001aJ\u001e\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0$H\u0002J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J&\u0010)\u001a\u00020\u001a2\u001e\u0010*\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u000b\u0012\u0004\u0012\u00020\u001a0+J\u0011\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\fH\u0096\u0002J\b\u0010/\u001a\u00020\fH\u0016J\u000e\u00100\u001a\u00020&2\u0006\u0010.\u001a\u00020\fJ6\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u000b2\u0006\u0010.\u001a\u00020\f2\u0006\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0016H\u0002J\u0018\u00105\u001a\u00020&2\u0006\u0010.\u001a\u00020\f2\u0006\u00104\u001a\u00020\u0016H\u0002J\u0010\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020\fH\u0002J\u0018\u00108\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0016H\u0002J\u0018\u00109\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\f2\u0006\u0010;\u001a\u00020\fH\u0016J\b\u0010<\u001a\u00020\u0005H\u0016J\u001c\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010>\u001a\u00020\fH\u0002J\b\u0010?\u001a\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0017\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00180\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lnetwork/rs485/markdown/MarkdownParser$ReplacedCharSequence;", "", "original", "(Ljava/lang/CharSequence;)V", "cache", "", "current", "getCurrent", "()Ljava/lang/String;", "formattingStart", "", "Llogisticspipes/kotlin/Pair;", "", "Ljava/util/EnumSet;", "Lnetwork/rs485/markdown/TextFormat;", "length", "getLength", "()I", "getOriginal", "()Ljava/lang/CharSequence;", "replacementMap", "Llogisticspipes/kotlin/ranges/IntRange;", "Lnetwork/rs485/markdown/InlineElement;", "stagingReplacementMap", "Llogisticspipes/kotlin/Triple;", "addReplacement", "", "fullRange", "innerRange", "format", "chars", "Ljava/util/stream/IntStream;", "codePoints", "commit", "enhanceExistingReplacements", "range", "", "equals", "", "other", "", "forEachReplace", "action", "Llogisticspipes/kotlin/Function1;", "get", "", "index", "hashCode", "isWhitespaceAt", "replaceFormattingIfApplicable", "lowRange", "highRange", "element", "replacementIndexIsTextFormatting", "spaceReplacement", "cutIndex", "stageReplacingElement", "subSequence", "startIndex", "endIndex", "toString", "translateIndex", "start", "updateCachedSequence", "logisticspipes"})
    public static final class ReplacedCharSequence
    implements CharSequence {
        @NotNull
        private final CharSequence original;
        @NotNull
        private final List<Pair<Integer, EnumSet<TextFormat>>> formattingStart;
        @NotNull
        private final List<Pair<IntRange, InlineElement>> replacementMap;
        @NotNull
        private final List<Triple<Integer, IntRange, InlineElement>> stagingReplacementMap;
        @Nullable
        private String cache;

        public ReplacedCharSequence(@NotNull CharSequence original) {
            Intrinsics.checkNotNullParameter(original, "original");
            this.original = original;
            this.formattingStart = new ArrayList();
            this.replacementMap = new ArrayList();
            this.stagingReplacementMap = new ArrayList();
        }

        @NotNull
        public final CharSequence getOriginal() {
            return this.original;
        }

        @NotNull
        public final String getCurrent() {
            String string = this.cache;
            if (string == null) {
                string = this.updateCachedSequence();
            }
            return string;
        }

        private final String updateCachedSequence() {
            String string;
            StringBuilder sb = new StringBuilder();
            Function1 append2 = new Function1<IntRange, IntRange>(sb, this){
                final /* synthetic */ StringBuilder $sb;
                final /* synthetic */ ReplacedCharSequence this$0;
                {
                    this.$sb = $sb;
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final IntRange invoke(@NotNull IntRange range) {
                    IntRange intRange;
                    IntRange intRange2;
                    Intrinsics.checkNotNullParameter(range, "range");
                    IntRange it = intRange2 = range;
                    boolean bl = false;
                    IntRange intRange3 = !it.isEmpty() ? intRange2 : null;
                    if (intRange3 != null) {
                        intRange2 = intRange3;
                        StringBuilder stringBuilder = this.$sb;
                        ReplacedCharSequence replacedCharSequence = this.this$0;
                        IntRange it2 = intRange2;
                        boolean bl2 = false;
                        stringBuilder.append(StringsKt.subSequence(replacedCharSequence.getOriginal(), it2));
                        intRange = intRange2;
                    } else {
                        intRange = null;
                    }
                    return intRange;
                }
            };
            int lastIdx = 0;
            Iterable $this$forEach$iv = this.replacementMap;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                Pair pair = (Pair)element$iv;
                boolean bl2 = false;
                IntRange range = (IntRange)pair.component1();
                boolean bl3 = bl = range.getFirst() >= lastIdx;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string2 = "trying to replace already replaced index " + lastIdx + " in " + this.replacementMap;
                    throw new AssertionError((Object)string2);
                }
                append2.invoke(RangesKt.until(lastIdx, range.getFirst()));
                lastIdx = range.getLast() + 1;
            }
            append2.invoke(RangesKt.until(lastIdx, this.original.length()));
            String string3 = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string3, "sb.toString()");
            String it = string = string3;
            boolean bl = false;
            this.cache = it;
            return string;
        }

        private final boolean spaceReplacement(int cutIndex) {
            boolean bl;
            boolean isSpace = bl = this.isWhitespaceAt(cutIndex);
            boolean bl2 = false;
            if (isSpace) {
                this.stageReplacingElement(new IntRange(cutIndex, cutIndex), Space.INSTANCE);
            }
            return bl;
        }

        public final void addReplacement(@NotNull IntRange fullRange, @NotNull IntRange innerRange, @NotNull EnumSet<TextFormat> format) {
            Intrinsics.checkNotNullParameter(fullRange, "fullRange");
            Intrinsics.checkNotNullParameter(innerRange, "innerRange");
            Intrinsics.checkNotNullParameter(format, "format");
            if (fullRange.getFirst() > 0 && !this.spaceReplacement(innerRange.getFirst())) {
                this.spaceReplacement(fullRange.getFirst() - 1);
            }
            this.stageReplacingElement(new IntRange(innerRange.getLast() + 1, fullRange.getLast()), new TextFormatting(TextFormat.Companion.getNone()));
            IntRange intRange = RangesKt.until(fullRange.getFirst(), innerRange.getFirst());
            Object object = format.clone();
            Intrinsics.checkNotNullExpressionValue(object, "format.clone()");
            this.stageReplacingElement(intRange, new TextFormatting((EnumSet<TextFormat>)object));
            this.enhanceExistingReplacements(innerRange, (Set<? extends TextFormat>)format);
            if (fullRange.getLast() + 1 < this.length() && !this.spaceReplacement(innerRange.getLast())) {
                this.spaceReplacement(fullRange.getLast() + 1);
            }
        }

        private final void enhanceExistingReplacements(IntRange range, Set<? extends TextFormat> format) {
            int endReplacementMapIdx = ((Number)this.translateIndex(range.getLast()).component1()).intValue();
            if (endReplacementMapIdx == -1) {
                return;
            }
            int startReplacementMapIdx = ((Number)this.translateIndex(range.getFirst()).component1()).intValue();
            Iterable $this$forEach$iv = this.replacementMap.subList(startReplacementMapIdx + 1, endReplacementMapIdx + 1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                Object b = it.getSecond();
                Object object = b instanceof TextFormatting ? (TextFormatting)b : null;
                if (object == null || (object = ((TextFormatting)object).getFormat()) == null) continue;
                ((AbstractCollection)object).addAll((Collection)format);
            }
        }

        private final void stageReplacingElement(IntRange range, InlineElement element) {
            Pair<Integer, Integer> pair = this.translateIndex(range.getFirst());
            int replacementMapIdx = ((Number)pair.component1()).intValue();
            int translatedIdx = ((Number)pair.component2()).intValue();
            this.stagingReplacementMap.add(new Triple<Integer, IntRange, InlineElement>(replacementMapIdx + 1, new IntRange(translatedIdx, range.getLast() + translatedIdx - range.getFirst()), element));
            if (element instanceof TextFormatting) {
                Pair<Integer, EnumSet<TextFormat>> newFormat = TuplesKt.to(translatedIdx, ((TextFormatting)element).getFormat());
                if (this.formattingStart.isEmpty()) {
                    this.formattingStart.add(newFormat);
                } else {
                    int index;
                    int formatIdx = CollectionsKt.binarySearch$default(this.formattingStart, newFormat, ReplacedCharSequence::stageReplacingElement$lambda-5, 0, 0, 12, null);
                    int n = index = formatIdx < 0 ? -formatIdx - 1 : formatIdx + 1;
                    if (index > 0) {
                        newFormat.getSecond().addAll((Collection<TextFormat>)this.formattingStart.get(index - 1).getSecond());
                    }
                    this.formattingStart.add(index, newFormat);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Integer, Integer> translateIndex(int start) {
            void $this$forEachIndexed$iv;
            Ref.IntRef translatedIdx = new Ref.IntRef();
            translatedIdx.element = start;
            int replacementMapIdx = 0;
            replacementMapIdx = -1;
            Sequence sequence2 = SequencesKt.takeWhile(CollectionsKt.asSequence((Iterable)this.replacementMap), (Function1)new Function1<Pair<? extends IntRange, ? extends InlineElement>, Boolean>(translatedIdx){
                final /* synthetic */ Ref.IntRef $translatedIdx;
                {
                    this.$translatedIdx = $translatedIdx;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Pair<IntRange, ? extends InlineElement> it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.$translatedIdx.element >= it.getFirst().getFirst();
                }
            });
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair = (Pair)item$iv;
                int curry = n;
                boolean bl = false;
                IntRange range = (IntRange)pair.component1();
                translatedIdx.element += CollectionsKt.count(range);
                replacementMapIdx = curry;
            }
            return TuplesKt.to(replacementMapIdx, translatedIdx.element);
        }

        public final void commit() {
            if (!((Collection)this.stagingReplacementMap).isEmpty()) {
                Iterable $this$sortedByDescending$iv = this.stagingReplacementMap;
                boolean $i$f$sortedByDescending = false;
                Iterable $this$forEach$iv = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Triple it = (Triple)b;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(((IntRange)it.getSecond()).getLast());
                        it = (Triple)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, ((IntRange)it.getSecond()).getLast());
                    }
                });
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object object;
                    Integer n;
                    Object object2;
                    Integer n2;
                    Triple triple = (Triple)element$iv;
                    boolean bl = false;
                    int index = ((Number)triple.component1()).intValue();
                    IntRange replaceRange = (IntRange)triple.component2();
                    InlineElement element = (InlineElement)triple.component3();
                    Serializable serializable = index - 1;
                    int it = ((Number)serializable).intValue();
                    boolean bl2 = false;
                    Integer n3 = n2 = this.replacementIndexIsTextFormatting(it, element) ? serializable : null;
                    if (n2 != null) {
                        int previousIdx = ((Number)n2).intValue();
                        boolean bl3 = false;
                        serializable = this.replaceFormattingIfApplicable(previousIdx, this.replacementMap.get(previousIdx).getFirst(), replaceRange, element);
                        if (serializable != null) {
                            object2 = serializable;
                            continue;
                        }
                    }
                    Integer n4 = index;
                    int it2 = ((Number)n4).intValue();
                    boolean bl4 = false;
                    Integer n5 = n = this.replacementIndexIsTextFormatting(index, element) ? n4 : null;
                    if (n != null) {
                        int idx = ((Number)n).intValue();
                        boolean bl5 = false;
                        object = this.replaceFormattingIfApplicable(idx, replaceRange, this.replacementMap.get(idx).getFirst(), this.replacementMap.get(idx).getSecond());
                    } else {
                        object = object2 = null;
                    }
                    if (object != null) continue;
                    this.replacementMap.add(index, TuplesKt.to(replaceRange, element));
                    object2 = Unit.INSTANCE;
                }
                this.cache = null;
                this.stagingReplacementMap.clear();
            }
        }

        private final boolean replacementIndexIsTextFormatting(int index, InlineElement element) {
            return (0 <= index ? index < this.replacementMap.size() : false) && element instanceof TextFormatting && this.replacementMap.get(index).getSecond() instanceof TextFormatting;
        }

        private final Pair<IntRange, InlineElement> replaceFormattingIfApplicable(int index, IntRange lowRange, IntRange highRange, InlineElement element) {
            Pair<IntRange, InlineElement> pair;
            if (lowRange.getLast() + 1 == highRange.getFirst()) {
                Pair<IntRange, InlineElement> pair2;
                Pair<IntRange, InlineElement> it = pair2 = TuplesKt.to(new IntRange(lowRange.getFirst(), highRange.getLast()), element);
                boolean bl = false;
                this.replacementMap.set(index, it);
                pair = pair2;
            } else {
                pair = null;
            }
            return pair;
        }

        public final void forEachReplace(@NotNull Function1<? super Pair<IntRange, ? extends InlineElement>, Unit> action2) {
            Intrinsics.checkNotNullParameter(action2, "action");
            Iterable $this$forEach$iv = this.replacementMap;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                action2.invoke((Pair<IntRange, ? extends InlineElement>)element$iv);
            }
        }

        public int getLength() {
            return this.getCurrent().length();
        }

        public final boolean isWhitespaceAt(int index) {
            return CharsKt.isWhitespace(this.charAt(index));
        }

        public char get(int index) {
            return this.getCurrent().charAt(index);
        }

        @Override
        @NotNull
        public CharSequence subSequence(int startIndex, int endIndex) {
            return this.getCurrent().subSequence(startIndex, endIndex);
        }

        @Override
        @NotNull
        public IntStream chars() {
            IntStream intStream = this.getCurrent().chars();
            Intrinsics.checkNotNullExpressionValue(intStream, "current.chars()");
            return intStream;
        }

        @Override
        @NotNull
        public IntStream codePoints() {
            IntStream intStream = this.getCurrent().codePoints();
            Intrinsics.checkNotNullExpressionValue(intStream, "current.codePoints()");
            return intStream;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof ReplacedCharSequence && Intrinsics.areEqual(this.original, ((ReplacedCharSequence)other).original) && Intrinsics.areEqual(this.replacementMap, ((ReplacedCharSequence)other).replacementMap);
        }

        public int hashCode() {
            return this.original.hashCode() + ((Object)this.replacementMap).hashCode();
        }

        @Override
        @NotNull
        public String toString() {
            return super.toString() + "(original=\"" + StringsKt.take(this.original, 16) + "[\u2026]\",replacementMap=" + StringsKt.take(this.replacementMap.toString(), 16) + "[\u2026])";
        }

        private static final int stageReplacingElement$lambda-5(Pair o1, Pair o2) {
            return Intrinsics.compare(((Number)o1.getFirst()).intValue(), ((Number)o2.getFirst()).intValue());
        }
    }
}

