/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api.drawable;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.drawable.Icon;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.google.gson.JsonObject;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;

public interface IDrawable {
    public static final IDrawable EMPTY = (context, x, y, width, height, widgetTheme) -> {};
    public static final IDrawable NONE = (context, x, y, width, height, widgetTheme) -> {};

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiContext var1, int var2, int var3, int var4, int var5, WidgetTheme var6);

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    default public void draw(GuiContext context, int x, int y, int width, int height) {
        this.draw(context, x, y, width, height, WidgetTheme.getDefault());
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    default public void drawAtZero(GuiContext context, int width, int height) {
        this.drawAtZero(context, width, height, WidgetTheme.getDefault());
    }

    @SideOnly(value=Side.CLIENT)
    default public void drawAtZero(GuiContext context, int width, int height, WidgetTheme widgetTheme) {
        this.draw(context, 0, 0, width, height, widgetTheme);
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    default public void draw(GuiContext context, Area area) {
        this.draw(context, area.x, area.y, area.width, area.height, WidgetTheme.getDefault());
    }

    @SideOnly(value=Side.CLIENT)
    default public void draw(GuiContext context, Area area, WidgetTheme widgetTheme) {
        this.draw(context, area.x, area.y, area.width, area.height, widgetTheme);
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    default public void drawAtZero(GuiContext context, Area area) {
        this.draw(context, 0, 0, area.width, area.height, WidgetTheme.getDefault());
    }

    @SideOnly(value=Side.CLIENT)
    default public void drawAtZero(GuiContext context, Area area, WidgetTheme widgetTheme) {
        this.draw(context, 0, 0, area.width, area.height, widgetTheme);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.6.0")
    default public void applyThemeColor(ITheme theme, WidgetTheme widgetTheme) {
        Color.setGlColorOpaque(Color.WHITE.main);
    }

    default public boolean canApplyTheme() {
        return false;
    }

    default public Widget<?> asWidget() {
        return new DrawableWidget(this);
    }

    default public Icon asIcon() {
        return new Icon(this);
    }

    default public void loadFromJson(JsonObject json) {
    }

    public static class DrawableWidget
    extends Widget<DrawableWidget> {
        private final IDrawable drawable;

        public DrawableWidget(IDrawable drawable) {
            this.drawable = drawable;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void draw(GuiContext context, WidgetTheme widgetTheme) {
            this.drawable.drawAtZero(context, this.getArea());
        }
    }
}

